/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.physics.collision.simple;

import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.geometry.interfaces.BoundingBox3DBasics;
import us.ihmc.euclid.shape.convexPolytope.ConvexPolytope3D;
import us.ihmc.euclid.shape.convexPolytope.interfaces.ConvexPolytope3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.simulationconstructionset.physics.CollisionShapeDescription;

public class PolytopeShapeDescription<T extends PolytopeShapeDescription<T>>
implements CollisionShapeDescription<T> {
    private final ConvexPolytope3D polytope;
    private double smoothingRadius = 0.0;

    public PolytopeShapeDescription(ConvexPolytope3D polytope) {
        this.polytope = polytope;
    }

    @Override
    public PolytopeShapeDescription<T> copy() {
        ConvexPolytope3D polytopeCopy = new ConvexPolytope3D((ConvexPolytope3DReadOnly)this.polytope);
        PolytopeShapeDescription<T> copy = new PolytopeShapeDescription<T>(polytopeCopy);
        copy.setSmoothingRadius(this.smoothingRadius);
        return copy;
    }

    public ConvexPolytope3D getPolytope() {
        return this.polytope;
    }

    @Override
    public void setFrom(T polytopeShapeDescription) {
        this.polytope.set(((PolytopeShapeDescription)polytopeShapeDescription).getPolytope());
    }

    @Override
    public void applyTransform(RigidBodyTransform transform) {
        this.polytope.applyTransform((Transform)transform);
    }

    public void setSmoothingRadius(double smoothingRadius) {
        this.smoothingRadius = smoothingRadius;
    }

    public double getSmoothingRadius() {
        return this.smoothingRadius;
    }

    @Override
    public void getBoundingBox(BoundingBox3D boundingBoxToPack) {
        this.polytope.getBoundingBox((BoundingBox3DBasics)boundingBoxToPack);
    }

    @Override
    public boolean isPointInside(Point3D pointInWorld) {
        return this.polytope.isPointInside((Point3DReadOnly)pointInWorld);
    }

    @Override
    public boolean rollContactIfRolling(Vector3D surfaceNormal, Point3D pointToRoll) {
        if (this.smoothingRadius != 0.0) {
            throw new RuntimeException("Implement me for nonzero smoothing radius!");
        }
        return false;
    }
}

