/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.gui.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;

public class YoGraphicsPropertiesDialog
extends JDialog
implements ActionListener {
    private JButton okButton;
    private JButton applyButton;
    private JButton cancelButton;
    private YoGraphicsPropertiesPanel yoGraphicsPropertiesPanel;
    private JFrame ownerFrame;
    private Container parentContainer;
    private SimulationConstructionSet sim;

    public YoGraphicsPropertiesDialog(Container parentContainer, JFrame ownerFrame, SimulationConstructionSet sim) {
        super(ownerFrame, "YoGraphics Properties", false);
        this.parentContainer = parentContainer;
        this.ownerFrame = ownerFrame;
        this.sim = sim;
        Container contentPane = this.getContentPane();
        this.yoGraphicsPropertiesPanel = new YoGraphicsPropertiesPanel();
        contentPane.add(this.yoGraphicsPropertiesPanel);
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(this);
        this.applyButton = new JButton("Apply");
        this.applyButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.applyButton);
        buttonPanel.add(this.cancelButton);
        contentPane.add((Component)buttonPanel, "South");
        Point point = parentContainer.getLocation();
        Dimension frameSize = parentContainer.getSize();
        point.translate(frameSize.width / 2, frameSize.height / 4);
        this.setLocation(point);
        this.setResizable(false);
        this.pack();
        this.pack();
        this.setVisible(true);
        parentContainer.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.cancelButton) {
            this.setVisible(false);
        }
        if (event.getSource() == this.applyButton) {
            this.yoGraphicsPropertiesPanel.commitChanges();
        }
        if (event.getSource() == this.okButton) {
            this.yoGraphicsPropertiesPanel.commitChanges();
            this.setVisible(false);
        }
        this.parentContainer.repaint();
    }

    public class YoGraphicsPropertiesPanel
    extends JPanel
    implements ActionListener {
        private static final long serialVersionUID = -4338288396995414370L;
        private double newYoGraphicsGlobalScaleVal;
        private GridBagLayout gridBagLayout = new GridBagLayout();
        private JTextField yoGraphicsGlobalScaleTextField = new JTextField();
        private JLabel yoGraphicsGlobalScaleLabel = new JLabel();

        public YoGraphicsPropertiesPanel() {
            this.setLayout(this.gridBagLayout);
            this.yoGraphicsGlobalScaleLabel.setText("YoGraphics Global Scale:");
            this.yoGraphicsGlobalScaleTextField.setMinimumSize(new Dimension(60, 21));
            this.yoGraphicsGlobalScaleTextField.setPreferredSize(new Dimension(60, 21));
            this.add((Component)this.yoGraphicsGlobalScaleLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 6, 0, 0), 6, 0));
            this.add((Component)this.yoGraphicsGlobalScaleTextField, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.newYoGraphicsGlobalScaleVal = YoGraphicsPropertiesDialog.this.sim.getGlobalYoGraphicsScale();
            this.yoGraphicsGlobalScaleTextField.setText(String.valueOf(this.newYoGraphicsGlobalScaleVal));
            Border blackLine = BorderFactory.createLineBorder(Color.black);
            this.setBorder(blackLine);
        }

        public void commitChanges() {
            this.updateYoGraphicsGlobalScaleTextField();
            YoGraphicsPropertiesDialog.this.sim.setYoGraphicsGlobalScale(this.newYoGraphicsGlobalScaleVal);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == this.yoGraphicsGlobalScaleTextField) {
                this.updateYoGraphicsGlobalScaleTextField();
            }
        }

        private void updateYoGraphicsGlobalScaleTextField() {
            String text = this.yoGraphicsGlobalScaleTextField.getText();
            try {
                this.newYoGraphicsGlobalScaleVal = Double.parseDouble(text);
                if (this.newYoGraphicsGlobalScaleVal < 0.0) {
                    this.newYoGraphicsGlobalScaleVal = Math.abs(this.newYoGraphicsGlobalScaleVal);
                    this.yoGraphicsGlobalScaleTextField.setText(String.valueOf(this.newYoGraphicsGlobalScaleVal));
                }
            }
            catch (NumberFormatException e) {
                this.yoGraphicsGlobalScaleTextField.setText(String.valueOf(this.newYoGraphicsGlobalScaleVal));
            }
        }
    }
}

