/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.gui.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;

public class PlaybackPropertiesDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -8226475433536336684L;
    private JButton okButton;
    private JButton applyButton;
    private JButton cancelButton;
    private PlaybackPropertiesPanel playbackPropertiesPanel;
    private JFrame ownerFrame;
    private Container parentContainer;
    private SimulationConstructionSet sim;

    public PlaybackPropertiesDialog(Container parentContainer, JFrame ownerFrame, SimulationConstructionSet sim) {
        super(ownerFrame, "Playback Properties", false);
        this.parentContainer = parentContainer;
        this.ownerFrame = ownerFrame;
        this.sim = sim;
        Container contentPane = this.getContentPane();
        this.playbackPropertiesPanel = new PlaybackPropertiesPanel();
        contentPane.add(this.playbackPropertiesPanel);
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(this);
        this.applyButton = new JButton("Apply");
        this.applyButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.applyButton);
        buttonPanel.add(this.cancelButton);
        contentPane.add((Component)buttonPanel, "South");
        Point point = parentContainer.getLocation();
        Dimension frameSize = parentContainer.getSize();
        point.translate(frameSize.width / 2, frameSize.height / 4);
        this.setLocation(point);
        this.setResizable(false);
        this.pack();
        this.pack();
        this.setVisible(true);
        parentContainer.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.cancelButton) {
            this.setVisible(false);
        }
        if (event.getSource() == this.applyButton) {
            this.playbackPropertiesPanel.commitChanges();
        }
        if (event.getSource() == this.okButton) {
            this.playbackPropertiesPanel.commitChanges();
            this.setVisible(false);
        }
        this.parentContainer.repaint();
    }

    public class PlaybackPropertiesPanel
    extends JPanel
    implements ActionListener {
        private static final long serialVersionUID = -6809250560000939671L;
        private double newRealTimeVal;
        private double newFrameRateVal;
        private double newSimulateDurationVal;
        private GridBagLayout gridBagLayout1 = new GridBagLayout();
        private JCheckBox updateGraphsDuringPlaybackCheckbox = new JCheckBox();
        private JLabel realTimeRateLabel = new JLabel();
        private JLabel desiredFrameRateLabel = new JLabel();
        private JLabel simulateDurationLabel = new JLabel();
        private JTextField realTimeTextField = new JTextField();
        private JTextField frameRateTextField = new JTextField();
        private JTextField simulateDurationTextField = new JTextField();
        private JCheckBox simulateNoFasterThanRealTimeCheckbox = new JCheckBox();

        public PlaybackPropertiesPanel() {
            this.setLayout(this.gridBagLayout1);
            this.updateGraphsDuringPlaybackCheckbox.setText("Update Graphs");
            this.realTimeRateLabel.setText("Real Time Rate:");
            this.desiredFrameRateLabel.setText("Desired Frame Rate:");
            this.simulateDurationLabel.setText("Simulate Duration:");
            this.realTimeTextField.setMinimumSize(new Dimension(60, 21));
            this.realTimeTextField.setPreferredSize(new Dimension(60, 21));
            this.frameRateTextField.setMinimumSize(new Dimension(60, 21));
            this.frameRateTextField.setPreferredSize(new Dimension(60, 21));
            this.simulateDurationTextField.setMinimumSize(new Dimension(60, 21));
            this.simulateDurationTextField.setPreferredSize(new Dimension(60, 21));
            this.simulateNoFasterThanRealTimeCheckbox.setText("Simulate No Faster Than Real Time");
            this.add((Component)this.updateGraphsDuringPlaybackCheckbox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.realTimeRateLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 6, 0, 0), 6, 0));
            this.add((Component)this.desiredFrameRateLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 6, 0, 0), 6, 0));
            this.add((Component)this.simulateDurationLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 6, 0, 0), 6, 0));
            this.add((Component)this.realTimeTextField, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.frameRateTextField, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.simulateDurationTextField, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.simulateNoFasterThanRealTimeCheckbox, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.newRealTimeVal = PlaybackPropertiesDialog.this.sim.getPlaybackRealTimeRate();
            this.newFrameRateVal = PlaybackPropertiesDialog.this.sim.getPlaybackFrameRate();
            this.newSimulateDurationVal = PlaybackPropertiesDialog.this.sim.getSimulateDuration();
            this.updateGraphsDuringPlaybackCheckbox.setSelected(PlaybackPropertiesDialog.this.sim.areGraphsUpdatedDuringPlayback());
            this.realTimeTextField.setText(String.valueOf(this.newRealTimeVal));
            this.frameRateTextField.setText(String.valueOf(this.newFrameRateVal));
            this.simulateDurationTextField.setText(String.valueOf(this.newSimulateDurationVal));
            this.simulateNoFasterThanRealTimeCheckbox.setSelected(PlaybackPropertiesDialog.this.sim.getSimulateNoFasterThanRealTime());
            Border blackLine = BorderFactory.createLineBorder(Color.black);
            this.setBorder(blackLine);
        }

        public void commitChanges() {
            this.updateRealTimeTextField();
            this.updateFrameRateTextField();
            this.updateSimulateDurationTextField();
            PlaybackPropertiesDialog.this.sim.setSimulateNoFasterThanRealTime(this.simulateNoFasterThanRealTimeCheckbox.isSelected());
            PlaybackPropertiesDialog.this.sim.setPlaybackRealTimeRate(this.newRealTimeVal);
            PlaybackPropertiesDialog.this.sim.setPlaybackDesiredFrameRate(this.newFrameRateVal);
            PlaybackPropertiesDialog.this.sim.setSimulateDuration(this.newSimulateDurationVal);
            PlaybackPropertiesDialog.this.sim.setGraphsUpdatedDuringPlayback(this.updateGraphsDuringPlaybackCheckbox.isSelected());
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == this.realTimeTextField) {
                this.updateRealTimeTextField();
            }
            if (event.getSource() == this.frameRateTextField) {
                this.updateFrameRateTextField();
            }
            if (event.getSource() == this.simulateDurationTextField) {
                this.updateSimulateDurationTextField();
            }
        }

        private void updateRealTimeTextField() {
            String text = this.realTimeTextField.getText();
            try {
                double val;
                this.newRealTimeVal = val = Double.parseDouble(text);
            }
            catch (NumberFormatException e) {
                this.realTimeTextField.setText(String.valueOf(this.newRealTimeVal));
            }
        }

        private void updateFrameRateTextField() {
            String text = this.frameRateTextField.getText();
            try {
                double val;
                this.newFrameRateVal = val = Double.parseDouble(text);
            }
            catch (NumberFormatException e) {
                this.frameRateTextField.setText(String.valueOf(this.newFrameRateVal));
            }
        }

        private void updateSimulateDurationTextField() {
            String text = this.simulateDurationTextField.getText();
            try {
                double val;
                this.newSimulateDurationVal = val = Double.parseDouble(text);
            }
            catch (NumberFormatException e) {
                this.simulateDurationTextField.setText(String.valueOf(this.newSimulateDurationVal));
            }
        }
    }
}

