/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.util.ground;

import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.simulationconstructionset.util.ground.GroundProfileFromHeightMap;

public class SingleStepGroundProfile
extends GroundProfileFromHeightMap {
    private final BoundingBox3D boundingBox;
    private final double groundXStep;
    private final double groundZStep;

    public SingleStepGroundProfile(double xMin, double xMax, double yMin, double yMax, double groundXStep, double groundZStep) {
        double zMin = Double.NEGATIVE_INFINITY;
        double zMax = Math.max(0.0, groundZStep) + 0.01;
        this.boundingBox = new BoundingBox3D(xMin, yMin, zMin, xMax, yMax, zMax);
        this.groundXStep = groundXStep;
        this.groundZStep = groundZStep;
    }

    public double heightAndNormalAt(double x, double y, double z, Vector3DBasics normalToPack) {
        double height = this.heightAt(x, y, z);
        this.surfaceNormalAt(x, y, z, normalToPack);
        return height;
    }

    public double heightAt(double x, double y, double z) {
        if (x < this.groundXStep) {
            return 0.0;
        }
        return this.groundZStep;
    }

    public void surfaceNormalAt(double x, double y, double z, Vector3DBasics normal) {
        normal.set(0.0, 0.0, 1.0);
    }

    public BoundingBox3D getBoundingBox() {
        return this.boundingBox;
    }
}

