/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.physics.engine.featherstone;

import us.ihmc.commons.MathTools;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixBasics;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.simulationconstructionset.Joint;
import us.ihmc.simulationconstructionset.PinJoint;
import us.ihmc.simulationconstructionset.physics.engine.featherstone.JointPhysics;

public class PinJointPhysics
extends JointPhysics<PinJoint> {
    private Vector3D vel_iXd_i = new Vector3D();
    private Vector3D w_hXr_i = new Vector3D();
    private Vector3D vel_i = new Vector3D();
    private Vector3D temp1 = new Vector3D();
    private Vector3D temp2 = new Vector3D();
    private Vector3D temp3 = new Vector3D();
    private double[] k_qdd = new double[4];
    private double[] k_qd = new double[4];
    private double q_n;
    private double qd_n;

    public PinJointPhysics(PinJoint owner) {
        super(owner);
    }

    @Override
    protected void jointDependentChangeVelocity(double delta_qd) {
        ((PinJoint)this.owner).getQDYoVariable().set(((PinJoint)this.owner).getQDYoVariable().getDoubleValue() + delta_qd);
    }

    @Override
    protected void jointDependentSetAndGetRotation(RotationMatrixBasics Rh_i) {
        Rh_i.setIdentity();
        double cosQ = Math.cos(((PinJoint)this.owner).getQYoVariable().getDoubleValue());
        double sinQ = Math.sin(((PinJoint)this.owner).getQYoVariable().getDoubleValue());
        double one_cosQ = 1.0 - cosQ;
        double one_sinQ = 1.0 - sinQ;
        double ux_sinQ = this.u_i.getX() * sinQ;
        double uy_sinQ = this.u_i.getY() * sinQ;
        double uz_sinQ = this.u_i.getZ() * sinQ;
        double uxy_one_cosQ = this.u_i.getX() * this.u_i.getY() * one_cosQ;
        double uxz_one_cosQ = this.u_i.getX() * this.u_i.getZ() * one_cosQ;
        double uyz_one_cosQ = this.u_i.getY() * this.u_i.getZ() * one_cosQ;
        double m00 = cosQ + this.u_i.getX() * this.u_i.getX() * one_cosQ;
        double m01 = uxy_one_cosQ - uz_sinQ;
        double m02 = uxz_one_cosQ + uy_sinQ;
        double m10 = uxy_one_cosQ + uz_sinQ;
        double m11 = cosQ + this.u_i.getY() * this.u_i.getY() * one_cosQ;
        double m12 = uyz_one_cosQ - ux_sinQ;
        double m20 = uxz_one_cosQ - uy_sinQ;
        double m21 = uyz_one_cosQ + ux_sinQ;
        double m22 = cosQ + this.u_i.getZ() * this.u_i.getZ() * one_cosQ;
        Rh_i.set(m00, m01, m02, m10, m11, m12, m20, m21, m22);
    }

    @Override
    protected void jointDependentFeatherstonePassOne() {
        if (((PinJoint)this.owner).torqueSpeedCurve != null) {
            ((PinJoint)this.owner).getTauYoVariable().set(((PinJoint)this.owner).torqueSpeedCurve.limitTorque(((PinJoint)this.owner).getTau(), ((PinJoint)this.owner).getQDYoVariable().getDoubleValue()));
        }
        if (((PinJoint)this.owner).tau_max != null) {
            double maxTorque = ((PinJoint)this.owner).tau_max.getDoubleValue();
            ((PinJoint)this.owner).getTauYoVariable().set(MathTools.clamp((double)((PinJoint)this.owner).getTau(), (double)(-maxTorque), (double)maxTorque));
        }
        this.Q_i = ((PinJoint)this.owner).doPDControl() + ((PinJoint)this.owner).getTau();
        if (((PinJoint)this.owner).tauJointLimit != null) {
            double limitTorque;
            if (((PinJoint)this.owner).getQYoVariable().getDoubleValue() < ((PinJoint)this.owner).qLowerLimit.getDoubleValue()) {
                limitTorque = ((PinJoint)this.owner).kLimit.getDoubleValue() * (((PinJoint)this.owner).qLowerLimit.getDoubleValue() - ((PinJoint)this.owner).getQYoVariable().getDoubleValue()) - ((PinJoint)this.owner).bLimit.getDoubleValue() * ((PinJoint)this.owner).getQDYoVariable().getDoubleValue();
                if (limitTorque < 0.0) {
                    limitTorque = 0.0;
                }
                ((PinJoint)this.owner).tauJointLimit.set(limitTorque);
            } else if (((PinJoint)this.owner).getQYoVariable().getDoubleValue() > ((PinJoint)this.owner).qUpperLimit.getDoubleValue()) {
                limitTorque = ((PinJoint)this.owner).kLimit.getDoubleValue() * (((PinJoint)this.owner).qUpperLimit.getDoubleValue() - ((PinJoint)this.owner).getQYoVariable().getDoubleValue()) - ((PinJoint)this.owner).bLimit.getDoubleValue() * ((PinJoint)this.owner).getQDYoVariable().getDoubleValue();
                if (limitTorque > 0.0) {
                    limitTorque = 0.0;
                }
                ((PinJoint)this.owner).tauJointLimit.set(limitTorque);
            } else {
                ((PinJoint)this.owner).tauJointLimit.set(0.0);
            }
            this.Q_i += ((PinJoint)this.owner).tauJointLimit.getDoubleValue();
        }
        if (((PinJoint)this.owner).tauVelocityLimit != null) {
            if (((PinJoint)this.owner).getQDYoVariable().getDoubleValue() < -((PinJoint)this.owner).qd_max.getDoubleValue()) {
                ((PinJoint)this.owner).tauVelocityLimit.set(-((PinJoint)this.owner).b_vel_limit.getDoubleValue() * (((PinJoint)this.owner).getQDYoVariable().getDoubleValue() + ((PinJoint)this.owner).qd_max.getDoubleValue()));
            } else if (((PinJoint)this.owner).getQDYoVariable().getDoubleValue() > ((PinJoint)this.owner).qd_max.getDoubleValue()) {
                ((PinJoint)this.owner).tauVelocityLimit.set(-((PinJoint)this.owner).b_vel_limit.getDoubleValue() * (((PinJoint)this.owner).getQDYoVariable().getDoubleValue() - ((PinJoint)this.owner).qd_max.getDoubleValue()));
            } else {
                ((PinJoint)this.owner).tauVelocityLimit.set(0.0);
            }
            this.Q_i += ((PinJoint)this.owner).tauVelocityLimit.getDoubleValue();
        }
        if (((PinJoint)this.owner).tauDamping != null) {
            if (((PinJoint)this.owner).getQDYoVariable().getDoubleValue() > 0.0) {
                ((PinJoint)this.owner).tauDamping.set(-((PinJoint)this.owner).getJointStiction() - ((PinJoint)this.owner).getDamping() * ((PinJoint)this.owner).getQDYoVariable().getDoubleValue());
            } else if (((PinJoint)this.owner).getQDYoVariable().getDoubleValue() < -0.0) {
                ((PinJoint)this.owner).tauDamping.set(((PinJoint)this.owner).getJointStiction() - ((PinJoint)this.owner).getDamping() * ((PinJoint)this.owner).getQDYoVariable().getDoubleValue());
            } else {
                ((PinJoint)this.owner).tauDamping.set(0.0 - ((PinJoint)this.owner).getDamping() * ((PinJoint)this.owner).getQDYoVariable().getDoubleValue());
            }
            this.Q_i += ((PinJoint)this.owner).tauDamping.getDoubleValue();
        }
        this.w_i.setX(this.w_i.getX() + ((PinJoint)this.owner).getQDYoVariable().getDoubleValue() * this.u_i.getX());
        this.w_i.setY(this.w_i.getY() + ((PinJoint)this.owner).getQDYoVariable().getDoubleValue() * this.u_i.getY());
        this.w_i.setZ(this.w_i.getZ() + ((PinJoint)this.owner).getQDYoVariable().getDoubleValue() * this.u_i.getZ());
        this.v_i.setX(this.v_i.getX() + ((PinJoint)this.owner).getQDYoVariable().getDoubleValue() * this.u_iXd_i.getX());
        this.v_i.setY(this.v_i.getY() + ((PinJoint)this.owner).getQDYoVariable().getDoubleValue() * this.u_iXd_i.getY());
        this.v_i.setZ(this.v_i.getZ() + ((PinJoint)this.owner).getQDYoVariable().getDoubleValue() * this.u_iXd_i.getZ());
    }

    @Override
    protected void jointDependentSet_d_i() {
        this.d_i.set(((PinJoint)this.owner).getLink().getComOffset());
    }

    @Override
    protected void jointDependentFeatherstonePassTwo(Vector3DReadOnly w_h) {
        this.vel_i.set(this.u_i);
        this.vel_i.scale(((PinJoint)this.owner).getQDYoVariable().getDoubleValue());
        this.c_hat_i.top.cross((Tuple3DReadOnly)w_h, (Tuple3DReadOnly)this.vel_i);
        this.vel_iXd_i.cross((Tuple3DReadOnly)this.vel_i, (Tuple3DReadOnly)this.d_i);
        this.w_hXr_i.cross((Tuple3DReadOnly)w_h, (Tuple3DReadOnly)this.r_i);
        this.temp1.cross((Tuple3DReadOnly)w_h, (Tuple3DReadOnly)this.w_hXr_i);
        this.temp2.cross((Tuple3DReadOnly)w_h, (Tuple3DReadOnly)this.vel_iXd_i);
        this.temp3.cross((Tuple3DReadOnly)this.vel_i, (Tuple3DReadOnly)this.vel_iXd_i);
        this.temp2.scale(2.0);
        this.c_hat_i.bottom.add((Tuple3DReadOnly)this.temp1, (Tuple3DReadOnly)this.temp2);
        this.c_hat_i.bottom.add((Tuple3DReadOnly)this.temp3);
        this.s_hat_i.top.set(this.u_i);
        this.s_hat_i.bottom.cross((Tuple3DReadOnly)this.u_i, (Tuple3DReadOnly)this.d_i);
    }

    @Override
    protected void jointDependentFeatherstonePassFour(double Q, int passNumber) {
        ((PinJoint)this.owner).getQDDYoVariable().set(Q);
        this.k_qdd[passNumber] = Q;
        this.k_qd[passNumber] = ((PinJoint)this.owner).getQDYoVariable().getDoubleValue();
    }

    @Override
    protected void jointDependentRecordK(int passNumber) {
        this.k_qdd[passNumber] = ((PinJoint)this.owner).getQDDYoVariable().getDoubleValue();
        this.k_qd[passNumber] = ((PinJoint)this.owner).getQDYoVariable().getDoubleValue();
    }

    @Override
    public void recursiveEulerIntegrate(double stepSize) {
        ((PinJoint)this.owner).getQYoVariable().set(this.q_n + stepSize * ((PinJoint)this.owner).getQDYoVariable().getDoubleValue());
        ((PinJoint)this.owner).getQDYoVariable().set(this.qd_n + stepSize * ((PinJoint)this.owner).getQDDYoVariable().getDoubleValue());
        for (int i = 0; i < ((PinJoint)this.owner).childrenJoints.size(); ++i) {
            Joint child = (Joint)((PinJoint)this.owner).childrenJoints.get(i);
            child.physics.recursiveEulerIntegrate(stepSize);
        }
    }

    @Override
    public void recursiveRungeKuttaSum(double stepSize) {
        ((PinJoint)this.owner).getQYoVariable().set(this.q_n + stepSize * (this.k_qd[0] / 6.0 + this.k_qd[1] / 3.0 + this.k_qd[2] / 3.0 + this.k_qd[3] / 6.0));
        ((PinJoint)this.owner).getQDYoVariable().set(this.qd_n + stepSize * (this.k_qdd[0] / 6.0 + this.k_qdd[1] / 3.0 + this.k_qdd[2] / 3.0 + this.k_qdd[3] / 6.0));
        for (int i = 0; i < ((PinJoint)this.owner).childrenJoints.size(); ++i) {
            Joint child = (Joint)((PinJoint)this.owner).childrenJoints.get(i);
            child.physics.recursiveRungeKuttaSum(stepSize);
        }
    }

    @Override
    public void recursiveSaveTempState() {
        this.q_n = ((PinJoint)this.owner).getQYoVariable().getDoubleValue();
        this.qd_n = ((PinJoint)this.owner).getQDYoVariable().getDoubleValue();
        for (int i = 0; i < ((PinJoint)this.owner).childrenJoints.size(); ++i) {
            Joint child = (Joint)((PinJoint)this.owner).childrenJoints.get(i);
            child.physics.recursiveSaveTempState();
        }
    }

    @Override
    public void recursiveRestoreTempState() {
        ((PinJoint)this.owner).getQYoVariable().set(this.q_n);
        ((PinJoint)this.owner).getQDYoVariable().set(this.qd_n);
        for (int i = 0; i < ((PinJoint)this.owner).childrenJoints.size(); ++i) {
            Joint child = (Joint)((PinJoint)this.owner).childrenJoints.get(i);
            child.physics.recursiveRestoreTempState();
        }
    }

    @Override
    protected boolean jointDependentVerifyReasonableAccelerations() {
        return !(Math.abs(((PinJoint)this.owner).getQDDYoVariable().getDoubleValue()) > 1.0E7);
    }
}

