/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.gui.tools;

import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.graphicsDescription.yoGraphics.plotting.ArtifactList;
import us.ihmc.graphicsDescription.yoGraphics.plotting.PlotterInterface;
import us.ihmc.graphicsDescription.yoGraphics.plotting.YoArtifactPosition;
import us.ihmc.plotting.PlotterShowHideMenu;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.gui.SimulationOverheadPlotter;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoVariable;

public class SimulationOverheadPlotterFactory {
    private static final boolean TRACK_YAW = false;
    private SimulationConstructionSet simulationConstructionSet;
    private List<YoGraphicsListRegistry> yoGraphicsListRegistries = new ArrayList<YoGraphicsListRegistry>();
    private boolean createInSeperateWindow = false;
    private boolean showOnStart = true;
    private boolean createLegend = true;
    private boolean createShowHideMenu = true;
    private String variableNameToTrack = null;
    private String plotterName = "Plotter";

    public SimulationOverheadPlotter createOverheadPlotter() {
        if (this.simulationConstructionSet == null) {
            throw new RuntimeException("SimulationConstructionSet not set");
        }
        SimulationOverheadPlotter simulationOverheadPlotter = new SimulationOverheadPlotter(this.createLegend, this.createShowHideMenu);
        simulationOverheadPlotter.setDrawHistory(false);
        simulationOverheadPlotter.setXVariableToTrack(null);
        simulationOverheadPlotter.setYVariableToTrack(null);
        this.simulationConstructionSet.attachPlaybackListener(simulationOverheadPlotter);
        JPanel plotterPanel = simulationOverheadPlotter.getJPanel();
        JScrollPane legendScrollPane = null;
        if (this.createLegend) {
            JPanel plotterKeyJPanel = simulationOverheadPlotter.getJPanelKey();
            legendScrollPane = new JScrollPane(plotterKeyJPanel);
        }
        if (this.createInSeperateWindow) {
            JFrame overheadWindow = new JFrame(this.plotterName);
            overheadWindow.setSize(new Dimension(1000, 1000));
            JSplitPane splitPane = new JSplitPane(1);
            overheadWindow.add(splitPane);
            splitPane.add(plotterPanel);
            if (this.createLegend) {
                splitPane.add(legendScrollPane);
            }
            splitPane.setResizeWeight(1.0);
            for (int i = 0; i < this.yoGraphicsListRegistries.size(); ++i) {
                YoGraphicsListRegistry yoGraphicsListRegistry = this.yoGraphicsListRegistries.get(i);
                yoGraphicsListRegistry.addArtifactListsToPlotter((PlotterInterface)simulationOverheadPlotter.getPlotter());
                ArrayList buffer = new ArrayList();
                yoGraphicsListRegistry.getRegisteredArtifactLists(buffer);
                if (this.variableNameToTrack == null || this.variableNameToTrack.isEmpty()) continue;
                for (ArtifactList artifactList : buffer) {
                    for (Artifact artifact : artifactList.getArtifacts()) {
                        if (!artifact.getID().equals(this.variableNameToTrack)) continue;
                        simulationOverheadPlotter.setXVariableToTrack(((YoArtifactPosition)artifact).getYoX());
                        simulationOverheadPlotter.setYVariableToTrack(((YoArtifactPosition)artifact).getYoY());
                    }
                }
            }
            overheadWindow.setVisible(this.showOnStart);
        } else {
            this.simulationConstructionSet.addExtraJpanel(plotterPanel, this.plotterName, this.showOnStart);
            if (this.createLegend) {
                this.simulationConstructionSet.addExtraJpanel(legendScrollPane, "Plotter Legend", false);
            }
            if (this.createShowHideMenu) {
                JScrollPane showHideMenuScrollPanel = new JScrollPane((Component)simulationOverheadPlotter.getShowHideMenuPanel());
                showHideMenuScrollPanel.getVerticalScrollBar().setUnitIncrement(16);
                this.simulationConstructionSet.addExtraJpanel(showHideMenuScrollPanel, PlotterShowHideMenu.getPanelName(), false);
            }
            for (int i = 0; i < this.yoGraphicsListRegistries.size(); ++i) {
                YoGraphicsListRegistry yoGraphicsListRegistry = this.yoGraphicsListRegistries.get(i);
                if (yoGraphicsListRegistry == null) continue;
                yoGraphicsListRegistry.addArtifactListsToPlotter((PlotterInterface)simulationOverheadPlotter.getPlotter());
            }
            if (this.variableNameToTrack != null && !this.variableNameToTrack.isEmpty()) {
                YoVariable trackingVariable = this.simulationConstructionSet.findVariable(this.variableNameToTrack + "X");
                if (trackingVariable != null && trackingVariable instanceof YoDouble) {
                    simulationOverheadPlotter.setXVariableToTrack((YoDouble)trackingVariable);
                }
                if ((trackingVariable = this.simulationConstructionSet.findVariable(this.variableNameToTrack + "Y")) != null && trackingVariable instanceof YoDouble) {
                    simulationOverheadPlotter.setYVariableToTrack((YoDouble)trackingVariable);
                }
            }
        }
        return simulationOverheadPlotter;
    }

    public void setSimulationConstructionSet(SimulationConstructionSet simulationConstructionSet) {
        this.simulationConstructionSet = simulationConstructionSet;
    }

    public void addYoGraphicsListRegistries(YoGraphicsListRegistry yoGraphicsListRegistry) {
        this.yoGraphicsListRegistries.add(yoGraphicsListRegistry);
    }

    public void setCreateInSeperateWindow(boolean createInSeperateWindow) {
        this.createInSeperateWindow = createInSeperateWindow;
    }

    public void setPlotterName(String plotterName) {
        this.plotterName = plotterName;
    }

    public void setShowOnStart(boolean showOnStart) {
        this.showOnStart = showOnStart;
    }

    public void setVariableNameToTrack(String variableNameToTrack) {
        this.variableNameToTrack = variableNameToTrack;
    }

    public void setCreateLegend(boolean createLegend) {
        this.createLegend = createLegend;
    }

    public void setCreateShowHideMenu(boolean createShowHideMenu) {
        this.createShowHideMenu = createShowHideMenu;
    }
}

