/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.gui.dialogConstructors;

import java.awt.Color;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.AboutDialogConstructor;

public class AboutDialogGenerator
implements AboutDialogConstructor {
    private JFrame parentJFrame;
    private final String aboutLink = "https://ihmcrobotics.github.io/";
    private URI aboutURI = null;

    public AboutDialogGenerator(JFrame parentJFrame) {
        this.parentJFrame = parentJFrame;
    }

    @Override
    public void constructDialog() {
        try {
            this.aboutURI = new URI("https://ihmcrobotics.github.io/");
        }
        catch (URISyntaxException e) {
            System.err.println("Warning: About dialog URI is malformed.");
        }
        String scsVersionNumber = SimulationConstructionSet.getVersion();
        JDialog aboutDialog = new JDialog(this.parentJFrame, "Simulation Construction Set Version: " + scsVersionNumber, false);
        aboutDialog.getContentPane().setLayout(new BoxLayout(aboutDialog.getContentPane(), 1));
        InputStream imageStream = this.getClass().getClassLoader().getResourceAsStream("Banner-v1-Transparent-Inverted.png");
        if (imageStream == null) {
            System.err.println("Warning: About dialog image cannot be loaded.");
        } else {
            try {
                BufferedImage bufferedImage = ImageIO.read(imageStream);
                int desiredWidth = 450;
                int desiredHeight = 300;
                int currentWidth = bufferedImage.getWidth();
                int currentHeight = bufferedImage.getHeight();
                if (currentWidth > desiredWidth) {
                    if ((double)currentHeight * ((double)desiredWidth / (double)currentWidth) > (double)desiredHeight) {
                        desiredWidth = (int)((double)currentWidth * ((double)desiredHeight / (double)currentHeight));
                    } else {
                        desiredHeight = (int)((double)currentHeight * ((double)desiredWidth / (double)currentWidth));
                    }
                } else if (currentWidth < desiredWidth) {
                    if ((double)currentHeight * ((double)desiredWidth / (double)currentWidth) < (double)desiredHeight) {
                        desiredWidth = (int)((double)currentWidth * ((double)desiredHeight / (double)currentHeight));
                    } else {
                        desiredHeight = (int)((double)currentWidth * ((double)desiredHeight / (double)currentHeight));
                    }
                } else if (currentHeight != 300) {
                    desiredWidth = (int)((double)currentWidth * ((double)desiredHeight / (double)currentHeight));
                }
                Image finalImage = bufferedImage.getScaledInstance(desiredWidth, desiredHeight, 1);
                ImageIcon imageIcon = new ImageIcon(finalImage);
                JLabel imageLabel = new JLabel(imageIcon);
                imageLabel.setAlignmentX(0.5f);
                aboutDialog.getContentPane().add(imageLabel);
            }
            catch (IOException e) {
                System.err.println("Warning: About dialog image not properly added.");
            }
        }
        JLabel version = new JLabel("Version " + scsVersionNumber);
        version.setFont(new Font("DTL Nobel", 0, 32));
        version.setAlignmentX(0.5f);
        aboutDialog.getContentPane().add(version);
        JButton github = new JButton();
        github.setText("<HTML><U>https://ihmcrobotics.github.io/</U></HTML>");
        github.setForeground(Color.BLUE);
        github.setFont(new Font("DTL Nobel", 0, 30));
        github.setBorderPainted(false);
        github.setContentAreaFilled(false);
        github.setOpaque(false);
        github.setToolTipText("https://ihmcrobotics.github.io/");
        github.setAlignmentX(0.5f);
        github.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (AboutDialogGenerator.this.aboutURI != null) {
                    if (Desktop.isDesktopSupported()) {
                        try {
                            Desktop.getDesktop().browse(AboutDialogGenerator.this.aboutURI);
                        }
                        catch (IOException e) {
                            System.err.println("Warning: could not open About URI.");
                        }
                    } else {
                        System.err.println("Warning: could not open About URI; desktop not supported.");
                    }
                }
            }
        });
        aboutDialog.getContentPane().add(github);
        JLabel yobotics = new JLabel("Originally developed at Yobotics, Inc. from 2000-2010.");
        yobotics.setFont(new Font("DTL Nobel", 0, 20));
        yobotics.setAlignmentX(0.5f);
        yobotics.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        aboutDialog.getContentPane().add(yobotics);
        JLabel ihmc = new JLabel("Now developed at IHMC from 2002 to the present.");
        ihmc.setFont(new Font("DTL Nobel", 0, 20));
        ihmc.setAlignmentX(0.5f);
        aboutDialog.getContentPane().add(ihmc);
        aboutDialog.setSize(new Dimension(600, 375));
        aboutDialog.validate();
        aboutDialog.setResizable(false);
        aboutDialog.setVisible(true);
    }

    public void closeAndDispose() {
        this.parentJFrame = null;
    }
}

