/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.gui.actions.dialogActions;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import us.ihmc.log.LogTools;

public class AbstractActionTools {
    public static void setupIconButton(AbstractAction action, String iconFilename, int shortKey, String longDescription, String shortDescription) {
        Image image = AbstractActionTools.loadActionImageUsingInputStream(action, iconFilename);
        if (image != null) {
            action.putValue("SmallIcon", new ImageIcon(image));
        }
        action.putValue("MnemonicKey", new Integer(shortKey));
        action.putValue("LongDescription", longDescription);
        action.putValue("ShortDescription", shortDescription);
    }

    public static Image loadActionImageUsingInputStream(AbstractAction action, String iconFilename) {
        InputStream iconInputStream = action.getClass().getClassLoader().getResourceAsStream(iconFilename);
        if (iconInputStream == null) {
            System.err.println("Warning! Can't find resource " + iconFilename);
            return null;
        }
        try {
            BufferedImage bimage = ImageIO.read(iconInputStream);
            if (bimage.getWidth() != bimage.getHeight()) {
                LogTools.warn((String)"Icon not square: {} {}x{}", (Object)iconFilename, (Object)bimage.getWidth(), (Object)bimage.getHeight());
            }
            return bimage.getScaledInstance(32, 32, 1);
        }
        catch (IOException e) {
            System.err.println("Can't find icon image " + iconFilename);
            return null;
        }
    }
}

