/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.gui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import us.ihmc.simulationconstructionset.gui.YoEntryBox;
import us.ihmc.simulationconstructionset.gui.YoVariableEntryContainer;
import us.ihmc.yoVariables.variable.YoEnum;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoEnumEntryContainer
implements YoVariableEntryContainer,
ActionListener {
    private static final int ENTRY_BOX_HEIGHT = 26;
    private static final int HORIZONTAL_LABEL_BORDER = 6;
    private static final int MAX_TOTAL_LENGTH = 400;
    private static final int HORIZONTAL_ENTRYBOX_SLOP = 6;
    private static final int COMBO_BOX_MIN_LENGTH = 28;
    private YoEnum<?> variableInThisBox;
    private YoEntryBox yoEntryBox;
    private JLabel label;
    private JComboBox<String> comboBox;
    private boolean updating = false;
    private int pixelLengthOfLongestComboBoxEntry = 10;
    public static final int STRING_LENGTH_CAP = 10;
    public static final int STRING_LENGTH_LOWER_BOUND = 5;
    public static final int STRING_TRUNCATION_FUNCTION_START_LENGTH = 10;
    private int labelTextLength;

    protected YoEnumEntryContainer(String[] enumValues) {
    }

    @Override
    public YoVariable getVariable() {
        return this.variableInThisBox;
    }

    @Override
    public synchronized void update(YoEntryBox yoEntryBox) {
        if (!this.comboBox.hasFocus() && this.variableInThisBox != null && this.comboBox.getSelectedIndex() != this.getIndexOf(this.variableInThisBox.getOrdinal())) {
            this.updating = true;
            this.comboBox.setSelectedIndex(this.getIndexOf(this.variableInThisBox.getOrdinal()));
            this.updating = false;
        }
    }

    @Override
    public void actionPerformed(YoEntryBox yoEntryBox, ActionEvent evt) {
    }

    @Override
    public void removeVariable(YoVariable variable) {
        if (this.getVariable() == variable) {
            this.variableInThisBox = null;
        }
        this.label.setText("UNUSED");
        this.label.setName("");
    }

    @Override
    public void setup(YoEntryBox yoEntryBox) {
        this.yoEntryBox = yoEntryBox;
        this.label = new JLabel("UNUSED");
        this.label.setHorizontalAlignment(4);
        this.comboBox = new JComboBox<String>(new String[]{"UNUSED"});
        this.yoEntryBox = yoEntryBox;
        BoxLayout mgr = new BoxLayout(yoEntryBox, 0);
        yoEntryBox.setLayout(mgr);
        yoEntryBox.add(this.label);
        yoEntryBox.add(this.comboBox);
    }

    @Override
    public void shutdown(YoEntryBox yoEntryBox) {
        this.variableInThisBox = null;
        yoEntryBox.remove(this.label);
        yoEntryBox.remove(this.comboBox);
        this.label = null;
        this.comboBox = null;
    }

    @Override
    public void bindToVariable(YoEntryBox yoEntryBox, YoVariable variable) {
        YoEnum yoEnum;
        if (!(variable instanceof YoEnum)) {
            throw new RuntimeException("Cannot bind a YoEnumEntryContainer to a varible which is not an YoEnum!");
        }
        this.variableInThisBox = yoEnum = (YoEnum)variable;
        this.label.setText(this.variableInThisBox.getName());
        this.labelTextLength = this.label.getFontMetrics(this.label.getFont()).stringWidth(this.label.getText());
        this.setupComboBox();
    }

    private void setupComboBox() {
        this.comboBox.setVisible(false);
        ArrayList<String> stringCollection = new ArrayList<String>();
        stringCollection.addAll(Arrays.asList(this.variableInThisBox.getEnumValuesAsString()));
        if (this.variableInThisBox.isNullAllowed()) {
            stringCollection.add("null");
        }
        this.calculateStringFoldingParameters(stringCollection);
        String[] stringsArray = new String[stringCollection.size()];
        stringCollection.toArray(stringsArray);
        this.comboBox = new JComboBox<String>(stringsArray);
        this.comboBox.setSelectedIndex(this.getIndexOf(this.variableInThisBox.getOrdinal()));
        this.yoEntryBox.add(this.comboBox);
        this.comboBox.addActionListener(this);
        this.doLayout();
    }

    private void doLayout() {
        int desiredLabelLength = this.labelTextLength + 6;
        Dimension labelDimension = new Dimension(desiredLabelLength, 26);
        this.label.setPreferredSize(labelDimension);
        int remainingSpace = 400 - desiredLabelLength;
        int desiredComboBoxLength = this.pixelLengthOfLongestComboBoxEntry + 28;
        if (remainingSpace < desiredComboBoxLength) {
            desiredComboBoxLength = remainingSpace;
        }
        Dimension comboBoxDimension = new Dimension(desiredComboBoxLength, 26);
        this.comboBox.setPreferredSize(comboBoxDimension);
        this.yoEntryBox.setPreferredSize(new Dimension(desiredLabelLength + desiredComboBoxLength + 6, 26));
    }

    private int calculateStringLengthInComboBox(String string) {
        return this.comboBox.getFontMetrics(this.comboBox.getFont()).stringWidth(string);
    }

    @Override
    public boolean isEventSource(YoEntryBox yoEntryBox, FocusEvent evt) {
        return evt.getSource().equals(this.comboBox);
    }

    @Override
    public void focusLost(YoEntryBox yoEntryBox) {
    }

    @Override
    public void focusGained(YoEntryBox yoEntryBox) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.updating) {
            int selectedIndex = this.comboBox.getSelectedIndex();
            int ordinal = this.getOrdinalOf(selectedIndex);
            this.variableInThisBox.set(ordinal, true);
            YoEntryBox.informVariableChangedListeners(this.getVariable());
        }
    }

    public void calculateStringFoldingParameters(Collection<String> strings) {
        int maxSize = 0;
        for (String string : strings) {
            int stringLength = this.calculateStringLengthInComboBox(string);
            if (stringLength <= maxSize) continue;
            maxSize = stringLength;
        }
        this.pixelLengthOfLongestComboBoxEntry = maxSize;
    }

    private int getOrdinalOf(int index) {
        if (this.variableInThisBox.isNullAllowed() && index == this.variableInThisBox.getEnumSize()) {
            return -1;
        }
        return index;
    }

    private int getIndexOf(int ordinal) {
        if (this.variableInThisBox.isNullAllowed() && ordinal == -1) {
            return this.variableInThisBox.getEnumSize();
        }
        return ordinal;
    }
}

