/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.graphics;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import us.ihmc.graphicsDescription.GraphicsUpdatable;
import us.ihmc.graphicsDescription.structure.Graphics3DNode;
import us.ihmc.graphicsDescription.structure.Graphics3DNodeType;
import us.ihmc.simulationconstructionset.Joint;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.graphics.joints.GraphicsJoint;
import us.ihmc.simulationconstructionset.util.CommonJoint;

public class GraphicsRobot
implements GraphicsUpdatable {
    private final Graphics3DNode rootNode;
    private final LinkedHashMap<CommonJoint, GraphicsJoint> allJoints = new LinkedHashMap();
    private final List<GraphicsJoint> graphicsJoints = new ArrayList<GraphicsJoint>();

    public GraphicsRobot(Robot robot) {
        this.rootNode = new Graphics3DNode(robot.getName(), Graphics3DNodeType.TRANSFORM);
        for (Joint joint : robot.getRootJoints()) {
            GraphicsJoint rootGraphicsJoint = this.createJoint(joint, Graphics3DNodeType.ROOTJOINT);
            this.rootNode.addChild((Graphics3DNode)rootGraphicsJoint);
            this.addJoints(joint.getChildrenJoints(), rootGraphicsJoint);
        }
        this.update();
    }

    protected GraphicsRobot(Graphics3DNode rootNode) {
        this.rootNode = rootNode;
    }

    protected void registerJoint(CommonJoint joint, GraphicsJoint graphicsJoint) {
        this.allJoints.put(joint, graphicsJoint);
        this.graphicsJoints.add(graphicsJoint);
    }

    public void update() {
        for (int i = 0; i < this.graphicsJoints.size(); ++i) {
            this.graphicsJoints.get(i).updateFromJoint();
        }
    }

    public Graphics3DNode getRootNode() {
        return this.rootNode;
    }

    private void addJoints(List<Joint> joints, GraphicsJoint parentJoint) {
        for (Joint joint : joints) {
            GraphicsJoint graphicsJoint = this.createJoint(joint, Graphics3DNodeType.JOINT);
            parentJoint.addChild(graphicsJoint);
            this.addJoints(joint.getChildrenJoints(), graphicsJoint);
        }
    }

    private GraphicsJoint createJoint(Joint joint, Graphics3DNodeType nodeType) {
        GraphicsJoint graphicsJoint = new GraphicsJoint(joint.getName(), joint, joint.getLink().getLinkGraphics(), nodeType);
        this.allJoints.put(joint, graphicsJoint);
        this.graphicsJoints.add(graphicsJoint);
        return graphicsJoint;
    }

    public GraphicsJoint getGraphicsJoint(CommonJoint joint) {
        return this.allJoints.get(joint);
    }
}

