/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.simulationconstructionset.FloatingJoint;
import us.ihmc.simulationconstructionset.FloatingPlanarJoint;
import us.ihmc.simulationconstructionset.Joint;
import us.ihmc.simulationconstructionset.Link;
import us.ihmc.simulationconstructionset.PinJoint;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.SliderJoint;

public class RandomRobotGenerator {
    public static Robot generateRandomLinearChainRobot(String name, boolean startWithFloatingJoint, int numberOfPinJoints, Random random) {
        Robot robot = new Robot(name);
        Joint parentJoint = null;
        if (startWithFloatingJoint) {
            String jointName = "floatingJoint";
            FloatingJoint floatingJoint = new FloatingJoint(jointName, (Tuple3DReadOnly)new Vector3D(), robot);
            Link link = RandomRobotGenerator.generateRandomLink(random, jointName, null);
            floatingJoint.setLink(link);
            robot.addRootJoint(floatingJoint);
            parentJoint = floatingJoint;
        }
        for (int jointNumber = 0; jointNumber < numberOfPinJoints; ++jointNumber) {
            Vector3D offset = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)(random.nextDouble() + 0.1));
            Vector3D axis = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            axis.normalize();
            String jointName = "joint" + jointNumber;
            PinJoint pinJoint = new PinJoint(jointName, (Tuple3DReadOnly)offset, robot, (Vector3DReadOnly)axis);
            Link link = RandomRobotGenerator.generateRandomLink(random, jointName, axis);
            pinJoint.setLink(link);
            if (parentJoint == null) {
                robot.addRootJoint(pinJoint);
            } else {
                Graphics3DObject parentLinkGraphics = parentJoint.getLink().getLinkGraphics();
                Vector3D zVector = new Vector3D(0.0, 0.0, 1.0);
                AxisAngle rotationAxisAngle = RandomRobotGenerator.computeAxisAngleToAlignVectors(zVector, offset);
                parentLinkGraphics.identity();
                parentLinkGraphics.rotate((Orientation3DReadOnly)rotationAxisAngle);
                parentLinkGraphics.addCylinder(offset.length(), offset.length() / 20.0, YoAppearance.randomColor((Random)random));
                parentJoint.addJoint(pinJoint);
            }
            parentJoint = pinJoint;
        }
        return robot;
    }

    public static void setRandomJointPositions(Robot robot, Random random) {
        List<Joint> rootJoints = robot.getRootJoints();
        for (Joint rootJoint : rootJoints) {
            RandomRobotGenerator.setRandomJointPosition(rootJoint, random);
            ArrayList<Joint> childrenJoints = new ArrayList<Joint>();
            rootJoint.recursiveGetChildrenJoints(childrenJoints);
            for (Joint childJoint : childrenJoints) {
                RandomRobotGenerator.setRandomJointPosition(childJoint, random);
            }
        }
    }

    public static void setRandomJointVelocities(Robot robot, Random random) {
        List<Joint> rootJoints = robot.getRootJoints();
        for (Joint rootJoint : rootJoints) {
            RandomRobotGenerator.setRandomJointVelocity(rootJoint, random);
            ArrayList<Joint> childrenJoints = new ArrayList<Joint>();
            rootJoint.recursiveGetChildrenJoints(childrenJoints);
            for (Joint childJoint : childrenJoints) {
                RandomRobotGenerator.setRandomJointVelocity(childJoint, random);
            }
        }
    }

    public static void setRandomJointPosition(Joint joint, Random random) {
        if (joint instanceof FloatingJoint) {
            FloatingJoint floatingJoint = (FloatingJoint)joint;
            RigidBodyTransform randomTransform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            floatingJoint.setRotationAndTranslation((RigidBodyTransformReadOnly)randomTransform);
        } else if (joint instanceof FloatingPlanarJoint) {
            FloatingPlanarJoint floatingJoint = (FloatingPlanarJoint)joint;
            double rotation = RandomNumbers.nextDouble((Random)random, (double)(-Math.PI), (double)Math.PI);
            floatingJoint.setRotation(rotation);
            Vector2D position = EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)1.0);
            Vector2D velocity = EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)0.5);
            floatingJoint.setCartesianPosition((Tuple2DReadOnly)position, (Tuple2DReadOnly)velocity);
        } else if (joint instanceof PinJoint) {
            PinJoint pinJoint = (PinJoint)joint;
            double rotation = RandomNumbers.nextDouble((Random)random, (double)(-Math.PI), (double)Math.PI);
            pinJoint.setQ(rotation);
        } else if (joint instanceof SliderJoint) {
            SliderJoint sliderJoint = (SliderJoint)joint;
            double position = RandomNumbers.nextDouble((Random)random, (double)-0.1, (double)0.1);
            sliderJoint.setQ(position);
        } else {
            throw new RuntimeException("Joint type not supported!");
        }
    }

    public static void setRandomJointVelocity(Joint joint, Random random) {
        if (joint instanceof FloatingJoint) {
            FloatingJoint floatingJoint = (FloatingJoint)joint;
            Vector3D velocity = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)0.5);
            floatingJoint.setVelocity((Tuple3DReadOnly)velocity);
            Vector3D angularVelocityInBody = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)2.0);
            floatingJoint.setAngularVelocityInBody((Vector3DReadOnly)angularVelocityInBody);
        } else if (joint instanceof FloatingPlanarJoint) {
            FloatingPlanarJoint floatingJoint = (FloatingPlanarJoint)joint;
            double rotationalVelocity = RandomNumbers.nextDouble((Random)random, (double)(-Math.PI), (double)Math.PI);
            floatingJoint.setRotationalVelocity(rotationalVelocity);
            Vector2D velocity = EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)0.5);
            floatingJoint.setCartesianVelocity((Tuple2DReadOnly)velocity);
        } else if (joint instanceof PinJoint) {
            PinJoint pinJoint = (PinJoint)joint;
            double rotationalVelocity = RandomNumbers.nextDouble((Random)random, (double)(-Math.PI), (double)Math.PI);
            pinJoint.setQd(rotationalVelocity);
        } else if (joint instanceof SliderJoint) {
            SliderJoint sliderJoint = (SliderJoint)joint;
            double velocity = RandomNumbers.nextDouble((Random)random, (double)-0.1, (double)0.1);
            sliderJoint.setQd(velocity);
        } else {
            throw new RuntimeException("Joint type not supported!");
        }
    }

    public static AxisAngle computeAxisAngleToAlignVectors(Vector3D vectorToRotate, Vector3D vectorToAlignTo) {
        Vector3D crossVector = new Vector3D();
        crossVector.cross((Tuple3DReadOnly)vectorToRotate, (Tuple3DReadOnly)vectorToAlignTo);
        double crossVectorLength = crossVector.length();
        double rotationAngle = Math.asin(crossVectorLength / vectorToRotate.length() / vectorToAlignTo.length());
        if (vectorToRotate.dot((Vector3DReadOnly)vectorToAlignTo) < 0.0) {
            rotationAngle = Math.PI - rotationAngle;
        }
        if (Math.abs(crossVectorLength) > 1.0E-10) {
            crossVector.scale(1.0 / crossVectorLength);
            AxisAngle rotationAxisAngle = new AxisAngle((Vector3DReadOnly)crossVector, rotationAngle);
            return rotationAxisAngle;
        }
        return new AxisAngle();
    }

    public static Link generateRandomLink(Random random, String jointName, Vector3D axis) {
        Link link = new Link(jointName);
        Vector3D comOffset = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)0.2);
        link.setComOffset((Vector3DReadOnly)comOffset);
        double mass = (0.25 + random.nextDouble()) * 4.0;
        double radiusOfGyrationX = 0.04 + 0.1 * random.nextDouble();
        double radiusOfGyrationY = 0.04 + 0.1 * random.nextDouble();
        double radiusOfGyrationZ = 0.04 + 0.1 * random.nextDouble();
        link.setMassAndRadiiOfGyration(mass, radiusOfGyrationX, radiusOfGyrationY, radiusOfGyrationZ);
        Graphics3DObject linkGraphics = new Graphics3DObject();
        if (axis != null) {
            Vector3D zVector = new Vector3D(0.0, 0.0, 1.0);
            AxisAngle rotationAxisAngle = RandomRobotGenerator.computeAxisAngleToAlignVectors(zVector, axis);
            linkGraphics.rotate((Orientation3DReadOnly)rotationAxisAngle);
            linkGraphics.addArrow(0.2, YoAppearance.Black(), YoAppearance.Blue());
        } else {
            linkGraphics.addSphere(0.1, YoAppearance.Red());
        }
        link.setLinkGraphics(linkGraphics);
        return link;
    }

    public static void main(String[] args) {
        Random random = new Random(1233L);
        boolean startWithFloatingJoint = true;
        Robot robot = RandomRobotGenerator.generateRandomLinearChainRobot("randomRobot", startWithFloatingJoint, 10, random);
        robot.setGravity((Vector3DReadOnly)new Vector3D(0.0, 0.0, -0.01));
        RandomRobotGenerator.setRandomJointVelocities(robot, random);
        SimulationConstructionSet scs = new SimulationConstructionSet(robot);
        scs.setDT(1.0E-4, 100);
        scs.setGroundVisible(false);
        scs.startOnAThread();
    }
}

