/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset;

import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.tools.TupleTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.log.LogTools;
import us.ihmc.simulationconstructionset.ExternalForcePoint;
import us.ihmc.simulationconstructionset.Joint;
import us.ihmc.simulationconstructionset.Link;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.yoVariables.euclid.YoVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class LoopClosureSoftConstraint {
    private String name;
    private final YoVector3D proportionalGains;
    private final YoVector3D derivativeGains;
    private final ExternalForcePoint constraintA;
    private final ExternalForcePoint constraintB;
    private final YoDouble positionErrorMagnitude;
    private final YoDouble rotationErrorMagnitude;
    private final YoVector3D positionError;
    private final YoVector3D rotationError;
    private final YoVector3D linearVelocityError;
    private final YoVector3D angularVelocityError;
    private final YoVector3D feedForwardForce;
    private final YoVector3D feedForwardMoment;
    private final Vector3D offsetFromParentJoint = new Vector3D();
    private final Vector3D offsetFromLinkParentJoint = new Vector3D();
    private final Matrix3D constraintForceSubSpace = new Matrix3D();
    private final Matrix3D constraintMomentSubSpace = new Matrix3D();
    private final Vector3D proportionalTermLinear = new Vector3D();
    private final Vector3D derivativeTermLinear = new Vector3D();
    private final Vector3D proportionalTermAngular = new Vector3D();
    private final Vector3D derivativeTermAngular = new Vector3D();
    private Joint parentJoint;
    private final Quaternion quaternionA = new Quaternion();
    private final Quaternion quaternionB = new Quaternion();
    private final Quaternion quaternionDifference = new Quaternion();
    private final Vector3D forceA = new Vector3D();
    private final Vector3D momentA = new Vector3D();
    private boolean isFirstUpdate = true;

    public LoopClosureSoftConstraint(String name, Tuple3DReadOnly offsetFromParentJoint, Tuple3DReadOnly offsetFromLinkParentJoint, Robot robot, Matrix3DReadOnly constraintForceSubSpace, Matrix3DReadOnly constraintMomentSubSpace) {
        this.name = name;
        this.offsetFromParentJoint.set(offsetFromParentJoint);
        this.offsetFromLinkParentJoint.set(offsetFromLinkParentJoint);
        this.constraintForceSubSpace.set(constraintForceSubSpace);
        this.constraintMomentSubSpace.set(constraintMomentSubSpace);
        YoRegistry registry = robot.getRobotsYoRegistry();
        this.proportionalGains = new YoVector3D(name + "ProportionalGain", registry);
        this.derivativeGains = new YoVector3D(name + "DerivativeGain", registry);
        this.constraintA = new ExternalForcePoint(name + "A", offsetFromParentJoint, robot);
        this.constraintB = new ExternalForcePoint(name + "B", offsetFromLinkParentJoint, robot);
        this.positionErrorMagnitude = new YoDouble(name + "PositionErrorMagnitude", registry);
        this.rotationErrorMagnitude = new YoDouble(name + "RotationErrorMagnitude", registry);
        this.positionError = new YoVector3D(name + "PositionError", registry);
        this.rotationError = new YoVector3D(name + "RotationError", registry);
        this.linearVelocityError = new YoVector3D(name + "LinearVelocityError", registry);
        this.angularVelocityError = new YoVector3D(name + "AngularVelocityError", registry);
        this.feedForwardForce = new YoVector3D(name + "FeedForwardForce", registry);
        this.feedForwardMoment = new YoVector3D(name + "FeedForwardMoment", registry);
    }

    public void setGains(double proportionalGain, double derivativeGain) {
        this.proportionalGains.set(proportionalGain, proportionalGain, proportionalGain);
        this.derivativeGains.set(derivativeGain, derivativeGain, derivativeGain);
    }

    public void setGains(Tuple3DReadOnly proportionalGains, Tuple3DReadOnly derivativeGains) {
        this.proportionalGains.set(proportionalGains);
        this.derivativeGains.set(derivativeGains);
    }

    public void setParentJoint(Joint parentJoint) {
        this.parentJoint = parentJoint;
        parentJoint.addExternalForcePoint(this.constraintA);
    }

    public void setLink(Link link) {
        link.getParentJoint().addExternalForcePoint(this.constraintB);
    }

    public void update() {
        if (this.isFirstUpdate) {
            if (this.proportionalGains.containsNaN() || this.derivativeGains.containsNaN()) {
                throw new IllegalArgumentException("The gains for the loop closure constraint: " + this.name + " have not been configured. If created from description, see: " + LoopClosureSoftConstraint.class.getSimpleName());
            }
            if (TupleTools.isTupleZero((Tuple3DReadOnly)this.proportionalGains, (double)0.0) || TupleTools.isTupleZero((Tuple3DReadOnly)this.derivativeGains, (double)0.0)) {
                LogTools.warn((String)("The gains for the loop closure constraint: " + this.name + " have not been configured. If created from description, see: " + LoopClosureSoftConstraint.class.getSimpleName()));
            }
            this.isFirstUpdate = false;
        }
        this.positionError.sub((Tuple3DReadOnly)this.constraintB.getYoPosition(), (Tuple3DReadOnly)this.constraintA.getYoPosition());
        this.parentJoint.transformToNext.inverseTransform((Vector3DBasics)this.positionError);
        this.constraintForceSubSpace.transform((Tuple3DBasics)this.positionError);
        this.positionErrorMagnitude.set(this.positionError.length());
        this.constraintA.getParentJoint().getRotationToWorld((Orientation3DBasics)this.quaternionA);
        this.constraintB.getParentJoint().getRotationToWorld((Orientation3DBasics)this.quaternionB);
        this.quaternionDifference.difference((QuaternionReadOnly)this.quaternionA, (QuaternionReadOnly)this.quaternionB);
        this.quaternionDifference.normalizeAndLimitToPi();
        this.quaternionDifference.getRotationVector((Vector3DBasics)this.rotationError);
        this.constraintMomentSubSpace.transform((Tuple3DBasics)this.rotationError);
        this.rotationErrorMagnitude.set(this.rotationError.length());
        this.linearVelocityError.sub((Tuple3DReadOnly)this.constraintB.getYoVelocity(), (Tuple3DReadOnly)this.constraintA.getYoVelocity());
        this.parentJoint.transformToNext.inverseTransform((Vector3DBasics)this.linearVelocityError);
        this.constraintForceSubSpace.transform((Tuple3DBasics)this.linearVelocityError);
        this.angularVelocityError.sub((Tuple3DReadOnly)this.constraintB.getYoAngularVelocity(), (Tuple3DReadOnly)this.constraintA.getYoAngularVelocity());
        this.parentJoint.transformToNext.inverseTransform((Vector3DBasics)this.angularVelocityError);
        this.constraintMomentSubSpace.transform((Tuple3DBasics)this.angularVelocityError);
        this.proportionalTermLinear.set((Tuple3DReadOnly)this.positionError);
        this.proportionalTermLinear.scale(this.proportionalGains.getX(), this.proportionalGains.getY(), this.proportionalGains.getZ());
        this.proportionalTermAngular.set((Tuple3DReadOnly)this.rotationError);
        this.proportionalTermAngular.scale(this.proportionalGains.getX(), this.proportionalGains.getY(), this.proportionalGains.getZ());
        this.derivativeTermLinear.set((Tuple3DReadOnly)this.linearVelocityError);
        this.derivativeTermLinear.scale(this.derivativeGains.getX(), this.derivativeGains.getY(), this.derivativeGains.getZ());
        this.derivativeTermAngular.set((Tuple3DReadOnly)this.angularVelocityError);
        this.derivativeTermAngular.scale(this.derivativeGains.getX(), this.derivativeGains.getY(), this.derivativeGains.getZ());
        this.forceA.set(this.proportionalTermLinear);
        this.forceA.add((Tuple3DReadOnly)this.derivativeTermLinear);
        this.forceA.add((Tuple3DReadOnly)this.feedForwardForce);
        this.momentA.set(this.proportionalTermAngular);
        this.momentA.add((Tuple3DReadOnly)this.derivativeTermAngular);
        this.momentA.add((Tuple3DReadOnly)this.feedForwardMoment);
        this.parentJoint.transformToNext.transform((Vector3DBasics)this.forceA);
        this.parentJoint.transformToNext.transform((Vector3DBasics)this.momentA);
        this.constraintA.getYoForce().set((Tuple3DReadOnly)this.forceA);
        this.constraintA.getYoMoment().set((Tuple3DReadOnly)this.momentA);
        this.constraintB.getYoForce().setAndNegate((Tuple3DReadOnly)this.forceA);
        this.constraintB.getYoMoment().setAndNegate((Tuple3DReadOnly)this.momentA);
    }

    public void setFeedForward(Vector3DReadOnly force, Vector3DReadOnly moment) {
        this.constraintForceSubSpace.transform((Tuple3DReadOnly)force, (Tuple3DBasics)this.feedForwardForce);
        this.constraintMomentSubSpace.transform((Tuple3DReadOnly)moment, (Tuple3DBasics)this.feedForwardMoment);
    }

    public String getName() {
        return this.name;
    }
}

