/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset;

import net.jafama.FastMath;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.simulationconstructionset.FloatingSCSJoint;
import us.ihmc.simulationconstructionset.Joint;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.physics.engine.featherstone.FloatingJointPhysics;
import us.ihmc.yoVariables.euclid.YoPoint3D;
import us.ihmc.yoVariables.euclid.YoQuaternion;
import us.ihmc.yoVariables.euclid.YoVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class FloatingJoint
extends Joint
implements FloatingSCSJoint {
    private static final long serialVersionUID = 6863566500545068060L;
    private YoBoolean isPinned;
    public final YoDouble q_x;
    public final YoDouble q_y;
    public final YoDouble q_z;
    public final YoDouble qd_x;
    public final YoDouble qd_y;
    public final YoDouble qd_z;
    public final YoDouble q_qs;
    public final YoDouble q_qx;
    public final YoDouble q_qy;
    public final YoDouble q_qz;
    public final YoDouble qd_wx;
    public final YoDouble qd_wy;
    public final YoDouble qd_wz;
    public final YoDouble qdd_x;
    public final YoDouble qdd_y;
    public final YoDouble qdd_z;
    public final YoDouble qdd_wx;
    public final YoDouble qdd_wy;
    public final YoDouble qdd_wz;
    public final YoPoint3D position;
    public final YoQuaternion quaternion;
    public final YoVector3D linearVelocity;
    public final YoVector3D angularVelocity;
    public final YoVector3D linearAcceleration;
    public final YoVector3D angularAcceleration;
    private final boolean createYawPitchRollYoVariable;
    public final YoDouble q_yaw;
    public final YoDouble q_pitch;
    public final YoDouble q_roll;

    public FloatingJoint(String jname, Tuple3DReadOnly offset, Robot rob) {
        this(jname, null, offset, rob, false);
    }

    public FloatingJoint(String jname, Tuple3DReadOnly offset, Robot rob, boolean createYawPitchRollYoVariable) {
        this(jname, null, offset, rob, createYawPitchRollYoVariable);
    }

    public FloatingJoint(String jname, String varName, Tuple3DReadOnly offset, Robot rob) {
        this(jname, varName, offset, rob, false);
    }

    public FloatingJoint(String jname, String varName, Tuple3DReadOnly offset, Robot rob, boolean createYawPitchRollYoVariable) {
        super(jname, offset, rob, 6);
        this.physics = new FloatingJointPhysics(this);
        YoRegistry registry = rob.getRobotsYoRegistry();
        this.createYawPitchRollYoVariable = createYawPitchRollYoVariable;
        if (varName == null) {
            varName = "";
        } else if (!varName.isEmpty()) {
            varName = varName + "_";
        }
        this.q_x = new YoDouble("q_" + varName + "x", "FloatingJoint x position", registry);
        this.q_y = new YoDouble("q_" + varName + "y", "FloatingJoint y position", registry);
        this.q_z = new YoDouble("q_" + varName + "z", "FloatingJoint z position", registry);
        this.qd_x = new YoDouble("qd_" + varName + "x", "FloatingJoint x velocity", registry);
        this.qd_y = new YoDouble("qd_" + varName + "y", "FloatingJoint y velocity", registry);
        this.qd_z = new YoDouble("qd_" + varName + "z", "FloatingJoint z velocity", registry);
        this.qdd_x = new YoDouble("qdd_" + varName + "x", "FloatingJoint x acceleration", registry);
        this.qdd_y = new YoDouble("qdd_" + varName + "y", "FloatingJoint yx acceleration", registry);
        this.qdd_z = new YoDouble("qdd_" + varName + "z", "FloatingJoint z acceleration", registry);
        this.q_qs = new YoDouble("q_" + varName + "qs", "FloatingJoint orientation quaternion qs", registry);
        this.q_qs.set(1.0);
        this.q_qx = new YoDouble("q_" + varName + "qx", "FloatingJoint orientation quaternion qx", registry);
        this.q_qy = new YoDouble("q_" + varName + "qy", "FloatingJoint orientation quaternion qy", registry);
        this.q_qz = new YoDouble("q_" + varName + "qz", "FloatingJoint orientation quaternion qz", registry);
        this.qd_wx = new YoDouble("qd_" + varName + "wx", "FloatingJoint rotational velocity about x", registry);
        this.qd_wy = new YoDouble("qd_" + varName + "wy", "FloatingJoint rotational velocity about y", registry);
        this.qd_wz = new YoDouble("qd_" + varName + "wz", "FloatingJoint rotational velocity about z", registry);
        this.qdd_wx = new YoDouble("qdd_" + varName + "wx", "FloatingJoint rotational acceleration about x", registry);
        this.qdd_wy = new YoDouble("qdd_" + varName + "wy", "FloatingJoint rotational acceleration about y", registry);
        this.qdd_wz = new YoDouble("qdd_" + varName + "wz", "FloatingJoint rotational acceleration about z", registry);
        this.position = new YoPoint3D(this.q_x, this.q_y, this.q_z);
        this.quaternion = new YoQuaternion(this.q_qx, this.q_qy, this.q_qz, this.q_qs);
        this.linearVelocity = new YoVector3D(this.qd_x, this.qd_y, this.qd_z);
        this.angularVelocity = new YoVector3D(this.qd_wx, this.qd_wy, this.qd_wz);
        this.linearAcceleration = new YoVector3D(this.qdd_x, this.qdd_y, this.qdd_z);
        this.angularAcceleration = new YoVector3D(this.qdd_wx, this.qdd_wy, this.qdd_wz);
        if (createYawPitchRollYoVariable) {
            this.q_yaw = new YoDouble("q_" + varName + "yaw", "FloatingJoint yaw orientation", registry);
            this.q_pitch = new YoDouble("q_" + varName + "pitch", "FloatingJoint pitch orientation", registry);
            this.q_roll = new YoDouble("q_" + varName + "roll", "FloatingJoint roll orientation", registry);
        } else {
            this.q_yaw = null;
            this.q_pitch = null;
            this.q_roll = null;
        }
        this.isPinned = new YoBoolean(jname + "IsPinned", "Whether this FloatingJoint is pinned or not", registry);
        this.jointTransform3D.set((Orientation3DReadOnly)this.quaternion, (Tuple3DReadOnly)this.position);
        this.physics.u_i = null;
    }

    public void setPositionAndVelocity(double x, double y, double z, double dx, double dy, double dz) {
        this.position.set(x, y, z);
        this.linearVelocity.set(dx, dy, dz);
    }

    public void setPositionAndVelocity(Tuple3DReadOnly position, Tuple3DReadOnly velocity) {
        this.position.set(position);
        this.linearVelocity.set(velocity);
    }

    public void setPosition(Tuple3DReadOnly position) {
        this.position.set(position);
    }

    public void setPosition(double x, double y, double z) {
        this.position.set(x, y, z);
    }

    @Override
    public void setVelocity(Tuple3DReadOnly velocity) {
        this.linearVelocity.set(velocity);
    }

    public void setVelocity(double xd, double yd, double zd) {
        this.linearVelocity.set(xd, yd, zd);
    }

    public void setAcceleration(Tuple3DReadOnly acceleration) {
        this.linearAcceleration.set(acceleration);
    }

    public void setOrientation(Orientation3DReadOnly orientation) {
        this.quaternion.set(orientation);
    }

    public void setYawPitchRoll(double yaw, double pitch, double roll) {
        this.quaternion.setYawPitchRoll(yaw, pitch, roll);
    }

    public void setYawPitchRoll(double yaw, double pitch, double roll, double wz, double wy, double wx) {
        this.setYawPitchRoll(yaw, pitch, roll);
        this.angularVelocity.set(wx, wy, wz);
    }

    public void setRotation(RotationMatrixReadOnly rotation) {
        this.setOrientation((Orientation3DReadOnly)rotation);
    }

    public void setQuaternion(QuaternionReadOnly q) {
        this.setOrientation((Orientation3DReadOnly)q);
    }

    @Override
    public void setRotationAndTranslation(RigidBodyTransformReadOnly transform) {
        this.setOrientation(transform.getRotation());
        this.setPosition(transform.getTranslation());
    }

    @Override
    public void setAngularVelocityInBody(Vector3DReadOnly angularVelocityInBody) {
        this.angularVelocity.set((Tuple3DReadOnly)angularVelocityInBody);
    }

    public void setAngularAccelerationInBody(Vector3DReadOnly angularAccelerationInBody) {
        this.angularAcceleration.set((Tuple3DReadOnly)angularAccelerationInBody);
    }

    public void getPosition(YoDouble x, YoDouble y, YoDouble z) {
        x.set(this.q_x.getDoubleValue());
        y.set(this.q_y.getDoubleValue());
        z.set(this.q_z.getDoubleValue());
    }

    public void getVelocity(YoDouble xDot, YoDouble yDot, YoDouble zDot) {
        xDot.set(this.qd_x.getDoubleValue());
        yDot.set(this.qd_y.getDoubleValue());
        zDot.set(this.qd_z.getDoubleValue());
    }

    @Override
    public void getVelocity(FrameVector3DBasics linearVelocityToPack) {
        linearVelocityToPack.setIncludingFrame(ReferenceFrame.getWorldFrame(), (Tuple3DReadOnly)this.linearVelocity);
    }

    @Override
    public void getAngularVelocity(FrameVector3DBasics angularVelocityToPack, ReferenceFrame bodyFrame) {
        angularVelocityToPack.setIncludingFrame(bodyFrame, (Tuple3DReadOnly)this.angularVelocity);
    }

    public void getPositionAndVelocity(YoDouble x, YoDouble y, YoDouble z, YoDouble xDot, YoDouble yDot, YoDouble zDot) {
        this.getPosition(x, y, z);
        this.getVelocity(xDot, yDot, zDot);
    }

    public void getPosition(Tuple3DBasics position) {
        position.set((Tuple3DReadOnly)this.position);
    }

    public void getVelocity(Tuple3DBasics velocity) {
        velocity.set((Tuple3DReadOnly)this.linearVelocity);
    }

    public void getPositionAndVelocity(Tuple3DBasics position, Tuple3DBasics velocity) {
        this.getPosition(position);
        this.getVelocity(velocity);
    }

    public YoDouble getQx() {
        return this.q_x;
    }

    public YoDouble getQy() {
        return this.q_y;
    }

    public YoDouble getQz() {
        return this.q_z;
    }

    public YoPoint3D getPosition() {
        return this.position;
    }

    public YoDouble getQdx() {
        return this.qd_x;
    }

    public YoDouble getQdy() {
        return this.qd_y;
    }

    public YoDouble getQdz() {
        return this.qd_z;
    }

    public YoVector3D getLinearVelocity() {
        return this.linearVelocity;
    }

    public YoDouble getQddx() {
        return this.qdd_x;
    }

    public YoDouble getQddy() {
        return this.qdd_y;
    }

    public YoDouble getQddz() {
        return this.qdd_z;
    }

    public YoVector3D getLinearAcceleration() {
        return this.linearAcceleration;
    }

    public YoDouble getQuaternionQs() {
        return this.q_qs;
    }

    public YoDouble getQuaternionQx() {
        return this.q_qx;
    }

    public YoDouble getQuaternionQy() {
        return this.q_qy;
    }

    public YoDouble getQuaternionQz() {
        return this.q_qz;
    }

    public YoQuaternion getOrientation() {
        return this.quaternion;
    }

    public Quaternion getQuaternion() {
        return new Quaternion((QuaternionReadOnly)this.quaternion);
    }

    public void getQuaternion(QuaternionBasics quaternionToPack) {
        quaternionToPack.set((QuaternionReadOnly)this.quaternion);
    }

    public YoDouble getAngularVelocityX() {
        return this.qd_wx;
    }

    public YoDouble getAngularVelocityY() {
        return this.qd_wy;
    }

    public YoDouble getAngularVelocityZ() {
        return this.qd_wz;
    }

    public YoVector3D getAngularVelocity() {
        return this.angularVelocity;
    }

    public Vector3D getAngularVelocityInBody() {
        return new Vector3D((Tuple3DReadOnly)this.angularVelocity);
    }

    public void getAngularVelocityInBody(Vector3DBasics vectorToPack) {
        vectorToPack.set((Tuple3DReadOnly)this.angularVelocity);
    }

    public YoDouble getAngularAccelerationX() {
        return this.qdd_wx;
    }

    public YoDouble getAngularAccelerationY() {
        return this.qdd_wy;
    }

    public YoDouble getAngularAccelerationZ() {
        return this.qdd_wz;
    }

    public YoVector3D getAngularAcceleration() {
        return this.angularAcceleration;
    }

    public Vector3D getAngularAccelerationInBody() {
        return new Vector3D((Tuple3DReadOnly)this.angularAcceleration);
    }

    public void getAngularAccelerationInBody(Vector3DBasics angularAccelerationInBodyToPack) {
        angularAccelerationInBodyToPack.set((Tuple3DReadOnly)this.angularAcceleration);
    }

    public void getAngularAcceleration(FrameVector3DBasics angularAccelerationToPack, ReferenceFrame bodyFrame) {
        angularAccelerationToPack.setIncludingFrame(bodyFrame, (Tuple3DReadOnly)this.angularAcceleration);
    }

    public void getLinearAccelerationInWorld(Vector3DBasics accelerationInWorldToPack) {
        accelerationInWorldToPack.set((Tuple3DReadOnly)this.linearAcceleration);
    }

    public void getLinearAcceleration(FrameVector3DBasics linearAccelerationToPack) {
        linearAccelerationToPack.setIncludingFrame(ReferenceFrame.getWorldFrame(), (Tuple3DReadOnly)this.linearAcceleration);
    }

    public void getYawPitchRoll(YoDouble yaw, YoDouble pitch, YoDouble roll) {
        double pitchArgument = -2.0 * this.q_qx.getDoubleValue() * this.q_qz.getDoubleValue() + 2.0 * this.q_qs.getDoubleValue() * this.q_qy.getDoubleValue();
        pitch.set(FastMath.asin((double)pitchArgument));
        if (Math.abs(pitch.getDoubleValue()) < 1.5393804002589986) {
            yaw.set(FastMath.atan2((double)(2.0 * this.q_qx.getDoubleValue() * this.q_qy.getDoubleValue() + 2.0 * this.q_qz.getDoubleValue() * this.q_qs.getDoubleValue()), (double)(1.0 - 2.0 * this.q_qy.getDoubleValue() * this.q_qy.getDoubleValue() - 2.0 * this.q_qz.getDoubleValue() * this.q_qz.getDoubleValue())));
            roll.set(FastMath.atan2((double)(2.0 * this.q_qy.getDoubleValue() * this.q_qz.getDoubleValue() + 2.0 * this.q_qx.getDoubleValue() * this.q_qs.getDoubleValue()), (double)(1.0 - 2.0 * this.q_qx.getDoubleValue() * this.q_qx.getDoubleValue() - 2.0 * this.q_qy.getDoubleValue() * this.q_qy.getDoubleValue())));
        } else {
            yaw.set(2.0 * FastMath.atan2((double)this.q_qz.getDoubleValue(), (double)this.q_qs.getDoubleValue()));
            roll.set(0.0);
        }
    }

    public double[] getYawPitchRoll() {
        double[] yawPitchRollToReturn = new double[3];
        double pitchArgument = -2.0 * this.q_qx.getDoubleValue() * this.q_qz.getDoubleValue() + 2.0 * this.q_qs.getDoubleValue() * this.q_qy.getDoubleValue();
        double pitch = 0.0;
        double roll = 0.0;
        double yaw = 0.0;
        pitch = FastMath.asin((double)pitchArgument);
        if (Math.abs(pitch) < 1.5393804002589986) {
            yaw = FastMath.atan2((double)(2.0 * this.q_qx.getDoubleValue() * this.q_qy.getDoubleValue() + 2.0 * this.q_qz.getDoubleValue() * this.q_qs.getDoubleValue()), (double)(1.0 - 2.0 * this.q_qy.getDoubleValue() * this.q_qy.getDoubleValue() - 2.0 * this.q_qz.getDoubleValue() * this.q_qz.getDoubleValue()));
            roll = FastMath.atan2((double)(2.0 * this.q_qy.getDoubleValue() * this.q_qz.getDoubleValue() + 2.0 * this.q_qx.getDoubleValue() * this.q_qs.getDoubleValue()), (double)(1.0 - 2.0 * this.q_qx.getDoubleValue() * this.q_qx.getDoubleValue() - 2.0 * this.q_qy.getDoubleValue() * this.q_qy.getDoubleValue()));
        } else {
            yaw = 2.0 * FastMath.atan2((double)this.q_qz.getDoubleValue(), (double)this.q_qs.getDoubleValue());
            roll = 0.0;
        }
        yawPitchRollToReturn[0] = yaw;
        yawPitchRollToReturn[1] = pitch;
        yawPitchRollToReturn[2] = roll;
        return yawPitchRollToReturn;
    }

    public boolean isPinned() {
        return this.isPinned.getValue();
    }

    public void setPinned(boolean isPinned) {
        this.isPinned.set(isPinned);
    }

    @Override
    public void update() {
        this.jointTransform3D.set((Orientation3DReadOnly)this.quaternion, (Tuple3DReadOnly)this.position);
        if (this.createYawPitchRollYoVariable) {
            this.getYawPitchRoll(this.q_yaw, this.q_pitch, this.q_roll);
        }
    }
}

