/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.util;

import java.util.StringTokenizer;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;

public class XMLReaderUtility {
    public static int getEndIndexOfSubString(int start, String fullString, String target) {
        return XMLReaderUtility.findSubstring(start, fullString, target)[1];
    }

    public static int getStartIndexOfSubString(int start, String fullString, String target) {
        return XMLReaderUtility.findSubstring(start, fullString, target)[0];
    }

    public static int[] findSubstring(int start, String fullString, String target) {
        int[] output = new int[]{-1, -1};
        if (start < 0) {
            return output;
        }
        if (fullString == null) {
            System.err.println("Full string is null!");
        }
        if (target == null) {
            System.err.println("Target is null!");
        }
        int i = start;
        while (target.length() + i <= fullString.length()) {
            if (fullString.substring(i, target.length() + i).equalsIgnoreCase(target)) {
                output[0] = i;
                output[1] = i + target.length();
                return output;
            }
            ++i;
        }
        return output;
    }

    public static void displayErrorMessage() {
        XMLReaderUtility.displayErrorMessage("Data Corrupted");
    }

    public static void displayErrorMessage(String message) {
        System.err.println(message);
    }

    public static String getMiddleString(int start, String fullString, String beginString, String endString) {
        int beginningIndex = XMLReaderUtility.findSubstring(start, fullString, beginString)[1];
        int endingIndex = XMLReaderUtility.findSubstring(beginningIndex, fullString, endString)[0];
        if (beginningIndex == -1 || endingIndex == -1) {
            return null;
        }
        return fullString.substring(beginningIndex, endingIndex).trim();
    }

    public static double parseDoubleBetweenTwoStrings(int start, String fullString, String beginString, String endString) {
        return XMLReaderUtility.parseDouble(XMLReaderUtility.getMiddleString(start, fullString, beginString, endString));
    }

    public static boolean parseBooleanBetweenTwoStrings(int start, String fullString, String beginString, String endString) {
        return XMLReaderUtility.parseBoolean(XMLReaderUtility.getMiddleString(start, fullString, beginString, endString));
    }

    public static int parseIntegerBetweenTwoStrings(int start, String fullString, String beginString, String endString) {
        return XMLReaderUtility.parseInt(XMLReaderUtility.getMiddleString(start, fullString, beginString, endString));
    }

    public static boolean parseBoolean(String bool) {
        try {
            return Boolean.parseBoolean(bool);
        }
        catch (Exception e) {
            XMLReaderUtility.displayErrorMessage();
            return false;
        }
    }

    public static double parseDouble(String doubleValue) {
        try {
            return Double.parseDouble(doubleValue);
        }
        catch (Exception e) {
            XMLReaderUtility.displayErrorMessage();
            return -1.0;
        }
    }

    public static int parseInt(String integer) {
        try {
            return Integer.parseInt(integer);
        }
        catch (Exception e) {
            XMLReaderUtility.displayErrorMessage();
            return -1;
        }
    }

    public static Vector3D parseVector3d(String vector) {
        if (vector == null) {
            return null;
        }
        vector = XMLReaderUtility.replaceAll(vector, "(", "");
        vector = XMLReaderUtility.replaceAll(vector, ")", "");
        vector = vector.replaceAll(" ", "");
        StringTokenizer tokenizer = new StringTokenizer(vector, ",");
        try {
            return new Vector3D(new double[]{Double.parseDouble(tokenizer.nextToken()), Double.parseDouble(tokenizer.nextToken()), Double.parseDouble(tokenizer.nextToken())});
        }
        catch (Exception e) {
            XMLReaderUtility.displayErrorMessage(vector);
            return null;
        }
    }

    public static String matrix3DToString(Matrix3DReadOnly matrix3D) {
        String ret = matrix3D.toString().replaceAll("\n", ", ");
        return ret.substring(0, ret.length() - 2);
    }

    public static Matrix3D parseMatrix3d(String matrix3d) {
        matrix3d = matrix3d.replaceAll(" ", "");
        StringTokenizer tokenizer = new StringTokenizer(matrix3d, ",");
        try {
            Matrix3D m = new Matrix3D(Double.parseDouble(tokenizer.nextToken()), Double.parseDouble(tokenizer.nextToken()), Double.parseDouble(tokenizer.nextToken()), Double.parseDouble(tokenizer.nextToken()), Double.parseDouble(tokenizer.nextToken()), Double.parseDouble(tokenizer.nextToken()), Double.parseDouble(tokenizer.nextToken()), Double.parseDouble(tokenizer.nextToken()), Double.parseDouble(tokenizer.nextToken()));
            return m;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String replaceAll(String source, String toReplace, String replacement) {
        int idx = source.lastIndexOf(toReplace);
        if (idx != -1) {
            StringBuffer ret = new StringBuffer(source);
            ret.replace(idx, idx + toReplace.length(), replacement);
            while ((idx = source.lastIndexOf(toReplace, idx - 1)) != -1) {
                ret.replace(idx, idx + toReplace.length(), replacement);
            }
            source = ret.toString();
        }
        return source;
    }
}

