/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.util;

import org.junit.jupiter.api.Test;
import us.ihmc.commons.MutationTestFacilitator;
import us.ihmc.robotics.Assert;
import us.ihmc.simulationconstructionset.util.QuarticRootFinder;

public class QuarticRootFinderTest {
    private static final boolean DEBUG = false;

    @Test
    public void testQuarticRootFinder() {
        double[] realSolutions = new double[4];
        int numberOfRealSolutions = 0;
        QuarticRootFinder solver = new QuarticRootFinder();
        this.printIfDebug("Quatric Root Finder.  Tests...");
        this.printIfDebug("Test Quadratic Equation Solver First.  Solutions to 3.0x^2 + 2.1x + 9.5 are:");
        numberOfRealSolutions = solver.SolveQuadric(new double[]{9.5, 2.1, 3.0}, realSolutions);
        Assert.assertEquals(0L, numberOfRealSolutions);
        QuarticRootFinderTest.printSolution(numberOfRealSolutions, realSolutions);
        this.printIfDebug("Answer should be   -0.3500000000 + 1.744754042*I,    -0.3500000000 - 1.744754042*I");
        this.printIfDebug("");
        this.printIfDebug("Test Cubic Equation Solver Next.  Solutions to x^3 - x^2 + x -1 are:");
        numberOfRealSolutions = solver.SolveCubic(new double[]{-1.0, 1.0, -1.0, 1.0}, realSolutions);
        Assert.assertEquals(1L, numberOfRealSolutions);
        this.assertSolutionContains(1.0, realSolutions);
        QuarticRootFinderTest.printSolution(numberOfRealSolutions, realSolutions);
        this.printIfDebug("Answer should be   1.0,    I,    -I");
        this.printIfDebug("");
        this.printIfDebug("Test another Cubic Equation Solver Next.  Solutions to x^3 + 6x^2 + 9x + 6 are:");
        numberOfRealSolutions = solver.SolveCubic(new double[]{6.0, 9.0, 6.0, 1.0}, realSolutions);
        Assert.assertEquals(1L, numberOfRealSolutions);
        this.assertSolutionContains(-4.195823345, realSolutions);
        QuarticRootFinderTest.printSolution(numberOfRealSolutions, realSolutions);
        this.printIfDebug("Answer should be -4.195823345,   -.9020883273-.7850032632*I,   -.9020883273+.7850032632*I");
        this.printIfDebug("");
        this.printIfDebug("Test another Cubic Equation Solver Next.  Solutions to x^3 - 1 are:");
        numberOfRealSolutions = solver.SolveCubic(new double[]{-1.0, 0.0, 0.0, 1.0}, realSolutions);
        Assert.assertEquals(1L, numberOfRealSolutions);
        this.assertSolutionContains(1.0, realSolutions);
        QuarticRootFinderTest.printSolution(numberOfRealSolutions, realSolutions);
        this.printIfDebug("Answer should be 1.0,  -0.5000000000 + 0.8660254038*I,   -0.5000000000 - 0.8660254038*I");
        this.printIfDebug("");
        this.printIfDebug("Test another Cubic Equation Solver Next.  Solutions to x^3 + 2x^2 - 5x - 6 are:");
        numberOfRealSolutions = solver.SolveCubic(new double[]{-6.0, -5.0, 2.0, 1.0}, realSolutions);
        Assert.assertEquals(3L, numberOfRealSolutions);
        this.assertSolutionContains(-1.0, realSolutions);
        this.assertSolutionContains(2.0, realSolutions);
        this.assertSolutionContains(-3.0, realSolutions);
        QuarticRootFinderTest.printSolution(numberOfRealSolutions, realSolutions);
        this.printIfDebug("Answer should be: -1, 2, -3");
        this.printIfDebug("");
        this.printIfDebug("Test Quartic Equation Solver .  Solutions to x^4 + 6x^3 - 5x^2 - 10x -3 are:");
        numberOfRealSolutions = solver.SolveQuartic(new double[]{-3.0, -10.0, -5.0, 6.0, 1.0}, realSolutions);
        Assert.assertEquals(4L, numberOfRealSolutions);
        this.assertSolutionContains(1.618033989, realSolutions);
        this.assertSolutionContains(-0.6180339888, realSolutions);
        this.assertSolutionContains(-0.4586187348, realSolutions);
        this.assertSolutionContains(-6.541381265, realSolutions);
        this.printIfDebug("There are " + numberOfRealSolutions + " real valued solutions.  They are : ");
        QuarticRootFinderTest.printSolution(numberOfRealSolutions, realSolutions);
        this.printIfDebug("Answer should be:  1.618033989,   -0.6180339888,   -0.4586187348,   -6.541381265");
        this.printIfDebug("");
    }

    private static void printSolution(int num, double[] real_solutions) {
        for (int i = 0; i < num; ++i) {
        }
    }

    private void printIfDebug(String string) {
    }

    private void assertSolutionContains(double realPart, double[] realSolutions) {
        for (int i = 0; i < realSolutions.length; ++i) {
            if (!(Math.abs(realSolutions[i] - realPart) < 1.0E-7)) continue;
            return;
        }
        String errorMessage = "Cannot find " + realPart + " Solutions are: ";
        for (int i = 0; i < realSolutions.length; ++i) {
            errorMessage = errorMessage + "\n " + realSolutions[i];
        }
        Assert.fail(errorMessage);
    }

    public static void main(String[] args) {
        MutationTestFacilitator.facilitateMutationTestForClass(QuarticRootFinder.class, QuarticRootFinderTest.class);
    }
}

