/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.Assert;
import us.ihmc.simulationconstructionset.Joint;
import us.ihmc.simulationconstructionset.KinematicPoint;
import us.ihmc.simulationconstructionset.PinJoint;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;

public class KinematicPointTest {
    Vector3D offset;
    Robot robot;
    KinematicPoint kinematicPoint;

    @BeforeEach
    public void setUp() {
        this.offset = new Vector3D(1.0, 2.0, 3.0);
        this.robot = new Robot("testRobot");
        this.kinematicPoint = new KinematicPoint("testPoint", (Tuple3DReadOnly)this.offset, this.robot.getRobotsYoRegistry());
    }

    @Test
    public void testGetAndSetParentJoint() {
        PinJoint joint = new PinJoint("joint", (Tuple3DReadOnly)new Vector3D(0.0, 0.0, 0.0), this.robot, (Vector3DReadOnly)Axis3D.X);
        this.robot.addRootJoint((Joint)joint);
        this.kinematicPoint.setParentJoint((Joint)joint);
        Assert.assertTrue(joint == this.kinematicPoint.getParentJoint());
    }

    @Test
    public void testToString() {
        Assert.assertEquals("name: testPoint x: 0.0, y: 0.0, z: 0.0", this.kinematicPoint.toString());
    }

    @Test
    public void testSetOffsetJointWithBothVectorAndXYAndZValuesAsParameters() {
        Robot robot = new Robot("testRobot");
        KinematicPoint kinematicPoint = new KinematicPoint("testPoint", robot.getRobotsYoRegistry());
        Assert.assertTrue(0.0 == kinematicPoint.getOffsetCopy().getX());
        Assert.assertTrue(0.0 == kinematicPoint.getOffsetCopy().getY());
        Assert.assertTrue(0.0 == kinematicPoint.getOffsetCopy().getZ());
        kinematicPoint.setOffsetJoint(3.0, 4.0, 7.0);
        Assert.assertTrue(3.0 == kinematicPoint.getOffsetCopy().getX());
        Assert.assertTrue(4.0 == kinematicPoint.getOffsetCopy().getY());
        Assert.assertTrue(7.0 == kinematicPoint.getOffsetCopy().getZ());
        Vector3D vectorTest = new Vector3D(9.0, 1.0, 5.0);
        kinematicPoint.setOffsetJoint((Tuple3DReadOnly)vectorTest);
        Assert.assertTrue(9.0 == kinematicPoint.getOffsetCopy().getX());
        Assert.assertTrue(1.0 == kinematicPoint.getOffsetCopy().getY());
        Assert.assertTrue(5.0 == kinematicPoint.getOffsetCopy().getZ());
    }

    @Test
    public void testGetName() {
        Assert.assertTrue(this.kinematicPoint.getName() == "testPoint");
    }

    @Test
    public void testGetPosition() {
        Point3D positionToPack = new Point3D();
        this.kinematicPoint.getPosition((Tuple3DBasics)positionToPack);
        Assert.assertTrue(0.0 == positionToPack.getX());
        Assert.assertTrue(0.0 == positionToPack.getY());
        Assert.assertTrue(0.0 == positionToPack.getZ());
        this.kinematicPoint.getYoPosition().set((Tuple3DReadOnly)new Point3D(5.0, 5.1, 5.2));
        this.kinematicPoint.getPosition((Tuple3DBasics)positionToPack);
        Assert.assertTrue(5.0 == positionToPack.getX());
        Assert.assertTrue(5.1 == positionToPack.getY());
        Assert.assertTrue(5.2 == positionToPack.getZ());
    }

    @Test
    public void testGetPositionPoint() {
        Point3D positionReceivedFromGetMethod = this.kinematicPoint.getPositionCopy();
        Assert.assertTrue(0.0 == positionReceivedFromGetMethod.getX());
        Assert.assertTrue(0.0 == positionReceivedFromGetMethod.getY());
        Assert.assertTrue(0.0 == positionReceivedFromGetMethod.getZ());
        this.kinematicPoint.getYoPosition().set((Tuple3DReadOnly)new Point3D(5.0, 5.1, 5.2));
        positionReceivedFromGetMethod = this.kinematicPoint.getPositionCopy();
        Assert.assertTrue(5.0 == positionReceivedFromGetMethod.getX());
        Assert.assertTrue(5.1 == positionReceivedFromGetMethod.getY());
        Assert.assertTrue(5.2 == positionReceivedFromGetMethod.getZ());
    }

    @Test
    public void testGetVelocityVector() {
        Vector3D vectorReceivedFromGetMethod = this.kinematicPoint.getVelocityCopy();
        Assert.assertTrue(0.0 == vectorReceivedFromGetMethod.getX());
        Assert.assertTrue(0.0 == vectorReceivedFromGetMethod.getY());
        Assert.assertTrue(0.0 == vectorReceivedFromGetMethod.getZ());
        this.kinematicPoint.getYoVelocity().set((Tuple3DReadOnly)new Vector3D(5.0, 5.1, 5.2));
        vectorReceivedFromGetMethod = this.kinematicPoint.getVelocityCopy();
        Assert.assertTrue(5.0 == vectorReceivedFromGetMethod.getX());
        Assert.assertTrue(5.1 == vectorReceivedFromGetMethod.getY());
        Assert.assertTrue(5.2 == vectorReceivedFromGetMethod.getZ());
    }

    @Test
    public void testGetVelocity() {
        Vector3D velocityToPack = this.kinematicPoint.getVelocityCopy();
        this.kinematicPoint.getVelocity((Vector3DBasics)velocityToPack);
        Assert.assertTrue(0.0 == velocityToPack.getX());
        Assert.assertTrue(0.0 == velocityToPack.getY());
        Assert.assertTrue(0.0 == velocityToPack.getZ());
        this.kinematicPoint.getYoVelocity().set((Tuple3DReadOnly)new Vector3D(5.0, 5.1, 5.2));
        this.kinematicPoint.getVelocity((Vector3DBasics)velocityToPack);
        Assert.assertTrue(5.0 == velocityToPack.getX());
        Assert.assertTrue(5.1 == velocityToPack.getY());
        Assert.assertTrue(5.2 == velocityToPack.getZ());
    }

    @Test
    public void testGetYoPosition() {
        YoFramePoint3D yoPosition = this.kinematicPoint.getYoPosition();
        String frameName = yoPosition.getReferenceFrame().getName();
        Assert.assertEquals("( 0.000,  0.000,  0.000 ) - " + frameName, yoPosition.toString());
        yoPosition.set((Tuple3DReadOnly)new Point3D(5.0, 5.1, 5.2));
        Assert.assertEquals("( 5.000,  5.100,  5.200 ) - " + frameName, yoPosition.toString());
    }

    @Test
    public void testGetYoVelocity() {
        YoFrameVector3D yoVelocity = this.kinematicPoint.getYoVelocity();
        String frameName = yoVelocity.getReferenceFrame().getName();
        Assert.assertEquals("( 0.000,  0.000,  0.000 ) - " + frameName, yoVelocity.toString());
        yoVelocity.set((Tuple3DReadOnly)new Vector3D(5.0, 5.1, 5.2));
        Assert.assertEquals("( 5.000,  5.100,  5.200 ) - " + frameName, yoVelocity.toString());
    }

    @Test
    public void testChangeableOffset() {
        Robot robot = new Robot("testRobot");
        KinematicPoint kinematicPoint = new KinematicPoint("kp_test", robot.getRobotsYoRegistry());
        Vector3D offset = new Vector3D(0.1, 0.2, 0.3);
        kinematicPoint.setOffsetJoint((Tuple3DReadOnly)offset);
        Vector3D offsetCopy = kinematicPoint.getOffsetCopy();
        EuclidCoreTestTools.assertEquals((EuclidGeometry)offset, (EuclidGeometry)offsetCopy, (double)1.0E-14);
    }
}

