/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset;

import java.util.ArrayList;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.MeshDataGenerator;
import us.ihmc.graphicsDescription.MeshDataHolder;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.simulationconstructionset.Link;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.SimulationConstructionSetParameters;

public class LinkGraphicsTest {
    private static SimulationConstructionSetParameters parameters = SimulationConstructionSetParameters.createFromSystemProperties();
    private SimulationConstructionSet sim;
    private static final double CUBE_L = 0.2;
    private static final double CUBE_W = 0.1;
    private static final double CUBE_H = 0.3;
    private static final double SPHERE_R = 0.15;
    private static final double ELLIPSOID_RX = 0.1;
    private static final double ELLIPSOID_RY = 0.2;
    private static final double ELLIPSOID_RZ = 0.3;
    private static final double HEMI_ELLIPSOID_RX = 0.2;
    private static final double HEMI_ELLIPSOID_RY = 0.1;
    private static final double HEMI_ELLIPSOID_RZ = 0.4;
    private static final double CYLINDER_H = 0.4;
    private static final double CYLINDER_R = 0.05;
    private static final double CONE_H = 0.4;
    private static final double CONE_R = 0.1;
    private static final double GEN_TRUNCATED_CONE_HEIGHT = 0.2;
    private static final double GEN_TRUNCATED_CONE_BX = 0.15;
    private static final double GEN_TRUNCATED_CONE_BY = 0.15;
    private static final double GEN_TRUNCATED_CONE_TX = 0.1;
    private static final double GEN_TRUNCATED_CONE_TY = 0.05;
    private static final double ARC_TORUS_START_ANG = 0.0;
    private static final double ARC_TORUS_END_ANG = 4.71238898038469;
    private static final double ARC_TORUS_MAJ_RAD = 0.2;
    private static final double ARC_TORUS_MIN_RAD = 0.05;
    private static final double PYRAMID_CUBE_LX = 0.15;
    private static final double PYRAMID_CUBE_LY = 0.15;
    private static final double PYRAMID_CUBE_LZ = 0.08;
    private static final double PYRAMID_CUBE_LH = 0.15;
    private static final double OFFSET = 1.2;
    private static final double COORD_LENGTH = 0.5;
    private static final double WEDGE_X = 0.4;
    private static final double WEDGE_Y = 0.3;
    private static final double WEDGE_Z = 0.2;

    @Test
    public void testLinkGraphicsWithALargeNumberOfExampleShapes() {
        Link link = this.aLargerNumberOfExampleShapes();
        this.startSimAndDisplayLink(link);
    }

    @Test
    public void testLinkGraphicsWithASmallNumberOfExampleShapes() {
        Link link = this.aSmallNumberOfExampleShapes();
        this.startSimAndDisplayLink(link);
    }

    @Test
    public void testLinkGraphicsWithArcTorus() {
        Link link = this.exampleArcTorusShape();
        this.startSimAndDisplayLink(link);
    }

    @Test
    public void testLinkGrapicsWithMeshData() {
        Link link = this.exampleMeshDataShape();
        this.startSimAndDisplayLink(link);
    }

    @Test
    public void testLinkGrapicsWithCone() {
        Link link = this.exampleConeShape();
        this.startSimAndDisplayLink(link);
    }

    @Test
    public void testLinkGrapicsWithExtrudedPolygon() {
        Link link = this.exampleExtrudedPolygonShape();
        this.startSimAndDisplayLink(link);
    }

    private void startSimAndDisplayLink(Link linkToDisplay) {
        this.sim = new SimulationConstructionSet(parameters);
        this.sim.addStaticLink(linkToDisplay);
        this.sim.setCameraPosition(6.0, 6.0, 3.0);
        this.sim.setCameraFix(0.5, 0.5, 0.0);
        this.sim.setGroundVisible(false);
        this.sim.startOnAThread();
        ThreadTools.sleep((long)3000L);
        this.sim.closeAndDispose();
    }

    private Link aSmallNumberOfExampleShapes() {
        Link ret = new Link("example shapes");
        Graphics3DObject linkGraphics = new Graphics3DObject();
        linkGraphics.addCoordinateSystem(0.5);
        linkGraphics.addCube(0.2, 0.1, 0.3, YoAppearance.Teal());
        linkGraphics.translate(1.2, 0.0, 0.0);
        linkGraphics.addCoordinateSystem(0.5);
        linkGraphics.addSphere(0.15, YoAppearance.Aqua());
        linkGraphics.translate(1.2, 0.0, 0.0);
        linkGraphics.addCoordinateSystem(0.5);
        linkGraphics.addEllipsoid(0.1, 0.2, 0.3, YoAppearance.Navy());
        ret.setLinkGraphics(linkGraphics);
        return ret;
    }

    private Link aLargerNumberOfExampleShapes() {
        Link ret = new Link("example shapes");
        Graphics3DObject linkGraphics = new Graphics3DObject();
        linkGraphics.addCoordinateSystem(0.5);
        linkGraphics.addCube(0.2, 0.1, 0.3, YoAppearance.Teal());
        linkGraphics.translate(1.2, 0.0, 0.0);
        linkGraphics.addCoordinateSystem(0.5);
        linkGraphics.addSphere(0.15, YoAppearance.Aqua());
        linkGraphics.translate(1.2, 0.0, 0.0);
        linkGraphics.addCoordinateSystem(0.5);
        linkGraphics.addEllipsoid(0.1, 0.2, 0.3, YoAppearance.Navy());
        linkGraphics.translate(-2.4, 1.2, 0.0);
        linkGraphics.addCoordinateSystem(0.5);
        linkGraphics.addHemiEllipsoid(0.2, 0.1, 0.4, YoAppearance.DarkBlue());
        linkGraphics.translate(1.2, 0.0, 0.0);
        linkGraphics.addCoordinateSystem(0.5);
        linkGraphics.addCylinder(0.4, 0.05, YoAppearance.Green());
        linkGraphics.translate(1.2, 0.0, 0.0);
        linkGraphics.addCoordinateSystem(0.5);
        linkGraphics.addCone(0.4, 0.1, YoAppearance.DarkGreen());
        linkGraphics.translate(-2.4, 1.2, 0.0);
        linkGraphics.addCoordinateSystem(0.5);
        linkGraphics.addGenTruncatedCone(0.2, 0.15, 0.15, 0.1, 0.05, YoAppearance.Red());
        linkGraphics.translate(1.2, 0.0, 0.0);
        linkGraphics.addCoordinateSystem(0.5);
        linkGraphics.addArcTorus(0.0, 4.71238898038469, 0.2, 0.05, YoAppearance.DarkRed());
        linkGraphics.translate(1.2, 0.0, 0.0);
        linkGraphics.addCoordinateSystem(0.5);
        linkGraphics.addPyramidCube(0.15, 0.15, 0.08, 0.15, YoAppearance.BlackMetalMaterial());
        linkGraphics.translate(-2.4, 1.2, 0.0);
        linkGraphics.addCoordinateSystem(0.5);
        ArrayList<Point2D> polygonPoints = new ArrayList<Point2D>();
        polygonPoints.add(new Point2D(0.0, 0.0));
        polygonPoints.add(new Point2D(0.4, 0.0));
        polygonPoints.add(new Point2D(0.3, 0.3));
        double height = 0.25;
        linkGraphics.addExtrudedPolygon(polygonPoints, height, YoAppearance.Purple());
        linkGraphics.translate(1.2, 0.0, 0.0);
        linkGraphics.addCoordinateSystem(0.5);
        MeshDataHolder meshData = MeshDataGenerator.Wedge((double)0.4, (double)0.3, (double)0.2);
        AppearanceDefinition meshAppearance = YoAppearance.Gold();
        linkGraphics.addMeshData(meshData, meshAppearance);
        ret.setLinkGraphics(linkGraphics);
        return ret;
    }

    private Link exampleConeShape() {
        Link ret = new Link("exampleArcTorusShape");
        Graphics3DObject linkGraphics = new Graphics3DObject();
        linkGraphics.translate(1.2, 0.0, 0.0);
        linkGraphics.addCoordinateSystem(0.5);
        linkGraphics.addCone(0.4, 0.1, YoAppearance.DarkGreen());
        ret.setLinkGraphics(linkGraphics);
        return ret;
    }

    private Link exampleExtrudedPolygonShape() {
        Link ret = new Link("exampleExtrudedPolygonShape");
        Graphics3DObject linkGraphics = new Graphics3DObject();
        linkGraphics.translate(-2.4, 1.2, 0.0);
        linkGraphics.addCoordinateSystem(0.5);
        ArrayList<Point2D> polygonPoints = new ArrayList<Point2D>();
        polygonPoints.add(new Point2D(0.0, 0.0));
        polygonPoints.add(new Point2D(0.4, 0.0));
        polygonPoints.add(new Point2D(0.3, 0.3));
        double height = 0.25;
        linkGraphics.addExtrudedPolygon(polygonPoints, height, YoAppearance.Purple());
        ret.setLinkGraphics(linkGraphics);
        return ret;
    }

    private Link exampleArcTorusShape() {
        Link ret = new Link("exampleArcTorusShape");
        Graphics3DObject linkGraphics = new Graphics3DObject();
        linkGraphics.translate(1.2, 0.0, 0.0);
        linkGraphics.addCoordinateSystem(0.5);
        linkGraphics.addArcTorus(0.0, 4.71238898038469, 0.2, 0.05, YoAppearance.DarkRed());
        ret.setLinkGraphics(linkGraphics);
        return ret;
    }

    private Link exampleMeshDataShape() {
        Link ret = new Link("exampleArcTorusShape");
        Graphics3DObject linkGraphics = new Graphics3DObject();
        linkGraphics.translate(1.2, 0.0, 0.0);
        linkGraphics.addCoordinateSystem(0.5);
        MeshDataHolder meshData = MeshDataGenerator.Wedge((double)0.4, (double)0.3, (double)0.2);
        AppearanceDefinition meshAppearance = YoAppearance.Gold();
        linkGraphics.addMeshData(meshData, meshAppearance);
        ret.setLinkGraphics(linkGraphics);
        return ret;
    }
}

