/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.physics.collision.simple;

import org.junit.jupiter.api.Test;
import us.ihmc.commons.MutationTestFacilitator;
import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.robotics.Assert;
import us.ihmc.simulationconstructionset.physics.collision.simple.CylinderShapeDescription;

public class CylinderShapeDescriptionTest {
    @Test
    public void testProjectionWhenNotTransformed() {
        double radius = 0.5;
        double height = 0.1;
        CylinderShapeDescription cylinder = new CylinderShapeDescription(radius, height);
        Assert.assertEquals(radius, cylinder.getRadius(), 1.0E-10);
        Assert.assertEquals(height, cylinder.getHeight(), 1.0E-10);
        Assert.assertEquals(0.0, cylinder.getSmoothingRadius(), 1.0E-10);
        Point3D pointToProject = new Point3D(0.0, 0.0, 100.0);
        Point3D closestPointOnCylinder = new Point3D();
        cylinder.getProjection(pointToProject, closestPointOnCylinder);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point3D(0.0, 0.0, height / 2.0), (EuclidGeometry)closestPointOnCylinder, (double)1.0E-7);
        pointToProject = new Point3D(0.0, 0.0, -100.0);
        cylinder.getProjection(pointToProject, closestPointOnCylinder);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point3D(0.0, 0.0, -height / 2.0), (EuclidGeometry)closestPointOnCylinder, (double)1.0E-7);
        pointToProject = new Point3D(100.0, 0.0, 10.0);
        cylinder.getProjection(pointToProject, closestPointOnCylinder);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point3D(radius, 0.0, height / 2.0), (EuclidGeometry)closestPointOnCylinder, (double)1.0E-7);
        pointToProject = new Point3D(0.0, -20.0, 10.0);
        cylinder.getProjection(pointToProject, closestPointOnCylinder);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point3D(0.0, -radius, height / 2.0), (EuclidGeometry)closestPointOnCylinder, (double)1.0E-7);
        pointToProject = new Point3D(10.0, 10.0, height * 0.1);
        cylinder.getProjection(pointToProject, closestPointOnCylinder);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point3D(radius * Math.sqrt(2.0) / 2.0, radius * Math.sqrt(2.0) / 2.0, height * 0.1), (EuclidGeometry)closestPointOnCylinder, (double)1.0E-7);
    }

    @Test
    public void testProjectionWhenRotated() {
        double radius = 0.5;
        double height = 0.1;
        CylinderShapeDescription cylinder = new CylinderShapeDescription(radius, height);
        RigidBodyTransform transform = new RigidBodyTransform();
        double angle = 0.4487989505128276;
        transform.appendPitchRotation(angle);
        cylinder.applyTransform(transform);
        Point3D expectedPoint = new Point3D(-radius, 0.0, height / 2.0);
        transform.transform((Point3DBasics)expectedPoint);
        Point3D pointToProject = new Point3D(0.0, 0.0, 100.0);
        Point3D closestPointOnCylinder = new Point3D();
        cylinder.getProjection(pointToProject, closestPointOnCylinder);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPoint, (EuclidGeometry)closestPointOnCylinder, (double)1.0E-7);
        pointToProject = new Point3D(0.0, 0.0, -100.0);
        expectedPoint = new Point3D(radius, 0.0, -height / 2.0);
        transform.transform((Point3DBasics)expectedPoint);
        cylinder.getProjection(pointToProject, closestPointOnCylinder);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPoint, (EuclidGeometry)closestPointOnCylinder, (double)1.0E-7);
        pointToProject = new Point3D(100.0, 0.0, 10.0);
        expectedPoint = new Point3D(radius, 0.0, height / 2.0);
        transform.transform((Point3DBasics)expectedPoint);
        cylinder.getProjection(pointToProject, closestPointOnCylinder);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPoint, (EuclidGeometry)closestPointOnCylinder, (double)1.0E-7);
    }

    @Test
    public void testBoundingBox() {
        double radius = 0.5;
        double height = 0.1;
        CylinderShapeDescription cylinder = new CylinderShapeDescription(radius, height);
        BoundingBox3D boundingBox = new BoundingBox3D(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        cylinder.getBoundingBox(boundingBox);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point3D(-0.5, -0.5, -0.05), (EuclidGeometry)boundingBox.getMinPoint(), (double)1.0E-10);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point3D(0.5, 0.5, 0.05), (EuclidGeometry)boundingBox.getMaxPoint(), (double)1.0E-10);
        RigidBodyTransform transform = new RigidBodyTransform();
        transform.setRotationEulerAndZeroTranslation(0.7853981633974483, 0.0, 0.0);
        cylinder.applyTransform(transform);
        cylinder.getBoundingBox(boundingBox);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point3D(-0.5, -0.38890872965260115, -0.3889087296526011), (EuclidGeometry)boundingBox.getMinPoint(), (double)1.0E-10);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point3D(0.5, 0.38890872965260115, 0.3889087296526011), (EuclidGeometry)boundingBox.getMaxPoint(), (double)1.0E-10);
    }

    public static void main(String[] args) {
        MutationTestFacilitator.facilitateMutationTestForClass(CylinderShapeDescription.class, CylinderShapeDescriptionTest.class);
    }
}

