/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.physics.featherstone;

import us.ihmc.commons.MathTools;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.simulationconstructionset.Joint;
import us.ihmc.simulationconstructionset.Link;
import us.ihmc.simulationconstructionset.PinJoint;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.physics.featherstone.RobotWithClosedFormDynamics;

public class SinglePendulumRobot
extends RobotWithClosedFormDynamics {
    private final double mass = 1.0;
    private final double length = 1.0;
    private final double Ixx = 0.5;
    private final Axis3D axis = Axis3D.X;
    private final double damping = 0.1;
    private final PinJoint pinJoint;

    public SinglePendulumRobot(String name, double initialQ, double initialQd) {
        super(name);
        this.pinJoint = new PinJoint(name + "Joint", (Tuple3DReadOnly)new Vector3D(), (Robot)this, (Vector3DReadOnly)this.axis);
        Link link = new Link(name + "Link");
        link.setMass(1.0);
        link.setMomentOfInertia(0.5, 0.0, 0.0);
        link.setComOffset(0.0, 0.0, -0.5);
        this.pinJoint.setLink(link);
        this.pinJoint.setDamping(0.1);
        this.addRootJoint((Joint)this.pinJoint);
        this.pinJoint.setQ(initialQ);
        this.pinJoint.setQd(initialQd);
    }

    @Override
    public void assertStateIsCloseToClosedFormCalculation(double epsilon) throws AssertionError {
        double qddLagrangian;
        double q = this.pinJoint.getQ();
        double qd = this.pinJoint.getQD();
        double qdd = this.pinJoint.getQDD();
        if (Math.abs(qdd - (qddLagrangian = (1.0 * this.getGravityZ() * 0.5 * Math.sin(q) - 0.1 * qd) / (0.5 + 1.0 * MathTools.square((double)0.5)))) > epsilon) {
            throw new AssertionError((Object)("Joint accelerations from simulation and lagrangian don't match. At t=" + this.getTime() + ", simulated joint acceleration = " + qdd + ", lagrangian acceleration = " + qddLagrangian));
        }
    }
}

