/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.util.ground;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.robotics.Assert;
import us.ihmc.simulationconstructionset.util.ground.RotatableRampTerrainObject;

public class RotatableRampTerrainObjectTest {
    private RotatableRampTerrainObject simpleRamp;
    private RotatableRampTerrainObject simpleRampDown;
    private RotatableRampTerrainObject ramp90;
    private RotatableRampTerrainObject simpleRampTranslated;
    private RotatableRampTerrainObject ramp90Translated;
    private double epsilon = 1.0E-12;
    private Point3D[] pointsOnSimpleRamp = new Point3D[]{new Point3D(0.0, 0.0, 0.0), new Point3D(1.0, 0.0, 1.0), new Point3D(0.5, 0.0, 0.5), new Point3D(0.5, -1.0, 0.5), new Point3D(0.5, 1.0, 0.5), new Point3D(1.0, 1.0, 1.0), new Point3D(1.0, -1.0, 1.0)};
    private Point3D[] strictlyInternalPointsOnSimpleRampDown = new Point3D[]{new Point3D(0.001, 0.0, 0.999), new Point3D(0.999, 0.0, 0.001), new Point3D(0.5, 0.0, 0.5), new Point3D(0.5, -0.999, 0.5), new Point3D(0.5, 0.999, 0.5), new Point3D(0.999, 0.999, 0.001)};
    private Point3D[] pointsOnOtherRampFaces = new Point3D[]{new Point3D(1.0, 0.0, 0.5), new Point3D(0.5, 1.0, 0.25), new Point3D(0.5, -1.0, 0.25)};
    private Vector3D expectedSimpleSurfaceNormal = new Vector3D(-1.0, 0.0, 1.0);
    private Vector3D[] expectedSimpleSurfaceNormalOnOtherFaces = new Vector3D[]{new Vector3D(1.0, 0.0, 0.0), new Vector3D(0.0, 1.0, 0.0), new Vector3D(0.0, -1.0, 0.0)};
    private Point3D[] pointsOnOtherRampFacesSlopeDown = new Point3D[]{new Point3D(0.0, 0.0, 0.5), new Point3D(0.5, 1.0, 0.25), new Point3D(0.5, -1.0, 0.25)};
    private Vector3D expectedSimpleSurfaceNormalSlopeDown = new Vector3D(1.0, 0.0, 1.0);
    private Vector3D[] expectedSimpleSurfaceNormalOnOtherFacesSlopeDown = new Vector3D[]{new Vector3D(-1.0, 0.0, 0.0), new Vector3D(0.0, 1.0, 0.0), new Vector3D(0.0, -1.0, 0.0)};
    private Point3D[] pointsOnRamp90 = new Point3D[]{new Point3D(0.0, 0.0, 0.5), new Point3D(1.0, 0.0, 0.5), new Point3D(-1.0, 0.0, 0.5), new Point3D(0.0, -0.49, 0.01), new Point3D(1.0, -0.5, 0.0), new Point3D(-0.99, -0.499, 0.001), new Point3D(0.5, 0.25, 0.75), new Point3D(0.9, 0.4, 0.9), new Point3D(1.0, 0.4, 0.9), new Point3D(1.0, 0.45, 0.95), new Point3D(1.0, 0.499, 0.999), new Point3D(0.0, 0.5, 1.0), new Point3D(-1.0, 0.5, 1.0), new Point3D(0.9, 0.5, 1.0)};
    private Point3D[] pointsOnRamp90Translated = new Point3D[]{new Point3D(0.0, 0.0, 0.5), new Point3D(-0.99, -0.499, 0.001), new Point3D(0.9, 0.4, 0.9)};
    private Point3D[] pointsOnRamp90PassingHeightCornerCases = new Point3D[]{new Point3D(-1.0, -0.5, 0.0), new Point3D(0.0, -0.5, 0.0)};
    private Point3D[] pointsOnRamp90withNumericalRotationError = new Point3D[]{new Point3D(0.909, 0.5, 1.0), new Point3D(1.0, 0.5, 1.0)};
    private Vector3D expectedSurfaceNormalRamp90 = new Vector3D(0.0, -1.0, 1.0);
    private Point3D[] pointsOnOtherFacesRamp90 = new Point3D[]{new Point3D(0.0, 0.5, 0.5), new Point3D(1.0, 0.0, 0.25), new Point3D(-1.0, 0.0, 0.25)};
    private Vector3D[] expectedSurfaceNormalOnOtherFacesRamp90 = new Vector3D[]{new Vector3D(0.0, 1.0, 0.0), new Vector3D(1.0, 0.0, 0.0), new Vector3D(-1.0, 0.0, 0.0)};
    private static double transX = 3.0;
    private static double transY = 2.0;

    @BeforeEach
    public void setUp() throws Exception {
        this.simpleRamp = new RotatableRampTerrainObject(0.5, 0.0, 1.0, 2.0, 1.0, 0.0);
        this.simpleRampDown = new RotatableRampTerrainObject(0.5, 0.0, -1.0, 2.0, 1.0, 0.0);
        this.ramp90 = new RotatableRampTerrainObject(0.0, 0.0, 1.0, 2.0, 1.0, 90.0);
        this.simpleRampTranslated = new RotatableRampTerrainObject(transX + 0.5, transY, 1.0, 2.0, 1.0, 0.0);
        this.ramp90Translated = new RotatableRampTerrainObject(transX, transY, 1.0, 2.0, 1.0, 90.0);
    }

    @Test
    public void testHeightAt() {
        this.testHeightAtRampForAnyRamp(this.pointsOnSimpleRamp, this.simpleRamp);
    }

    @Test
    public void testHeightAtForRampDown() {
        this.testHeightAtRampForAnyRamp(this.strictlyInternalPointsOnSimpleRampDown, this.simpleRampDown);
    }

    @Test
    public void testSurfaceNormalAt() {
        this.testSurfaceNormalsForAnyRampFace(this.simpleRamp, this.expectedSimpleSurfaceNormal, this.pointsOnSimpleRamp);
    }

    @Test
    public void testOtherSurfaceNormalAt() {
        this.testSurfaceNormalsForAnyOtherRampSides(this.simpleRamp, this.expectedSimpleSurfaceNormalOnOtherFaces, this.pointsOnOtherRampFaces);
    }

    @Test
    public void testSurfaceNormalAtForSlopedDown() {
        this.testSurfaceNormalsForAnyRampFace(this.simpleRampDown, this.expectedSimpleSurfaceNormalSlopeDown, this.strictlyInternalPointsOnSimpleRampDown);
    }

    @Test
    public void testOtherSurfaceNormalAtForSlopedDown() {
        this.testSurfaceNormalsForAnyOtherRampSides(this.simpleRampDown, this.expectedSimpleSurfaceNormalOnOtherFacesSlopeDown, this.pointsOnOtherRampFacesSlopeDown);
    }

    @Test
    public void testHeightAtRamp90() {
        this.testHeightAtRampForAnyRamp(this.pointsOnRamp90, this.ramp90);
        this.testHeightAtRampForAnyRamp(this.pointsOnRamp90PassingHeightCornerCases, this.ramp90);
    }

    @Disabled
    @Test
    public void HeightAtRamp90EdgeCasesFailDueToNumericalErrorTest() {
        this.testHeightAtRampForAnyRamp(this.pointsOnRamp90withNumericalRotationError, this.ramp90);
    }

    @Test
    public void testSurfaceNormalForRamp90() {
        this.testSurfaceNormalsForAnyRampFace(this.ramp90, this.expectedSurfaceNormalRamp90, this.pointsOnRamp90);
    }

    @Test
    public void testOtherSurfaceNormalForRamp90() {
        this.testSurfaceNormalsForAnyOtherRampSides(this.ramp90, this.expectedSurfaceNormalOnOtherFacesRamp90, this.pointsOnOtherFacesRamp90);
    }

    private void testHeightAtRampForAnyRamp(Point3D[] pointsOnRamp, RotatableRampTerrainObject ramp) {
        for (int i = 0; i < pointsOnRamp.length; ++i) {
            String message = "Expected Height For point " + pointsOnRamp[i].getX() + " " + pointsOnRamp[i].getY() + " " + pointsOnRamp[i].getZ();
            Assert.assertEquals(message, pointsOnRamp[i].getZ(), ramp.heightAt(pointsOnRamp[i].getX(), pointsOnRamp[i].getY(), pointsOnRamp[i].getZ()), this.epsilon);
        }
    }

    private void testHeightAtRampForAnyRampWithTranslation(Point3D[] pointsOnRamp, RotatableRampTerrainObject ramp, Vector3D translation) {
        for (int i = 0; i < pointsOnRamp.length; ++i) {
            String message = "Expected Height For point " + (pointsOnRamp[i].getX() + translation.getX()) + " " + (pointsOnRamp[i].getY() + translation.getY()) + " " + pointsOnRamp[i].getZ();
            Assert.assertEquals(message, pointsOnRamp[i].getZ(), ramp.heightAt(pointsOnRamp[i].getX() + translation.getX(), pointsOnRamp[i].getY() + translation.getY(), pointsOnRamp[i].getZ()), this.epsilon);
        }
    }

    @Test
    public void testHeightAtTranslation() {
        this.testHeightAtRampForAnyRampWithTranslation(this.pointsOnSimpleRamp, this.simpleRampTranslated, new Vector3D(transX, transY, 0.0));
    }

    @Test
    public void testHeightAt90Translation() {
        this.testHeightAtRampForAnyRampWithTranslation(this.pointsOnRamp90Translated, this.ramp90Translated, new Vector3D(transX, transY, 0.0));
    }

    private void testSurfaceNormalsForAnyRampFace(RotatableRampTerrainObject ramp, Vector3D expectedRampSurfaceNormal, Point3D[] pointsOnRamp) {
        expectedRampSurfaceNormal.normalize();
        for (int i = 0; i < pointsOnRamp.length; ++i) {
            Vector3D normal = new Vector3D();
            ramp.surfaceNormalAt(pointsOnRamp[i].getX(), pointsOnRamp[i].getY(), pointsOnRamp[i].getZ(), (Vector3DBasics)normal);
            String message = "Normal for point " + pointsOnRamp[i].getX() + " " + pointsOnRamp[i].getY() + " " + pointsOnRamp[i].getZ();
            EuclidCoreTestTools.assertTuple3DEquals((String)message, (Tuple3DReadOnly)expectedRampSurfaceNormal, (Tuple3DReadOnly)normal, (double)this.epsilon);
        }
    }

    private void testSurfaceNormalsForAnyOtherRampSides(RotatableRampTerrainObject ramp, Vector3D[] expectedSurfaceNormalOnOtherFaces, Point3D[] pointsOnOtherRampFaces) {
        for (int i = 0; i < pointsOnOtherRampFaces.length; ++i) {
            expectedSurfaceNormalOnOtherFaces[i].normalize();
            Vector3D normal = new Vector3D();
            ramp.surfaceNormalAt(pointsOnOtherRampFaces[i].getX(), pointsOnOtherRampFaces[i].getY(), pointsOnOtherRampFaces[i].getZ(), (Vector3DBasics)normal);
            String message = "Normal for point " + pointsOnOtherRampFaces[i].getX() + " " + pointsOnOtherRampFaces[i].getY() + " " + pointsOnOtherRampFaces[i].getZ();
            EuclidCoreTestTools.assertTuple3DEquals((String)message, (Tuple3DReadOnly)expectedSurfaceNormalOnOtherFaces[i], (Tuple3DReadOnly)normal, (double)this.epsilon);
        }
    }
}

