/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.util.simulationRunner;

import java.util.ArrayList;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.simulationconstructionset.util.simulationRunner.VariableDifference;
import us.ihmc.simulationconstructionset.util.simulationRunner.VariablesThatShouldMatchList;
import us.ihmc.yoVariables.registry.YoNamespace;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.tools.YoFactories;
import us.ihmc.yoVariables.variable.YoDouble;

public class VariablesThatShouldMatchListTest {
    @Test
    public void testOne() {
        YoRegistry registryOne = new YoRegistry("root");
        YoRegistry registryTwo = new YoRegistry("root");
        YoFactories.findOrCreateRegistry((YoRegistry)registryOne, (YoNamespace)new YoNamespace("root.one.two.three.four"));
        YoFactories.findOrCreateRegistry((YoRegistry)registryTwo, (YoNamespace)new YoNamespace("root.one.two.three.four"));
        ArrayList<YoDouble[]> theseShouldMatch = new ArrayList<YoDouble[]>();
        theseShouldMatch.add(this.createAndAddVariable("var1", "root.one.two.three.four", registryOne, registryTwo));
        theseShouldMatch.add(this.createAndAddVariable("var2", "root.one.two.three.four", registryOne, registryTwo));
        theseShouldMatch.add(this.createAndAddVariable("var3", "root.one.two.three", registryOne, registryTwo));
        theseShouldMatch.add(this.createAndAddVariable("var4", "root.one.two", registryOne, registryTwo));
        theseShouldMatch.add(this.createAndAddVariable("var5", "root.one", registryOne, registryTwo));
        theseShouldMatch.add(this.createAndAddVariable("var6", "root", registryOne, registryTwo));
        ArrayList<YoDouble[]> theseDontNeedToMatch = new ArrayList<YoDouble[]>();
        theseDontNeedToMatch.add(this.createAndAddVariable("var1_exception1", "root.one.two.three.four", registryOne, registryTwo));
        theseDontNeedToMatch.add(this.createAndAddVariable("var2_exception2", "root.one.two.three.four", registryOne, registryTwo));
        theseDontNeedToMatch.add(this.createAndAddVariable("exception3", "root.one", registryOne, registryTwo));
        ArrayList<String> exceptions = new ArrayList<String>();
        exceptions.add("exception1");
        exceptions.add("exception2");
        exceptions.add("exception3");
        VariablesThatShouldMatchList variablesThatShouldMatchList = new VariablesThatShouldMatchList(registryOne, registryTwo, exceptions);
        ArrayList variableDifferences = new ArrayList();
        double maxDifferenceAllowed = Double.MIN_VALUE;
        boolean checkForPercentDifference = false;
        boolean doValuesMatch = variablesThatShouldMatchList.doVariableValuesMatch(variableDifferences, 0.0, maxDifferenceAllowed, checkForPercentDifference);
        Assert.assertTrue(doValuesMatch);
        registryOne.findVariable("var1").setValueFromDouble(0.123);
        doValuesMatch = variablesThatShouldMatchList.doVariableValuesMatch(variableDifferences, 0.0, maxDifferenceAllowed, checkForPercentDifference);
        Assert.assertEquals(1L, variableDifferences.size());
        Assert.assertEquals(((VariableDifference)variableDifferences.get(0)).getVariableOne().getName(), "var1");
        Assert.assertFalse(doValuesMatch);
        variableDifferences.clear();
        registryTwo.findVariable("var1").setValueFromDouble(0.123);
        doValuesMatch = variablesThatShouldMatchList.doVariableValuesMatch(variableDifferences, 0.0, maxDifferenceAllowed, checkForPercentDifference);
        Assert.assertTrue(doValuesMatch);
        registryTwo.findVariable("var1_exception1").setValueFromDouble(0.123);
        registryTwo.findVariable("var2_exception2").setValueFromDouble(0.456);
        registryTwo.findVariable("exception3").setValueFromDouble(0.789);
        doValuesMatch = variablesThatShouldMatchList.doVariableValuesMatch(variableDifferences, 0.0, maxDifferenceAllowed, checkForPercentDifference);
        Assert.assertTrue(doValuesMatch);
        registryOne.findVariable("var2").setValueFromDouble(11.23);
        registryTwo.findVariable("var4").setValueFromDouble(14.5);
        registryTwo.findVariable("var6").setValueFromDouble(16.7);
        doValuesMatch = variablesThatShouldMatchList.doVariableValuesMatch(variableDifferences, 0.0, maxDifferenceAllowed, checkForPercentDifference);
        Assert.assertEquals(3L, variableDifferences.size());
        Assert.assertEquals(((VariableDifference)variableDifferences.get(0)).getVariableOne().getName(), "var6");
        Assert.assertEquals(((VariableDifference)variableDifferences.get(1)).getVariableOne().getName(), "var4");
        Assert.assertEquals(((VariableDifference)variableDifferences.get(2)).getVariableOne().getName(), "var2");
        Assert.assertFalse(doValuesMatch);
        variableDifferences.clear();
        registryTwo.findVariable("var2").setValueFromDouble(11.23);
        registryOne.findVariable("var4").setValueFromDouble(14.5);
        registryOne.findVariable("var6").setValueFromDouble(16.7);
        doValuesMatch = variablesThatShouldMatchList.doVariableValuesMatch(variableDifferences, 0.0, maxDifferenceAllowed, checkForPercentDifference);
        Assert.assertEquals(0L, variableDifferences.size());
        Assert.assertTrue(doValuesMatch);
        variableDifferences.clear();
        maxDifferenceAllowed = 0.11;
        checkForPercentDifference = false;
        registryOne.findVariable("var1").setValueFromDouble(111.0);
        registryTwo.findVariable("var1").setValueFromDouble(110.9);
        doValuesMatch = variablesThatShouldMatchList.doVariableValuesMatch(variableDifferences, 0.0, maxDifferenceAllowed, checkForPercentDifference);
        Assert.assertTrue(doValuesMatch);
        maxDifferenceAllowed = 0.099;
        doValuesMatch = variablesThatShouldMatchList.doVariableValuesMatch(variableDifferences, 0.0, maxDifferenceAllowed, checkForPercentDifference);
        Assert.assertFalse(doValuesMatch);
        variableDifferences.clear();
        maxDifferenceAllowed = 0.0099;
        checkForPercentDifference = true;
        registryOne.findVariable("var1").setValueFromDouble(10.0);
        registryTwo.findVariable("var1").setValueFromDouble(10.1);
        doValuesMatch = variablesThatShouldMatchList.doVariableValuesMatch(variableDifferences, 0.0, maxDifferenceAllowed, checkForPercentDifference);
        Assert.assertFalse(doValuesMatch);
        variableDifferences.clear();
        maxDifferenceAllowed = 0.011;
        doValuesMatch = variablesThatShouldMatchList.doVariableValuesMatch(variableDifferences, 0.0, maxDifferenceAllowed, checkForPercentDifference);
        Assert.assertTrue(doValuesMatch);
        variableDifferences.clear();
        YoDouble onlyInOne = new YoDouble("onlyInOne", registryOne);
        YoDouble onlyInTwo = new YoDouble("onlyInTwo", registryTwo);
        variablesThatShouldMatchList = new VariablesThatShouldMatchList(registryOne, registryTwo, exceptions);
        doValuesMatch = variablesThatShouldMatchList.doVariableValuesMatch(variableDifferences, 0.0, maxDifferenceAllowed, checkForPercentDifference);
        Assert.assertFalse(doValuesMatch);
        Assert.assertEquals(2L, variableDifferences.size());
        Assert.assertEquals("onlyInOne", ((VariableDifference)variableDifferences.get(0)).getVariableOne().getName());
        Assert.assertNull(((VariableDifference)variableDifferences.get(0)).getVariableTwo());
        Assert.assertEquals("onlyInTwo", ((VariableDifference)variableDifferences.get(1)).getVariableTwo().getName());
        Assert.assertNull(((VariableDifference)variableDifferences.get(1)).getVariableOne());
    }

    private YoDouble[] createAndAddVariable(String name, String fullNamespace, YoRegistry rootRegistryOne, YoRegistry rootRegistryTwo) {
        YoDouble[] ret = new YoDouble[]{new YoDouble(name, YoFactories.findOrCreateRegistry((YoRegistry)rootRegistryOne, (YoNamespace)new YoNamespace(fullNamespace))), new YoDouble(name, YoFactories.findOrCreateRegistry((YoRegistry)rootRegistryTwo, (YoNamespace)new YoNamespace(fullNamespace)))};
        return ret;
    }
}

