/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.gui;

import java.util.List;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.SimulationConstructionSetParameters;
import us.ihmc.simulationconstructionset.examples.FallingBrickRobot;
import us.ihmc.simulationconstructionset.gui.EntryBoxArrayPanel;
import us.ihmc.simulationconstructionset.gui.StandardSimulationGUI;
import us.ihmc.simulationconstructionset.gui.YoEntryBox;
import us.ihmc.simulationconstructionset.gui.YoEnumEntryContainer;
import us.ihmc.simulationconstructionset.gui.YoTextEntryContainer;
import us.ihmc.simulationconstructionset.util.RobotController;
import us.ihmc.simulationconstructionset.util.simulationRunner.BlockingSimulationRunner;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;

public class YoEntryBoxTest {
    public static final int DELAY_TIME_FOR_HUMAN_CONVENIENT_VIEWING = 360;
    public static final int DELAY_TIME_FOR_TESTING_CONCURRENT_UPDATE = 1000;

    @Disabled
    @Test
    public void testEnumDisplay() throws BlockingSimulationRunner.SimulationExceededMaximumTimeException, InterruptedException {
        SimpleController controller = new SimpleController();
        SimulationConstructionSet scs = this.setupSCS(controller);
        scs.setupEntryBox("largeEnumVariable");
        scs.setupEntryBox("badGreekVariable");
        scs.setupEntryBox("smallEnumVariable");
        Thread.sleep(10000L);
        scs.closeAndDispose();
    }

    @Disabled
    @Test
    public void testSwitchToEnumEntry() throws BlockingSimulationRunner.SimulationExceededMaximumTimeException, InterruptedException {
        YoEntryBox oldNumericVariableBox;
        SimpleController controller = new SimpleController();
        SimulationConstructionSet scs = this.setupSCS(controller);
        StandardSimulationGUI scsGUI = scs.getStandardSimulationGUI();
        Thread.sleep(360L);
        scs.setupEntryBox("t");
        Thread.sleep(360L);
        scs.setupEntryBox("q_x");
        Thread.sleep(360L);
        scs.setupEntryBox("badGreekVariable");
        List entryBoxes = scsGUI.getEntryBoxArrayPanel().getEntryBoxesOnThisPanel();
        YoEnum<BadGreekEnum> badGreekVariable = controller.getBadGreekVariable();
        YoDouble numberVariable = controller.getNumberVariable();
        YoDouble timeVariable = controller.getTimeVariable();
        badGreekVariable.set((Enum)BadGreekEnum.BETA);
        Thread.sleep(360L);
        Assert.assertEquals(timeVariable, ((YoEntryBox)entryBoxes.get(0)).getVariableInThisBox());
        Assert.assertEquals(scs.findVariable("q_x"), ((YoEntryBox)entryBoxes.get(1)).getVariableInThisBox());
        Assert.assertEquals(badGreekVariable, ((YoEntryBox)entryBoxes.get(2)).getVariableInThisBox());
        Assert.assertEquals(YoTextEntryContainer.class, ((YoEntryBox)entryBoxes.get(1)).getActiveYoVariableEntryContainer().getClass());
        Assert.assertEquals(YoEnumEntryContainer.class, ((YoEntryBox)entryBoxes.get(2)).getActiveYoVariableEntryContainer().getClass());
        Thread.sleep(360L);
        YoEntryBox badGreekBox = (YoEntryBox)entryBoxes.get(2);
        badGreekBox.removeVariable(badGreekBox.getVariableInThisBox());
        Thread.sleep(360L);
        Assert.assertEquals(YoTextEntryContainer.class, ((YoEntryBox)entryBoxes.get(2)).getActiveYoVariableEntryContainer().getClass());
        YoEntryBox newBadGreekBox = oldNumericVariableBox = (YoEntryBox)entryBoxes.get(1);
        newBadGreekBox.setVariableInThisBox(badGreekVariable);
        Thread.sleep(360L);
        badGreekVariable.set((Enum)BadGreekEnum.GAMMA);
        Thread.sleep(360L);
        badGreekVariable.set((Enum)BadGreekEnum.ALPHA);
        Thread.sleep(360L);
        Assert.assertEquals(YoEnumEntryContainer.class, newBadGreekBox.getActiveYoVariableEntryContainer().getClass());
        Thread.sleep(1440L);
        scs.closeAndDispose();
    }

    public <T extends RobotControllerWithAttachRobot> SimulationConstructionSet setupSCS(T controller) throws InterruptedException {
        boolean showGUI = true;
        FallingBrickRobot robot = new FallingBrickRobot();
        controller.attachRobot((Robot)robot);
        Assert.assertFalse(controller.getYoRegistry() == null);
        robot.setController(controller);
        SimulationConstructionSetParameters parameters = SimulationConstructionSetParameters.createFromSystemProperties();
        parameters.setCreateGUI(showGUI);
        parameters.setDataBufferSize(2000);
        SimulationConstructionSet scs = new SimulationConstructionSet((Robot)robot, parameters);
        scs.setFrameMaximized();
        scs.startOnAThread();
        Thread.sleep(360L);
        StandardSimulationGUI scsGUI = scs.getStandardSimulationGUI();
        EntryBoxArrayPanel temp = scsGUI.getEntryBoxArrayPanel();
        temp.removeAllEntryBoxes();
        scsGUI.getEntryBoxArrayPanel().updateUI();
        Thread.sleep(360L);
        return scs;
    }

    public static interface RobotControllerWithAttachRobot
    extends RobotController {
        public void attachRobot(Robot var1);
    }

    private class SimpleController
    implements RobotControllerWithAttachRobot {
        private YoRegistry registry;
        private YoEnum<BadGreekEnum> badGreekVariable;
        private YoEnum<LargeEnum> largeEnumVariable;
        private YoEnum<SmallEnum> smallEnumVariable;
        private YoDouble numberVariable;
        private YoDouble time;
        private final String name = "simpleController";

        @Override
        public void attachRobot(Robot robot) {
            this.registry = new YoRegistry("controllerRegistry");
            this.badGreekVariable = new YoEnum("badGreekVariable", this.registry, BadGreekEnum.class);
            this.badGreekVariable.set((Enum)BadGreekEnum.ALPHA);
            this.largeEnumVariable = new YoEnum("largeEnumVariable", this.registry, LargeEnum.class);
            this.largeEnumVariable.set((Enum)LargeEnum.THE_FOLLOWING_IS_TAKEN_FROM_RAIBERT_1986_ONE_PART_OF_THE_CONTROL_SYSTEM_EXCITED_THE_CYCLIC_MOTION_THAT_UNDERLIES_RUNNING_WHILE_REGULATING_THE_HEIGHT_TO_WHICH_THE_MACHINE_HOPPED);
            this.smallEnumVariable = new YoEnum("smallEnumVariable", this.registry, SmallEnum.class);
            this.smallEnumVariable.set((Enum)SmallEnum.IF);
            this.numberVariable = new YoDouble("numberVariable", this.registry);
            this.numberVariable.set(42.0);
            this.time = robot.getYoTime();
        }

        public void initialize() {
        }

        public YoRegistry getYoRegistry() {
            return this.registry;
        }

        public String getName() {
            return "simpleController";
        }

        public String getDescription() {
            return "simpleController";
        }

        public void doControl() {
            switch ((BadGreekEnum)this.badGreekVariable.getEnumValue()) {
                case ALPHA: {
                    break;
                }
                case BETA: {
                    break;
                }
                case GAMMA: {
                    break;
                }
            }
        }

        public YoDouble getTimeVariable() {
            return this.time;
        }

        public YoEnum<BadGreekEnum> getBadGreekVariable() {
            return this.badGreekVariable;
        }

        public YoDouble getNumberVariable() {
            return this.numberVariable;
        }
    }

    public static enum SmallEnum {
        A,
        B,
        C,
        D,
        F,
        G,
        EX,
        NINE,
        IF,
        NOR,
        FINE;

    }

    public static enum LargeEnum {
        THIS_IS_LARGE,
        THIS_IS_LARGER,
        A_LARGER_STILL_ENUMERATION_STRING,
        A_YET_LARGER_AND_STILL_MORE_VERBOSE_DESCRIPTION_OF_AN_ENUMERATION_STATE,
        THE_FOLLOWING_IS_TAKEN_FROM_RAIBERT_1986_ONE_PART_OF_THE_CONTROL_SYSTEM_EXCITED_THE_CYCLIC_MOTION_THAT_UNDERLIES_RUNNING_WHILE_REGULATING_THE_HEIGHT_TO_WHICH_THE_MACHINE_HOPPED;

    }

    public static enum BadGreekEnum {
        ALPHA,
        BETA,
        GAMMA;

    }
}

