/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.physics.featherstone;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.SimulationConstructionSetParameters;
import us.ihmc.simulationconstructionset.physics.featherstone.CartPoleRobot;
import us.ihmc.simulationconstructionset.physics.featherstone.DoublePendulumRobot;
import us.ihmc.simulationconstructionset.physics.featherstone.RobotWithClosedFormDynamics;
import us.ihmc.simulationconstructionset.physics.featherstone.SinglePendulumRobot;
import us.ihmc.simulationconstructionset.physics.featherstone.UniversalJointRobot;
import us.ihmc.simulationconstructionset.util.RobotController;
import us.ihmc.simulationconstructionset.util.simulationRunner.BlockingSimulationRunner;
import us.ihmc.simulationconstructionset.util.simulationTesting.SimulationTestingParameters;
import us.ihmc.tools.MemoryTools;
import us.ihmc.yoVariables.registry.YoRegistry;

public class FeatherstoneAlgorithmTest {
    private final SimulationTestingParameters simulationTestingParameters = SimulationTestingParameters.createFromSystemProperties();

    @BeforeEach
    public void setup() {
        MemoryTools.printCurrentMemoryUsageAndReturnUsedMemoryInMB((String)(this.getClass().getSimpleName() + " before test."));
    }

    @AfterEach
    public void tearDown() {
        MemoryTools.printCurrentMemoryUsageAndReturnUsedMemoryInMB((String)(this.getClass().getSimpleName() + " after test."));
    }

    @Test
    public void testSinglePendulumAgainstLagrangianCalculation() {
        double epsilon = 1.0E-7;
        SinglePendulumRobot pendulumRobot = new SinglePendulumRobot("pendulum", 1.2, -0.4);
        this.testAgainstLagrangianCalculation(pendulumRobot, epsilon);
    }

    @Test
    public void testDoublePendulumAgainstLagrangianCalculation() {
        double epsilon = 1.0E-6;
        DoublePendulumRobot pendulumRobot = new DoublePendulumRobot("doublePendulum", 1.2, -0.4, -0.2, 0.5);
        this.testAgainstLagrangianCalculation(pendulumRobot, epsilon);
    }

    @Disabled
    @Test
    public void testCartPoleAgainstLagrangianCalculation() {
        double epsilon = 0.01;
        CartPoleRobot cartPoleRobot = new CartPoleRobot("cartPole", 0.3, -1.3, 0.4);
        this.testAgainstLagrangianCalculation(cartPoleRobot, epsilon);
    }

    @Disabled
    @Test
    public void testUniversalJointAgainLagrangianCalculation() {
        double epsilon = 1.0E-4;
        UniversalJointRobot universalJointRobot = new UniversalJointRobot("universalJoint", 0.4, -0.2, -0.4, 0.3);
        this.testAgainstLagrangianCalculation(universalJointRobot, epsilon);
    }

    private void testAgainstLagrangianCalculation(RobotWithClosedFormDynamics robotWithClosedFormDynamics, double epsilon) {
        robotWithClosedFormDynamics.setController(new DynamicsChecker(robotWithClosedFormDynamics, epsilon));
        SimulationConstructionSet scs = new SimulationConstructionSet((Robot)robotWithClosedFormDynamics, (SimulationConstructionSetParameters)this.simulationTestingParameters);
        scs.setDT(1.0E-5, 20);
        scs.startOnAThread();
        BlockingSimulationRunner blockingSimulationRunner = new BlockingSimulationRunner(scs, 45.0);
        try {
            blockingSimulationRunner.simulateAndBlock(15.0);
        }
        catch (Exception e) {
            Assert.fail();
        }
        scs.closeAndDispose();
    }

    private class DynamicsChecker
    implements RobotController {
        private final YoRegistry registry;
        private final RobotWithClosedFormDynamics robotWithClosedFormDynamics;
        private final double epsilon;
        private int numberOfTicksToWait = 2;

        public DynamicsChecker(RobotWithClosedFormDynamics robotWithClosedFormDynamics, double epsilon) {
            this.registry = new YoRegistry(robotWithClosedFormDynamics.getName() + "Registry");
            this.robotWithClosedFormDynamics = robotWithClosedFormDynamics;
            this.epsilon = epsilon;
        }

        public void initialize() {
        }

        public YoRegistry getYoRegistry() {
            return this.registry;
        }

        public String getName() {
            return this.robotWithClosedFormDynamics.getName();
        }

        public String getDescription() {
            return this.getName();
        }

        public void doControl() {
            if (this.numberOfTicksToWait == 0) {
                this.robotWithClosedFormDynamics.assertStateIsCloseToClosedFormCalculation(this.epsilon);
            } else {
                --this.numberOfTicksToWait;
            }
        }
    }
}

