/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.shapes;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.scs2.simulation.shapes.STPShape3DTools;

public class STPShape3DToolsTest {
    private static final int ITERATIONS = 1000;

    @Test
    public void testArePoint3DsSameSideOfPlane3D() {
        Point3D secondQuery;
        Point3D firstQuery;
        double sign;
        Point3D secondPointOnPlane;
        Vector3D secondPlaneTangent;
        Vector3D firstPlaneTangent;
        Vector3D planeNormal;
        Point3D firstPointOnPlane;
        int i;
        Random random = new Random(435234657L);
        for (i = 0; i < 1000; ++i) {
            firstPointOnPlane = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            planeNormal = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            firstPlaneTangent = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)planeNormal, (boolean)true);
            secondPlaneTangent = new Vector3D();
            secondPlaneTangent.cross((Tuple3DReadOnly)planeNormal, (Tuple3DReadOnly)firstPlaneTangent);
            secondPointOnPlane = EuclidGeometryTools.orthogonalProjectionOnPlane3D((Point3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0), (Point3DReadOnly)firstPointOnPlane, (Vector3DReadOnly)planeNormal);
            sign = random.nextBoolean() ? -1.0 : 1.0;
            firstQuery = new Point3D((Tuple3DReadOnly)firstPointOnPlane);
            firstQuery.scaleAdd(sign * EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple3DReadOnly)planeNormal, (Tuple3DReadOnly)firstQuery);
            firstQuery.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)firstPlaneTangent, (Tuple3DReadOnly)firstQuery);
            firstQuery.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)secondPlaneTangent, (Tuple3DReadOnly)firstQuery);
            secondQuery = new Point3D((Tuple3DReadOnly)firstPointOnPlane);
            secondQuery.scaleAdd(sign * EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple3DReadOnly)planeNormal, (Tuple3DReadOnly)secondQuery);
            secondQuery.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)firstPlaneTangent, (Tuple3DReadOnly)secondQuery);
            secondQuery.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)secondPlaneTangent, (Tuple3DReadOnly)secondQuery);
            Assertions.assertTrue((boolean)STPShape3DTools.arePoint3DsSameSideOfPlane3D((Point3DReadOnly)firstQuery, (Point3DReadOnly)secondQuery, (Point3DReadOnly)firstPointOnPlane, (Point3DReadOnly)secondPointOnPlane, (Vector3DReadOnly)firstPlaneTangent));
        }
        for (i = 0; i < 1000; ++i) {
            firstPointOnPlane = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            planeNormal = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            firstPlaneTangent = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)planeNormal, (boolean)true);
            secondPlaneTangent = new Vector3D();
            secondPlaneTangent.cross((Tuple3DReadOnly)planeNormal, (Tuple3DReadOnly)firstPlaneTangent);
            secondPointOnPlane = EuclidGeometryTools.orthogonalProjectionOnPlane3D((Point3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0), (Point3DReadOnly)firstPointOnPlane, (Vector3DReadOnly)planeNormal);
            sign = random.nextBoolean() ? -1.0 : 1.0;
            firstQuery = new Point3D((Tuple3DReadOnly)firstPointOnPlane);
            firstQuery.scaleAdd(sign * EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple3DReadOnly)planeNormal, (Tuple3DReadOnly)firstQuery);
            firstQuery.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)firstPlaneTangent, (Tuple3DReadOnly)firstQuery);
            firstQuery.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)secondPlaneTangent, (Tuple3DReadOnly)firstQuery);
            secondQuery = new Point3D((Tuple3DReadOnly)firstPointOnPlane);
            secondQuery.scaleAdd(-sign * EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple3DReadOnly)planeNormal, (Tuple3DReadOnly)secondQuery);
            secondQuery.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)firstPlaneTangent, (Tuple3DReadOnly)secondQuery);
            secondQuery.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)secondPlaneTangent, (Tuple3DReadOnly)secondQuery);
            Assertions.assertFalse((boolean)STPShape3DTools.arePoint3DsSameSideOfPlane3D((Point3DReadOnly)firstQuery, (Point3DReadOnly)secondQuery, (Point3DReadOnly)firstPointOnPlane, (Point3DReadOnly)secondPointOnPlane, (Vector3DReadOnly)firstPlaneTangent));
        }
    }
}

