/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sharedMemory;

import us.ihmc.scs2.sharedMemory.BufferSample;
import us.ihmc.scs2.sharedMemory.LinkedYoInteger;
import us.ihmc.scs2.sharedMemory.YoVariableBuffer;
import us.ihmc.scs2.sharedMemory.interfaces.YoBufferPropertiesReadOnly;
import us.ihmc.scs2.sharedMemory.tools.SharedMemoryTools;
import us.ihmc.yoVariables.variable.YoInteger;

public class YoIntegerBuffer
extends YoVariableBuffer<YoInteger> {
    private int[] buffer;

    public YoIntegerBuffer(YoInteger yoInteger, YoBufferPropertiesReadOnly properties) {
        super(yoInteger, properties);
        this.buffer = new int[properties.getSize()];
    }

    @Override
    public void resizeBuffer(int from, int length) {
        if (from == 0 && length == this.buffer.length) {
            return;
        }
        this.buffer = SharedMemoryTools.ringArrayCopy(this.buffer, from, length);
    }

    @Override
    public void writeBufferAt(int index) {
        this.buffer[index] = ((YoInteger)this.yoVariable).getValue();
    }

    @Override
    public void readBufferAt(int index) {
        ((YoInteger)this.yoVariable).set(this.buffer[index]);
    }

    @Override
    long getValueAsLongBits(int index) {
        return this.buffer[index];
    }

    @Override
    public BufferSample<int[]> copy(int from, int length, YoBufferPropertiesReadOnly properties) {
        return new BufferSample<int[]>(from, SharedMemoryTools.ringArrayCopy(this.buffer, from, length), length, properties);
    }

    @Override
    public void fillBuffer(boolean zeroFill, int from, int length) {
        SharedMemoryTools.ringArrayFill(this.buffer, zeroFill ? 0 : ((YoInteger)this.yoVariable).getValue(), from, length);
    }

    LinkedYoInteger newLinkedYoVariable(YoInteger variableToLink) {
        return new LinkedYoInteger(variableToLink, this);
    }

    public int[] getBuffer() {
        return this.buffer;
    }

    @Override
    public double[] getAsDoubleBuffer() {
        return SharedMemoryTools.toDoubleArray(this.buffer);
    }

    @Override
    public void dispose() {
        this.buffer = null;
    }
}

