/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sharedMemory.tools;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoseUsingYawPitchRoll;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameYawPitchRoll;
import us.ihmc.yoVariables.registry.YoNamespace;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;
import us.ihmc.yoVariables.variable.YoVariable;

public class SharedMemoryTools {
    public static <T> T[] concatenate(T[] ... arrays) {
        if (arrays == null || arrays.length == 0) {
            return null;
        }
        int length = 0;
        for (T[] array : arrays) {
            length += array.length;
        }
        Object[] result = (Object[])Array.newInstance(arrays[0].getClass().getComponentType(), length);
        int index = 0;
        T[][] TArray = arrays;
        int n = TArray.length;
        for (int i = 0; i < n; ++i) {
            T[] array;
            for (T element : array = TArray[i]) {
                result[index++] = element;
            }
        }
        return result;
    }

    public static int increment(int index, int stepSize, int size) {
        if ((index += stepSize) >= size) {
            index -= size;
        }
        return index;
    }

    public static int decrement(int index, int stepSize, int size) {
        if ((index -= stepSize) < 0) {
            index += size;
        }
        return index;
    }

    public static int computeSubLength(int from, int to, int length) {
        if (length <= 0) {
            throw new IllegalArgumentException("length must be greater than zero, was: " + length);
        }
        if (from < 0 || from >= length) {
            throw new IndexOutOfBoundsException("from is out-of-bound, should be in [0, " + length + "[, but was: " + from);
        }
        if (to < 0 || to >= length) {
            throw new IndexOutOfBoundsException("to is out-of-bound, should be in [0, " + length + "[, but was: " + to);
        }
        int subLength = to - from + 1;
        if (subLength <= 0) {
            subLength += length;
        }
        return subLength;
    }

    public static int computeFromIndex(int to, int subLength, int length) {
        if (length <= 0) {
            throw new IllegalArgumentException("length must be greater than zero, was: " + length);
        }
        if (subLength <= 0) {
            throw new IllegalArgumentException("sub-length must be greater than zero, was: " + subLength);
        }
        if (subLength > length) {
            throw new IllegalArgumentException("sub-length must be smaller than length, was: " + subLength + ", length was " + length);
        }
        if (to < 0 || to >= length) {
            throw new IndexOutOfBoundsException("to is out-of-bound, should be in [0, " + length + "[, but was: " + to);
        }
        int from = to - subLength + 1;
        if (from < 0) {
            from += length;
        }
        return from;
    }

    public static int computeToIndex(int from, int subLength, int length) {
        if (length <= 0) {
            throw new IllegalArgumentException("length must be greater than zero, was: " + length);
        }
        if (subLength <= 0) {
            throw new IllegalArgumentException("sub-length must be greater than zero, was: " + subLength);
        }
        if (subLength > length) {
            throw new IllegalArgumentException("sub-length must be smaller than length, was: " + subLength + ", length was " + length);
        }
        if (from < 0 || from >= length) {
            throw new IndexOutOfBoundsException("from is out-of-bound, should be in [0, " + length + "[, but was: " + from);
        }
        int to = from + subLength - 1;
        if (to >= length) {
            to -= length;
        }
        return to;
    }

    public static boolean isInsideBounds(int query, int start, int end, int size) {
        if (query < 0 || query >= size) {
            return false;
        }
        if (start <= end) {
            return query >= start && query <= end;
        }
        return query <= end || query >= start;
    }

    public static boolean[] ringArrayCopy(boolean[] ringArray, int from, int newLength) {
        boolean[] bufferCopy;
        int length = Math.min(newLength, ringArray.length);
        if (from + length <= ringArray.length) {
            bufferCopy = Arrays.copyOfRange(ringArray, from, from + newLength);
        } else {
            int lengthOfFirstCopy = ringArray.length - from;
            bufferCopy = new boolean[newLength];
            System.arraycopy(ringArray, from, bufferCopy, 0, lengthOfFirstCopy);
            System.arraycopy(ringArray, 0, bufferCopy, lengthOfFirstCopy, length - lengthOfFirstCopy);
        }
        return bufferCopy;
    }

    public static double[] ringArrayCopy(double[] ringArray, int from, int newLength) {
        double[] bufferCopy;
        int length = Math.min(newLength, ringArray.length);
        if (from + length <= ringArray.length) {
            bufferCopy = Arrays.copyOfRange(ringArray, from, from + newLength);
        } else {
            int lengthOfFirstCopy = ringArray.length - from;
            bufferCopy = new double[newLength];
            System.arraycopy(ringArray, from, bufferCopy, 0, lengthOfFirstCopy);
            System.arraycopy(ringArray, 0, bufferCopy, lengthOfFirstCopy, length - lengthOfFirstCopy);
        }
        return bufferCopy;
    }

    public static int[] ringArrayCopy(int[] ringArray, int from, int newLength) {
        int[] bufferCopy;
        int length = Math.min(newLength, ringArray.length);
        if (from + length <= ringArray.length) {
            bufferCopy = Arrays.copyOfRange(ringArray, from, from + newLength);
        } else {
            int lengthOfFirstCopy = ringArray.length - from;
            bufferCopy = new int[newLength];
            System.arraycopy(ringArray, from, bufferCopy, 0, lengthOfFirstCopy);
            System.arraycopy(ringArray, 0, bufferCopy, lengthOfFirstCopy, length - lengthOfFirstCopy);
        }
        return bufferCopy;
    }

    public static long[] ringArrayCopy(long[] ringArray, int from, int newLength) {
        long[] bufferCopy;
        int length = Math.min(newLength, ringArray.length);
        if (from + length <= ringArray.length) {
            bufferCopy = Arrays.copyOfRange(ringArray, from, from + newLength);
        } else {
            int lengthOfFirstCopy = ringArray.length - from;
            bufferCopy = new long[newLength];
            System.arraycopy(ringArray, from, bufferCopy, 0, lengthOfFirstCopy);
            System.arraycopy(ringArray, 0, bufferCopy, lengthOfFirstCopy, length - lengthOfFirstCopy);
        }
        return bufferCopy;
    }

    public static byte[] ringArrayCopy(byte[] ringArray, int from, int newLength) {
        byte[] bufferCopy;
        int length = Math.min(newLength, ringArray.length);
        if (from + length <= ringArray.length) {
            bufferCopy = Arrays.copyOfRange(ringArray, from, from + newLength);
        } else {
            int lengthOfFirstCopy = ringArray.length - from;
            bufferCopy = new byte[newLength];
            System.arraycopy(ringArray, from, bufferCopy, 0, lengthOfFirstCopy);
            System.arraycopy(ringArray, 0, bufferCopy, lengthOfFirstCopy, length - lengthOfFirstCopy);
        }
        return bufferCopy;
    }

    public static void ringArrayFill(boolean[] ringArray, boolean fillValue, int from, int length) {
        if (from + (length = Math.min(length, ringArray.length)) <= ringArray.length) {
            Arrays.fill(ringArray, from, from + length, fillValue);
        } else {
            Arrays.fill(ringArray, from, ringArray.length, fillValue);
            Arrays.fill(ringArray, 0, from + length - ringArray.length, fillValue);
        }
    }

    public static void ringArrayFill(double[] ringArray, double fillValue, int from, int length) {
        if (from + (length = Math.min(length, ringArray.length)) <= ringArray.length) {
            Arrays.fill(ringArray, from, from + length, fillValue);
        } else {
            Arrays.fill(ringArray, from, ringArray.length, fillValue);
            Arrays.fill(ringArray, 0, from + length - ringArray.length, fillValue);
        }
    }

    public static void ringArrayFill(int[] ringArray, int fillValue, int from, int length) {
        if (from + (length = Math.min(length, ringArray.length)) <= ringArray.length) {
            Arrays.fill(ringArray, from, from + length, fillValue);
        } else {
            Arrays.fill(ringArray, from, ringArray.length, fillValue);
            Arrays.fill(ringArray, 0, from + length - ringArray.length, fillValue);
        }
    }

    public static void ringArrayFill(long[] ringArray, long fillValue, int from, int length) {
        if (from + (length = Math.min(length, ringArray.length)) <= ringArray.length) {
            Arrays.fill(ringArray, from, from + length, fillValue);
        } else {
            Arrays.fill(ringArray, from, ringArray.length, fillValue);
            Arrays.fill(ringArray, 0, from + length - ringArray.length, fillValue);
        }
    }

    public static void ringArrayFill(byte[] ringArray, byte fillValue, int from, int length) {
        if (from + (length = Math.min(length, ringArray.length)) <= ringArray.length) {
            Arrays.fill(ringArray, from, from + length, fillValue);
        } else {
            Arrays.fill(ringArray, from, ringArray.length, fillValue);
            Arrays.fill(ringArray, 0, from + length - ringArray.length, fillValue);
        }
    }

    public static double[] toDoubleArray(boolean[] array) {
        if (array == null) {
            return null;
        }
        double[] doubleArray = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            doubleArray[i] = array[i] ? 1.0 : 0.0;
        }
        return doubleArray;
    }

    public static double[] toDoubleArray(int[] array) {
        if (array == null) {
            return null;
        }
        double[] doubleArray = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            doubleArray[i] = array[i];
        }
        return doubleArray;
    }

    public static double[] toDoubleArray(long[] array) {
        if (array == null) {
            return null;
        }
        double[] doubleArray = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            doubleArray[i] = array[i];
        }
        return doubleArray;
    }

    public static double[] toDoubleArray(byte[] array) {
        if (array == null) {
            return null;
        }
        double[] doubleArray = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            doubleArray[i] = array[i];
        }
        return doubleArray;
    }

    public static YoRegistry newEmptyCloneRegistry(YoRegistry original) {
        YoRegistry clone = new YoRegistry(original.getName());
        YoRegistry currentClone = clone;
        for (YoRegistry originalParent = original.getParent(); originalParent != null; originalParent = originalParent.getParent()) {
            YoRegistry parentClone = new YoRegistry(originalParent.getName());
            parentClone.addChild(currentClone);
            currentClone = parentClone;
        }
        return clone;
    }

    public static YoRegistry newRegistryFromNamespace(String ... namespace) {
        return SharedMemoryTools.newRegistryFromNamespace(new YoNamespace(Arrays.asList(namespace)));
    }

    public static YoRegistry newRegistryFromNamespace(YoNamespace namespace) {
        YoRegistry registry = null;
        for (String subName : namespace.getSubNames()) {
            YoRegistry child = new YoRegistry(subName);
            if (registry != null) {
                registry.addChild(child);
            }
            registry = child;
        }
        return registry;
    }

    public static int duplicateMissingYoVariablesInTarget(YoRegistry original, YoRegistry target) {
        return SharedMemoryTools.duplicateMissingYoVariablesInTarget(original, target, yoVariable -> {});
    }

    public static int duplicateMissingYoVariablesInTarget(YoRegistry original, YoRegistry target, Consumer<YoVariable> newYoVariableConsumer) {
        int numberOfYoVariablesCreated = 0;
        Set targetVariableNames = target.getVariables().stream().map(YoVariable::getName).collect(Collectors.toSet());
        for (YoVariable originalVariable : original.getVariables()) {
            YoVariable newYoVariable;
            if (targetVariableNames.contains(originalVariable.getName())) continue;
            if (originalVariable instanceof YoEnum && !((YoEnum)originalVariable).isBackedByEnum()) {
                YoEnum originalEnum = (YoEnum)originalVariable;
                newYoVariable = new YoEnum(originalEnum.getName(), originalEnum.getDescription(), target, originalEnum.isNullAllowed(), originalEnum.getEnumValuesAsString());
            } else {
                newYoVariable = originalVariable.duplicate(target);
            }
            newYoVariableConsumer.accept(newYoVariable);
            ++numberOfYoVariablesCreated;
        }
        Map targetChildren = target.getChildren().stream().collect(Collectors.toMap(reg -> reg.getName(), Function.identity()));
        for (YoRegistry originalChild : original.getChildren()) {
            String childName = originalChild.getName();
            YoRegistry targetChild = (YoRegistry)targetChildren.get(childName);
            if (targetChild == null) {
                targetChild = new YoRegistry(childName);
                target.addChild(targetChild);
            }
            numberOfYoVariablesCreated += SharedMemoryTools.duplicateMissingYoVariablesInTarget(originalChild, targetChild, newYoVariableConsumer);
        }
        return numberOfYoVariablesCreated;
    }

    public static YoRegistry ensurePathExists(YoRegistry rootRegistry, YoNamespace registryNamespace) {
        if (rootRegistry == null) {
            rootRegistry = new YoRegistry(registryNamespace.getRootName());
        } else {
            if (!registryNamespace.startsWith(rootRegistry.getNamespace())) {
                return null;
            }
            if (registryNamespace.equals((Object)rootRegistry.getNamespace())) {
                return rootRegistry;
            }
        }
        List subNames = registryNamespace.removeStart(rootRegistry.getNamespace()).getSubNames();
        YoRegistry currentRegistry = rootRegistry;
        for (String subName : subNames) {
            YoRegistry childRegistry = currentRegistry.getChildren().stream().filter(r -> r.getName().equals(subName)).findFirst().orElse(null);
            if (childRegistry == null) {
                childRegistry = new YoRegistry(subName);
                currentRegistry.addChild(childRegistry);
            }
            currentRegistry = childRegistry;
        }
        return currentRegistry;
    }

    public static YoFramePoint2D duplicate(YoFramePoint2D original, YoRegistry newRegistry, ReferenceFrame newReferenceFrame) {
        YoDouble x = (YoDouble)newRegistry.findVariable(original.getYoX().getFullNameString());
        YoDouble y = (YoDouble)newRegistry.findVariable(original.getYoY().getFullNameString());
        return new YoFramePoint2D(x, y, newReferenceFrame);
    }

    public static YoFrameVector2D duplicate(YoFrameVector2D original, YoRegistry newRegistry, ReferenceFrame newReferenceFrame) {
        YoDouble x = (YoDouble)newRegistry.findVariable(original.getYoX().getFullNameString());
        YoDouble y = (YoDouble)newRegistry.findVariable(original.getYoY().getFullNameString());
        return new YoFrameVector2D(x, y, newReferenceFrame);
    }

    public static YoFramePoint3D duplicate(YoFramePoint3D original, YoRegistry newRegistry, ReferenceFrame newReferenceFrame) {
        YoDouble x = (YoDouble)newRegistry.findVariable(original.getYoX().getFullNameString());
        YoDouble y = (YoDouble)newRegistry.findVariable(original.getYoY().getFullNameString());
        YoDouble z = (YoDouble)newRegistry.findVariable(original.getYoZ().getFullNameString());
        return new YoFramePoint3D(x, y, z, newReferenceFrame);
    }

    public static YoFrameVector3D duplicate(YoFrameVector3D original, YoRegistry newRegistry, ReferenceFrame newReferenceFrame) {
        YoDouble x = (YoDouble)newRegistry.findVariable(original.getYoX().getFullNameString());
        YoDouble y = (YoDouble)newRegistry.findVariable(original.getYoY().getFullNameString());
        YoDouble z = (YoDouble)newRegistry.findVariable(original.getYoZ().getFullNameString());
        return new YoFrameVector3D(x, y, z, newReferenceFrame);
    }

    public static YoFrameYawPitchRoll duplicate(YoFrameYawPitchRoll original, YoRegistry newRegistry, ReferenceFrame newReferenceFrame) {
        YoDouble y = (YoDouble)newRegistry.findVariable(original.getYoYaw().getFullNameString());
        YoDouble p = (YoDouble)newRegistry.findVariable(original.getYoPitch().getFullNameString());
        YoDouble r = (YoDouble)newRegistry.findVariable(original.getYoRoll().getFullNameString());
        return new YoFrameYawPitchRoll(y, p, r, newReferenceFrame);
    }

    public static YoFramePoseUsingYawPitchRoll duplicate(YoFramePoseUsingYawPitchRoll original, YoRegistry newRegistry, ReferenceFrame newReferenceFrame) {
        return new YoFramePoseUsingYawPitchRoll(SharedMemoryTools.duplicate(original.getPosition(), newRegistry, newReferenceFrame), SharedMemoryTools.duplicate(original.getYawPitchRoll(), newRegistry, newReferenceFrame));
    }
}

