/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sharedMemory;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import us.ihmc.scs2.sharedMemory.BufferSample;
import us.ihmc.scs2.sharedMemory.BufferSampleRequest;
import us.ihmc.scs2.sharedMemory.LinkedBuffer;
import us.ihmc.scs2.sharedMemory.LinkedYoBoolean;
import us.ihmc.scs2.sharedMemory.LinkedYoDouble;
import us.ihmc.scs2.sharedMemory.LinkedYoEnum;
import us.ihmc.scs2.sharedMemory.LinkedYoInteger;
import us.ihmc.scs2.sharedMemory.LinkedYoLong;
import us.ihmc.scs2.sharedMemory.PullRequest;
import us.ihmc.scs2.sharedMemory.PushRequest;
import us.ihmc.scs2.sharedMemory.YoBooleanBuffer;
import us.ihmc.scs2.sharedMemory.YoDoubleBuffer;
import us.ihmc.scs2.sharedMemory.YoEnumBuffer;
import us.ihmc.scs2.sharedMemory.YoIntegerBuffer;
import us.ihmc.scs2.sharedMemory.YoLongBuffer;
import us.ihmc.scs2.sharedMemory.YoVariableBuffer;
import us.ihmc.scs2.sharedMemory.interfaces.YoBufferPropertiesReadOnly;
import us.ihmc.scs2.sharedMemory.tools.SharedMemoryTools;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;
import us.ihmc.yoVariables.variable.YoInteger;
import us.ihmc.yoVariables.variable.YoLong;
import us.ihmc.yoVariables.variable.YoVariable;

public abstract class LinkedYoVariable<T extends YoVariable>
extends LinkedBuffer {
    protected final T linkedYoVariable;
    protected final YoVariableBuffer<T> buffer;
    protected PushRequest<T> pushRequestToProcess;
    protected PullRequest<T> pullRequest;
    protected BufferSampleRequest bufferSampleRequest;
    protected BufferSample bufferSample;
    private final List<LinkedBuffer.PushRequestListener> pushRequestListeners = new ArrayList<LinkedBuffer.PushRequestListener>();
    private final Set<Object> users = new HashSet<Object>();
    private boolean isDisposed = false;

    static LinkedYoVariable newLinkedYoVariable(YoVariable yoVariableToLink, YoVariableBuffer<?> buffer) {
        if (yoVariableToLink instanceof YoBoolean) {
            return new LinkedYoBoolean((YoBoolean)yoVariableToLink, (YoBooleanBuffer)buffer);
        }
        if (yoVariableToLink instanceof YoDouble) {
            return new LinkedYoDouble((YoDouble)yoVariableToLink, (YoDoubleBuffer)buffer);
        }
        if (yoVariableToLink instanceof YoInteger) {
            return new LinkedYoInteger((YoInteger)yoVariableToLink, (YoIntegerBuffer)buffer);
        }
        if (yoVariableToLink instanceof YoLong) {
            return new LinkedYoLong((YoLong)yoVariableToLink, (YoLongBuffer)buffer);
        }
        if (yoVariableToLink instanceof YoEnum) {
            return new LinkedYoEnum((YoEnum)yoVariableToLink, (YoEnumBuffer)buffer);
        }
        throw new UnsupportedOperationException("Unsupported YoVariable type: " + yoVariableToLink.getClass().getSimpleName());
    }

    LinkedYoVariable(T yoVariable, YoVariableBuffer<T> buffer) {
        Objects.requireNonNull(buffer, "Cannot create a linked YoVariable without a buffer.");
        this.linkedYoVariable = yoVariable;
        this.buffer = buffer;
    }

    public void requestEntireBuffer() {
        this.requestBufferWindow(-1, -1);
    }

    public void requestActiveBufferOnly() {
        this.requestBufferWindow(-1, -2);
    }

    public void requestBufferStartingFrom(int from) {
        this.requestBufferWindow(from, -1);
    }

    public void requestBufferWindow(int from, int length) {
        if (this.isDisposed) {
            return;
        }
        this.bufferSampleRequest = new BufferSampleRequest(from, length);
    }

    @Override
    void addPushRequestListener(LinkedBuffer.PushRequestListener listener) {
        if (this.isDisposed) {
            return;
        }
        this.pushRequestListeners.add(listener);
    }

    @Override
    boolean removePushRequestListener(LinkedBuffer.PushRequestListener listener) {
        return this.pushRequestListeners.remove(listener);
    }

    @Override
    public void push() {
        if (this.isDisposed) {
            return;
        }
        this.pushRequestToProcess = this.toPushRequest();
        this.pushRequestListeners.forEach(listener -> listener.pushRequested(this));
    }

    @Override
    boolean processPush(boolean writeBuffer) {
        if (this.isDisposed || this.pushRequestToProcess == null) {
            return false;
        }
        PushRequest<T> push = this.pushRequestToProcess;
        this.pushRequestToProcess = null;
        boolean modified = push.push();
        if (modified && writeBuffer) {
            this.buffer.writeBuffer();
        }
        return modified;
    }

    @Override
    void flushPush() {
        this.pushRequestToProcess = null;
    }

    @Override
    void prepareForPull() {
        if (this.isDisposed) {
            return;
        }
        this.pullRequest = this.toPullRequest();
        this.consumeBufferSampleRequest();
    }

    private void consumeBufferSampleRequest() {
        YoBufferPropertiesReadOnly properties;
        if (this.isDisposed || this.bufferSampleRequest == null) {
            return;
        }
        BufferSampleRequest localRequest = this.bufferSampleRequest;
        this.bufferSampleRequest = null;
        int from = localRequest.getFrom();
        int length = localRequest.getLength();
        if (length > (properties = this.buffer.getProperties()).getSize()) {
            return;
        }
        if (from >= properties.getSize()) {
            return;
        }
        if (length == -1) {
            if (from == -1) {
                from = 0;
                length = properties.getSize();
            } else if (from >= 0) {
                length = SharedMemoryTools.computeSubLength(from, properties.getOutPoint(), properties.getSize());
            }
        } else if (length == -2 && from == -1) {
            from = properties.getInPoint();
            length = properties.getActiveBufferLength();
        }
        if (length == 0) {
            return;
        }
        if (from < 0 || from >= properties.getSize() || length < 0 || length > properties.getSize()) {
            throw new IllegalArgumentException("Invalid request: from = " + from + ", length = " + length);
        }
        this.bufferSample = this.buffer.copy(from, length, properties.copy());
    }

    @Override
    public boolean pull() {
        if (this.isDisposed) {
            return false;
        }
        PullRequest<T> pull = this.pullRequest;
        this.pullRequest = null;
        if (pull != null) {
            pull.pull();
        }
        return pull != null;
    }

    @Override
    public boolean hasRequestPending() {
        return this.bufferSampleRequest != null;
    }

    public boolean isRequestedBufferSampleAvailable() {
        return this.bufferSample != null;
    }

    public BufferSample pollRequestedBufferSample() {
        if (this.isDisposed) {
            return null;
        }
        BufferSample localSample = this.bufferSample;
        this.bufferSample = null;
        return localSample;
    }

    abstract PullRequest<T> toPullRequest();

    abstract PushRequest<T> toPushRequest();

    public T getLinkedYoVariable() {
        return this.linkedYoVariable;
    }

    YoVariableBuffer<T> getBuffer() {
        return this.buffer;
    }

    public void addUser(Object user) {
        this.users.add(user);
    }

    public boolean removeUser(Object user) {
        return this.users.remove(user);
    }

    @Override
    public boolean isActive() {
        return !this.isDisposed && !this.users.isEmpty();
    }

    @Override
    public void dispose() {
        if (this.isDisposed) {
            return;
        }
        this.isDisposed = true;
        this.pushRequestToProcess = null;
        this.pullRequest = null;
        this.bufferSampleRequest = null;
        this.bufferSample = null;
        this.pushRequestListeners.clear();
        this.users.clear();
    }
}

