/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sharedMemory;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.scs2.sharedMemory.BufferSample;
import us.ihmc.scs2.sharedMemory.LinkedYoBoolean;
import us.ihmc.scs2.sharedMemory.YoBooleanBuffer;
import us.ihmc.scs2.sharedMemory.YoBufferProperties;
import us.ihmc.scs2.sharedMemory.YoVariableBuffer;
import us.ihmc.scs2.sharedMemory.interfaces.YoBufferPropertiesReadOnly;
import us.ihmc.scs2.sharedMemory.tools.SharedMemoryRandomTools;
import us.ihmc.scs2.sharedMemory.tools.SharedMemoryTools;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoBooleanBufferTest {
    private static final int ITERATIONS = 1000;

    @Test
    public void testConstructors() {
        int j;
        YoBufferProperties yoBufferProperties;
        YoBooleanBuffer yoBooleanBuffer;
        YoBoolean yoBoolean;
        int i;
        Random random = new Random(467L);
        for (i = 0; i < 1000; ++i) {
            yoBoolean = SharedMemoryRandomTools.nextYoBoolean((Random)random, (YoRegistry)new YoRegistry("Dummy"));
            Assertions.assertTrue((yoBoolean == (yoBooleanBuffer = new YoBooleanBuffer(yoBoolean, (YoBufferPropertiesReadOnly)(yoBufferProperties = SharedMemoryRandomTools.nextYoBufferProperties((Random)random)))).getYoVariable() ? 1 : 0) != 0);
            Assertions.assertTrue((yoBufferProperties == yoBooleanBuffer.getProperties() ? 1 : 0) != 0);
            Assertions.assertEquals((int)yoBufferProperties.getSize(), (int)yoBooleanBuffer.getBuffer().length);
            for (j = 0; j < yoBufferProperties.getSize(); ++j) {
                Assertions.assertEquals((Object)false, (Object)yoBooleanBuffer.getBuffer()[j]);
            }
        }
        for (i = 0; i < 1000; ++i) {
            yoBoolean = SharedMemoryRandomTools.nextYoBoolean((Random)random, (YoRegistry)new YoRegistry("Dummy"));
            Assertions.assertTrue((yoBoolean == (yoBooleanBuffer = (YoBooleanBuffer)YoVariableBuffer.newYoVariableBuffer((YoVariable)yoBoolean, (YoBufferPropertiesReadOnly)(yoBufferProperties = SharedMemoryRandomTools.nextYoBufferProperties((Random)random)))).getYoVariable() ? 1 : 0) != 0);
            Assertions.assertTrue((yoBufferProperties == yoBooleanBuffer.getProperties() ? 1 : 0) != 0);
            Assertions.assertEquals((int)yoBufferProperties.getSize(), (int)yoBooleanBuffer.getBuffer().length);
            for (j = 0; j < yoBufferProperties.getSize(); ++j) {
                Assertions.assertEquals((Object)false, (Object)yoBooleanBuffer.getBuffer()[j]);
            }
        }
    }

    @Test
    public void testResizeBuffer() {
        Random random = new Random(8967254L);
        for (int i = 0; i < 1000; ++i) {
            YoBooleanBuffer yoBooleanBuffer = SharedMemoryRandomTools.nextYoBooleanBuffer((Random)random, (YoRegistry)new YoRegistry("Dummy"));
            YoBufferProperties originalBufferProperties = new YoBufferProperties(yoBooleanBuffer.getProperties());
            int from = random.nextInt(yoBooleanBuffer.getProperties().getSize());
            int newLength = random.nextInt(yoBooleanBuffer.getProperties().getSize());
            boolean[] expectedBuffer = SharedMemoryTools.ringArrayCopy((boolean[])yoBooleanBuffer.getBuffer(), (int)from, (int)newLength);
            yoBooleanBuffer.resizeBuffer(from, newLength);
            Assertions.assertArrayEquals((boolean[])expectedBuffer, (boolean[])yoBooleanBuffer.getBuffer());
            Assertions.assertEquals((Object)originalBufferProperties, (Object)yoBooleanBuffer.getProperties());
            boolean[] buffer = yoBooleanBuffer.getBuffer();
            yoBooleanBuffer.resizeBuffer(0, buffer.length);
            Assertions.assertTrue((buffer == yoBooleanBuffer.getBuffer() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testWriteBuffer() {
        Random random = new Random(867324L);
        for (int i = 0; i < 1000; ++i) {
            YoBooleanBuffer yoBooleanBuffer = SharedMemoryRandomTools.nextYoBooleanBuffer((Random)random, (YoRegistry)new YoRegistry("Dummy"));
            YoBoolean yoBoolean = (YoBoolean)yoBooleanBuffer.getYoVariable();
            int currentIndex = yoBooleanBuffer.getProperties().getCurrentIndex();
            yoBoolean.set(false);
            yoBooleanBuffer.writeBuffer();
            Assertions.assertEquals((Object)false, (Object)yoBoolean.getValue());
            Assertions.assertEquals((Object)false, (Object)yoBooleanBuffer.getBuffer()[currentIndex]);
            yoBoolean.set(true);
            yoBooleanBuffer.writeBuffer();
            Assertions.assertEquals((Object)true, (Object)yoBoolean.getValue());
            Assertions.assertEquals((Object)true, (Object)yoBooleanBuffer.getBuffer()[currentIndex]);
        }
    }

    @Test
    public void testReadBuffer() {
        Random random = new Random(867324L);
        for (int i = 0; i < 1000; ++i) {
            YoBooleanBuffer yoBooleanBuffer = SharedMemoryRandomTools.nextYoBooleanBuffer((Random)random, (YoRegistry)new YoRegistry("Dummy"));
            YoBoolean yoBoolean = (YoBoolean)yoBooleanBuffer.getYoVariable();
            int currentIndex = yoBooleanBuffer.getProperties().getCurrentIndex();
            yoBooleanBuffer.getBuffer()[currentIndex] = false;
            yoBooleanBuffer.readBuffer();
            Assertions.assertEquals((Object)false, (Object)yoBoolean.getValue());
            Assertions.assertEquals((Object)false, (Object)yoBooleanBuffer.getBuffer()[currentIndex]);
            yoBooleanBuffer.getBuffer()[currentIndex] = true;
            yoBooleanBuffer.readBuffer();
            Assertions.assertEquals((Object)true, (Object)yoBoolean.getValue());
            Assertions.assertEquals((Object)true, (Object)yoBooleanBuffer.getBuffer()[currentIndex]);
        }
    }

    @Test
    public void testCopy() {
        Random random = new Random(43566L);
        for (int i = 0; i < 1000; ++i) {
            YoBooleanBuffer yoBooleanBuffer = SharedMemoryRandomTools.nextYoBooleanBuffer((Random)random, (YoRegistry)new YoRegistry("Dummy"));
            int from = random.nextInt(yoBooleanBuffer.getProperties().getSize());
            int length = random.nextInt(yoBooleanBuffer.getProperties().getSize() - 1) + 1;
            boolean[] expectedCopy = SharedMemoryTools.ringArrayCopy((boolean[])yoBooleanBuffer.getBuffer(), (int)from, (int)length);
            BufferSample actualCopy = yoBooleanBuffer.copy(from, length, yoBooleanBuffer.getProperties().copy());
            Assertions.assertEquals((int)from, (int)actualCopy.getFrom());
            Assertions.assertEquals((int)length, (int)actualCopy.getSampleLength());
            Assertions.assertEquals((Object)yoBooleanBuffer.getProperties(), (Object)actualCopy.getBufferProperties());
            int to = from + length - 1;
            if (to >= yoBooleanBuffer.getProperties().getSize()) {
                to -= yoBooleanBuffer.getProperties().getSize();
            }
            Assertions.assertEquals((int)to, (int)actualCopy.getTo());
            Assertions.assertArrayEquals((boolean[])expectedCopy, (boolean[])((boolean[])actualCopy.getSample()));
        }
    }

    @Test
    public void testNewLinkedYoVariable() {
        Random random = new Random(87324L);
        for (int i = 0; i < 1000; ++i) {
            YoBoolean linkedBoolean = new YoBoolean("linked", new YoRegistry("Dummy"));
            YoBooleanBuffer yoBooleanBuffer = SharedMemoryRandomTools.nextYoBooleanBuffer((Random)random, (YoRegistry)new YoRegistry("Dummy"));
            LinkedYoBoolean linkedYoVariable = yoBooleanBuffer.newLinkedYoVariable(linkedBoolean);
            Assertions.assertTrue((linkedBoolean == linkedYoVariable.getLinkedYoVariable() ? 1 : 0) != 0);
            Assertions.assertTrue((yoBooleanBuffer == linkedYoVariable.getBuffer() ? 1 : 0) != 0);
        }
    }
}

