/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sharedMemory;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.scs2.sharedMemory.BufferSample;
import us.ihmc.scs2.sharedMemory.LinkedYoLong;
import us.ihmc.scs2.sharedMemory.YoBufferProperties;
import us.ihmc.scs2.sharedMemory.YoLongBuffer;
import us.ihmc.scs2.sharedMemory.YoVariableBuffer;
import us.ihmc.scs2.sharedMemory.interfaces.YoBufferPropertiesReadOnly;
import us.ihmc.scs2.sharedMemory.tools.SharedMemoryRandomTools;
import us.ihmc.scs2.sharedMemory.tools.SharedMemoryTools;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoLong;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoLongBufferTest {
    private static final int ITERATIONS = 1000;

    @Test
    public void testConstructors() {
        int j;
        YoBufferProperties yoBufferProperties;
        YoLongBuffer yoLongBuffer;
        YoLong yoLong;
        int i;
        Random random = new Random(467L);
        for (i = 0; i < 1000; ++i) {
            yoLong = SharedMemoryRandomTools.nextYoLong((Random)random, (YoRegistry)new YoRegistry("Dummy"));
            Assertions.assertTrue((yoLong == (yoLongBuffer = new YoLongBuffer(yoLong, (YoBufferPropertiesReadOnly)(yoBufferProperties = SharedMemoryRandomTools.nextYoBufferProperties((Random)random)))).getYoVariable() ? 1 : 0) != 0);
            Assertions.assertTrue((yoBufferProperties == yoLongBuffer.getProperties() ? 1 : 0) != 0);
            Assertions.assertEquals((int)yoBufferProperties.getSize(), (int)yoLongBuffer.getBuffer().length);
            for (j = 0; j < yoBufferProperties.getSize(); ++j) {
                Assertions.assertEquals((long)0L, (long)yoLongBuffer.getBuffer()[j]);
            }
        }
        for (i = 0; i < 1000; ++i) {
            yoLong = SharedMemoryRandomTools.nextYoLong((Random)random, (YoRegistry)new YoRegistry("Dummy"));
            Assertions.assertTrue((yoLong == (yoLongBuffer = (YoLongBuffer)YoVariableBuffer.newYoVariableBuffer((YoVariable)yoLong, (YoBufferPropertiesReadOnly)(yoBufferProperties = SharedMemoryRandomTools.nextYoBufferProperties((Random)random)))).getYoVariable() ? 1 : 0) != 0);
            Assertions.assertTrue((yoBufferProperties == yoLongBuffer.getProperties() ? 1 : 0) != 0);
            Assertions.assertEquals((int)yoBufferProperties.getSize(), (int)yoLongBuffer.getBuffer().length);
            for (j = 0; j < yoBufferProperties.getSize(); ++j) {
                Assertions.assertEquals((long)0L, (long)yoLongBuffer.getBuffer()[j]);
            }
        }
    }

    @Test
    public void testResizeBuffer() {
        Random random = new Random(8967254L);
        for (int i = 0; i < 1000; ++i) {
            YoLongBuffer yoLongBuffer = SharedMemoryRandomTools.nextYoLongBuffer((Random)random, (YoRegistry)new YoRegistry("Dummy"));
            YoBufferProperties originalBufferProperties = new YoBufferProperties(yoLongBuffer.getProperties());
            int from = random.nextInt(yoLongBuffer.getProperties().getSize());
            int newLength = random.nextInt(yoLongBuffer.getProperties().getSize());
            long[] expectedBuffer = SharedMemoryTools.ringArrayCopy((long[])yoLongBuffer.getBuffer(), (int)from, (int)newLength);
            yoLongBuffer.resizeBuffer(from, newLength);
            Assertions.assertArrayEquals((long[])expectedBuffer, (long[])yoLongBuffer.getBuffer());
            Assertions.assertEquals((Object)originalBufferProperties, (Object)yoLongBuffer.getProperties());
            long[] buffer = yoLongBuffer.getBuffer();
            yoLongBuffer.resizeBuffer(0, buffer.length);
            Assertions.assertTrue((buffer == yoLongBuffer.getBuffer() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testWriteBuffer() {
        Random random = new Random(867324L);
        for (int i = 0; i < 1000; ++i) {
            YoLongBuffer yoLongBuffer = SharedMemoryRandomTools.nextYoLongBuffer((Random)random, (YoRegistry)new YoRegistry("Dummy"));
            YoLong yoLong = (YoLong)yoLongBuffer.getYoVariable();
            int currentIndex = yoLongBuffer.getProperties().getCurrentIndex();
            for (int j = 0; j < 10; ++j) {
                long newValue = RandomNumbers.nextInt((Random)random, (int)-100000, (int)100000);
                yoLong.set(newValue);
                yoLongBuffer.writeBuffer();
                Assertions.assertEquals((long)newValue, (long)yoLong.getValue());
                Assertions.assertEquals((long)newValue, (long)yoLongBuffer.getBuffer()[currentIndex]);
            }
        }
    }

    @Test
    public void testReadBuffer() {
        Random random = new Random(867324L);
        for (int i = 0; i < 1000; ++i) {
            YoLongBuffer yoLongBuffer = SharedMemoryRandomTools.nextYoLongBuffer((Random)random, (YoRegistry)new YoRegistry("Dummy"));
            YoLong yoLong = (YoLong)yoLongBuffer.getYoVariable();
            int currentIndex = yoLongBuffer.getProperties().getCurrentIndex();
            for (int j = 0; j < 10; ++j) {
                long newValue;
                yoLongBuffer.getBuffer()[currentIndex] = newValue = (long)RandomNumbers.nextInt((Random)random, (int)-100000, (int)100000);
                yoLongBuffer.readBuffer();
                Assertions.assertEquals((long)newValue, (long)yoLong.getValue());
                Assertions.assertEquals((long)newValue, (long)yoLongBuffer.getBuffer()[currentIndex]);
            }
        }
    }

    @Test
    public void testCopy() {
        Random random = new Random(43566L);
        for (int i = 0; i < 1000; ++i) {
            YoLongBuffer yoLongBuffer = SharedMemoryRandomTools.nextYoLongBuffer((Random)random, (YoRegistry)new YoRegistry("Dummy"));
            int from = random.nextInt(yoLongBuffer.getProperties().getSize());
            int length = random.nextInt(yoLongBuffer.getProperties().getSize() - 1) + 1;
            long[] expectedCopy = SharedMemoryTools.ringArrayCopy((long[])yoLongBuffer.getBuffer(), (int)from, (int)length);
            BufferSample actualCopy = yoLongBuffer.copy(from, length, yoLongBuffer.getProperties().copy());
            Assertions.assertEquals((int)from, (int)actualCopy.getFrom());
            Assertions.assertEquals((int)length, (int)actualCopy.getSampleLength());
            Assertions.assertEquals((Object)yoLongBuffer.getProperties(), (Object)actualCopy.getBufferProperties());
            int to = from + length - 1;
            if (to >= yoLongBuffer.getProperties().getSize()) {
                to -= yoLongBuffer.getProperties().getSize();
            }
            Assertions.assertEquals((int)to, (int)actualCopy.getTo());
            Assertions.assertArrayEquals((long[])expectedCopy, (long[])((long[])actualCopy.getSample()));
        }
    }

    @Test
    public void testNewLinkedYoVariable() {
        Random random = new Random(87324L);
        for (int i = 0; i < 1000; ++i) {
            YoLong linkedLong = new YoLong("linked", new YoRegistry("Dummy"));
            YoLongBuffer yoLongBuffer = SharedMemoryRandomTools.nextYoLongBuffer((Random)random, (YoRegistry)new YoRegistry("Dummy"));
            LinkedYoLong linkedYoVariable = yoLongBuffer.newLinkedYoVariable(linkedLong);
            Assertions.assertTrue((linkedLong == linkedYoVariable.getLinkedYoVariable() ? 1 : 0) != 0);
            Assertions.assertTrue((yoLongBuffer == linkedYoVariable.getBuffer() ? 1 : 0) != 0);
        }
    }
}

