/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.sliderboard;

import java.lang.reflect.Array;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Transmitter;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.scs2.definition.yoSlider.YoSliderboardType;
import us.ihmc.scs2.sessionVisualizer.sliderboard.BehringerButtonController;
import us.ihmc.scs2.sessionVisualizer.sliderboard.BehringerChannelController;
import us.ihmc.scs2.sessionVisualizer.sliderboard.BehringerKnobController;
import us.ihmc.scs2.sessionVisualizer.sliderboard.BehringerMidiHelpers;
import us.ihmc.scs2.sessionVisualizer.sliderboard.BehringerSliderController;
import us.ihmc.scs2.sessionVisualizer.sliderboard.MidiChannelConfig;
import us.ihmc.scs2.sessionVisualizer.sliderboard.SliderboardVariable;

public class BCF2000SliderboardController {
    private final Receiver midiOut;
    private final Transmitter midiIn;
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(1, ThreadTools.createNamedDaemonThreadFactory((String)this.getClass().getSimpleName()));
    private ScheduledFuture<?> currentTask;
    private final BehringerSliderController[] sliderControllers = new BehringerSliderController[8];
    private final BehringerButtonController[] buttonControllers = new BehringerButtonController[16];
    private final BehringerKnobController[] knobControllers = new BehringerKnobController[8];
    private final BehringerChannelController[] allControllers;
    private final Receiver receiver = new Receiver(){

        @Override
        public void send(MidiMessage message, long timeStamp) {
            if (!(message instanceof ShortMessage)) {
                return;
            }
            ShortMessage shortMessage = (ShortMessage)message;
            BCF2000Slider slider = BCF2000Slider.fromChannel(shortMessage.getData1());
            if (slider != null && BCF2000SliderboardController.this.sliderControllers[slider.ordinal()].handleMessage(shortMessage, timeStamp)) {
                return;
            }
            BCF2000Button button = BCF2000Button.fromChannel(shortMessage.getData1());
            if (button != null && BCF2000SliderboardController.this.buttonControllers[button.ordinal()].handleMessage(shortMessage, timeStamp)) {
                return;
            }
            BCF2000Knob knob = BCF2000Knob.fromChannel(shortMessage.getData1());
            if (knob != null && BCF2000SliderboardController.this.knobControllers[knob.ordinal()].handleMessage(shortMessage, timeStamp)) {
                return;
            }
        }

        @Override
        public void close() {
        }
    };

    private BCF2000SliderboardController(Receiver midiOut, Transmitter midiIn) {
        this.midiOut = midiOut;
        this.midiIn = midiIn;
        midiIn.setReceiver(this.receiver);
        for (BCF2000Slider bCF2000Slider : BCF2000Slider.values) {
            this.sliderControllers[bCF2000Slider.ordinal()] = new BehringerSliderController(bCF2000Slider, midiOut);
        }
        for (Enum enum_ : BCF2000Button.values) {
            this.buttonControllers[enum_.ordinal()] = new BehringerButtonController((MidiChannelConfig)((Object)enum_), midiOut);
        }
        for (Enum enum_ : BCF2000Knob.values) {
            this.knobControllers[enum_.ordinal()] = new BehringerKnobController((MidiChannelConfig)((Object)enum_), midiOut);
        }
        this.allControllers = BCF2000SliderboardController.combineArrays(BehringerChannelController.class, this.sliderControllers, this.buttonControllers, this.knobControllers);
    }

    private static <T> T[] combineArrays(Class<T> componentType, T[] ... inputArrays) {
        int outputLength = 0;
        for (T[] inputArray : inputArrays) {
            outputLength += inputArray.length;
        }
        Object[] outputArray = (Object[])Array.newInstance(componentType, outputLength);
        int outputIndex = 0;
        for (T[] inputArray : inputArrays) {
            for (int i = 0; i < inputArray.length; ++i) {
                outputArray[outputIndex++] = inputArray[i];
            }
        }
        return outputArray;
    }

    public SliderboardVariable getSlider(BCF2000Slider slider) {
        return this.sliderControllers[slider.ordinal()].getControlVariable();
    }

    public SliderboardVariable getButton(BCF2000Button button) {
        return this.buttonControllers[button.ordinal()].getControlVariable();
    }

    public SliderboardVariable getKnob(BCF2000Knob knob) {
        return this.knobControllers[knob.ordinal()].getControlVariable();
    }

    public void update() {
        for (BehringerChannelController controller : this.allControllers) {
            controller.update();
        }
    }

    public void start() {
        if (this.currentTask != null) {
            return;
        }
        for (BehringerChannelController controller : this.allControllers) {
            controller.enable();
        }
        this.currentTask = this.executor.scheduleAtFixedRate(this::update, 0L, 20L, TimeUnit.MILLISECONDS);
    }

    public void stop() {
        if (this.currentTask != null) {
            this.currentTask.cancel(false);
            this.currentTask = null;
        }
        for (BehringerChannelController controller : this.allControllers) {
            controller.disable();
        }
    }

    public void closeAndDispose() {
        this.stop();
        this.executor.shutdown();
        if (this.midiOut != null) {
            this.midiOut.close();
        }
        if (this.midiIn != null) {
            this.midiIn.close();
        }
    }

    public static boolean isBCF2000Sliderboard(MidiDevice.Info info) {
        String name = info.getName();
        String description = info.getDescription();
        return name.contains(YoSliderboardType.BCF2000.getTypeString()) || description.contains(YoSliderboardType.BCF2000.getTypeString());
    }

    public static void closeMidiDevices() {
        MidiDevice.Info[] infos;
        for (MidiDevice.Info info : infos = MidiSystem.getMidiDeviceInfo()) {
            MidiDevice midiDevice;
            if (!BCF2000SliderboardController.isBCF2000Sliderboard(info) || (midiDevice = BehringerMidiHelpers.getDevice(info)) == null || !midiDevice.isOpen()) continue;
            midiDevice.close();
        }
    }

    public static BCF2000SliderboardController searchAndConnectToDevice() {
        MidiDevice.Info[] infos = MidiSystem.getMidiDeviceInfo();
        Receiver out = null;
        Transmitter in = null;
        for (MidiDevice.Info info : infos) {
            if (out != null && in != null) break;
            if (!BCF2000SliderboardController.isBCF2000Sliderboard(info) || out == null && (out = BehringerMidiHelpers.connectToMidiOutDevice(info)) != null || in != null) continue;
            in = BehringerMidiHelpers.connectToMidiInDevice(info);
        }
        if (out != null && in != null) {
            return new BCF2000SliderboardController(out, in);
        }
        return null;
    }

    public static enum BCF2000Slider implements MidiChannelConfig
    {
        SLIDER_1,
        SLIDER_2,
        SLIDER_3,
        SLIDER_4,
        SLIDER_5,
        SLIDER_6,
        SLIDER_7,
        SLIDER_8;

        public static final BCF2000Slider[] values;
        private static final int CHANNEL_OFFSET = 81;
        private final int channel = this.ordinal() + 81;

        @Override
        public int getChannel() {
            return this.channel;
        }

        @Override
        public int getMin() {
            return 0;
        }

        @Override
        public int getMax() {
            return 127;
        }

        public static BCF2000Slider fromChannel(int channel) {
            if (channel < 81 || channel > 88) {
                return null;
            }
            return values[channel - 81];
        }

        static {
            values = BCF2000Slider.values();
        }
    }

    public static enum BCF2000Button implements MidiChannelConfig
    {
        BUTTON_1,
        BUTTON_2,
        BUTTON_3,
        BUTTON_4,
        BUTTON_5,
        BUTTON_6,
        BUTTON_7,
        BUTTON_8,
        BUTTON_9,
        BUTTON_10,
        BUTTON_11,
        BUTTON_12,
        BUTTON_13,
        BUTTON_14,
        BUTTON_15,
        BUTTON_16;

        public static final BCF2000Button[] values;
        private static final int CHANNEL_OFFSET = 65;
        private final int channel = this.ordinal() + 65;

        @Override
        public int getChannel() {
            return this.channel;
        }

        public static BCF2000Button fromChannel(int channel) {
            if (channel < 65 || channel > 80) {
                return null;
            }
            return values[channel - 65];
        }

        static {
            values = BCF2000Button.values();
        }
    }

    public static enum BCF2000Knob implements MidiChannelConfig
    {
        KNOB_1,
        KNOB_2,
        KNOB_3,
        KNOB_4,
        KNOB_5,
        KNOB_6,
        KNOB_7,
        KNOB_8;

        public static final BCF2000Knob[] values;
        private static final int CHANNEL_OFFSET = 1;
        private final int channel = this.ordinal() + 1;

        @Override
        public int getChannel() {
            return this.channel;
        }

        @Override
        public int getMin() {
            return 0;
        }

        @Override
        public int getMax() {
            return 127;
        }

        public static BCF2000Knob fromChannel(int channel) {
            if (channel < 1 || channel > 8) {
                return null;
            }
            return values[channel - 1];
        }

        static {
            values = BCF2000Knob.values();
        }
    }

    public static enum KnobButton implements MidiChannelConfig
    {
        BUTTON_1,
        BUTTON_2,
        BUTTON_3,
        BUTTON_4,
        BUTTON_5,
        BUTTON_6,
        BUTTON_7,
        BUTTON_8;

        public static final KnobButton[] values;
        private static final int CHANNEL_OFFSET = 32;
        private final int channel = this.ordinal() + 32;

        @Override
        public int getChannel() {
            return this.channel;
        }

        public static KnobButton fromChannel(int channel) {
            if (channel < 32 || channel > 39) {
                return null;
            }
            return values[channel - 32];
        }

        static {
            values = KnobButton.values();
        }
    }
}

