/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.sliderboard;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import us.ihmc.commons.MathTools;
import us.ihmc.scs2.sessionVisualizer.sliderboard.BCF2000SliderboardController;
import us.ihmc.scs2.sessionVisualizer.sliderboard.SliderboardVariable;

public class BCF2000SliderController {
    private final BCF2000SliderboardController.Slider slider;
    private final Receiver midiOut;
    private final SliderboardVariable controlVariable;
    private int currentSliderValue = -1;
    private int newSliderValue = -1;

    public BCF2000SliderController(BCF2000SliderboardController.Slider slider, Receiver midiOut) {
        this.slider = slider;
        this.midiOut = midiOut;
        this.controlVariable = new SliderboardVariable(slider.getMin(), slider.getMax());
    }

    public boolean handleMessage(ShortMessage message, long timestamp) {
        if (this.slider.getChannel() != message.getData1()) {
            return false;
        }
        this.newSliderValue = MathTools.clamp((int)message.getData2(), (int)this.slider.getMin(), (int)this.slider.getMax());
        return true;
    }

    public void moveSlider(int value) {
        if (value == -1) {
            return;
        }
        try {
            ShortMessage message = new ShortMessage();
            message.setMessage(176, 0, this.slider.getChannel(), value);
            this.midiOut.send(message, -1L);
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
        }
    }

    public void update() {
        if (this.newSliderValue != -1) {
            this.currentSliderValue = this.newSliderValue;
        }
        if (this.newSliderValue != -1) {
            this.controlVariable.setValue(this.newSliderValue);
            this.newSliderValue = -1;
        } else if (this.controlVariable.getValue() != this.currentSliderValue) {
            this.currentSliderValue = this.controlVariable.getValue();
            this.moveSlider(this.controlVariable.getValue());
        }
    }

    public SliderboardVariable getControlVariable() {
        return this.controlVariable;
    }
}

