/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.editor.yoTextField;

import java.util.Collection;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.TransferMode;
import javafx.util.Callback;
import org.controlsfx.control.textfield.AutoCompletionBinding;
import org.controlsfx.control.textfield.TextFields;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.YoGraphicFXControllerTools;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.YoComposite;

public abstract class YoVariableTextField<T extends Property<?>> {
    private final TextField textField;
    private final BooleanProperty validityProperty = new SimpleBooleanProperty((Object)this, "yoTextFieldValidity", false);
    private final ObjectProperty<T> supplierProperty = new SimpleObjectProperty((Object)this, "supplier", null);

    public YoVariableTextField(TextField textField, ImageView validImageView) {
        this.textField = textField;
        if (validImageView != null) {
            this.attachValidImageView(validImageView);
        }
        textField.textProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null && newValue.equals(oldValue)) {
                return;
            }
            String simplifiedText = this.simplifyText((String)newValue);
            if (simplifiedText != null) {
                textField.setText(simplifiedText);
                return;
            }
            boolean isTextValid = this.isTextValid((String)newValue);
            this.validityProperty.set(isTextValid);
            if (isTextValid) {
                this.supplierProperty.set(this.toSupplier((String)newValue));
            }
        });
        textField.setOnDragEntered(this::handleDragEntered);
        textField.setOnDragExited(this::handleDragExited);
        textField.setOnDragOver(this::handleDragOver);
        textField.setOnDragDropped(this::handleDragDropped);
    }

    protected abstract boolean isTextValid(String var1);

    protected abstract String simplifyText(String var1);

    protected abstract Callback<AutoCompletionBinding.ISuggestionRequest, Collection<String>> createSuggestions();

    public void setupAutoCompletion() {
        AutoCompletionBinding autoCompletionBinding = TextFields.bindAutoCompletion((TextField)this.textField, this.createSuggestions());
        autoCompletionBinding.prefWidthProperty().bind((ObservableValue)this.textField.widthProperty());
        this.textField.addEventHandler(KeyEvent.KEY_PRESSED, e -> {
            if (this.textField.isFocused() && e.isControlDown() && e.getCode() == KeyCode.SPACE) {
                autoCompletionBinding.setUserInput(this.textField.getText());
                e.consume();
            }
        });
    }

    public void attachValidImageView(ImageView imageView) {
        this.attachValidImageView(imageView, SessionVisualizerIOTools.VALID_ICON_IMAGE, SessionVisualizerIOTools.INVALID_ICON_IMAGE);
    }

    public void attachValidImageView(ImageView imageView, Image validIcon, Image invalidIcon) {
        YoGraphicFXControllerTools.bindBooleanToImageView((ObservableBooleanValue)this.validityProperty, imageView, validIcon, invalidIcon);
    }

    public BooleanProperty getValidityProperty() {
        return this.validityProperty;
    }

    protected abstract T toSupplier(String var1);

    public T getSupplier() {
        if (!this.validityProperty.get()) {
            return null;
        }
        return (T)((Property)this.supplierProperty.get());
    }

    public ObjectProperty<T> supplierProperty() {
        return this.supplierProperty;
    }

    private void handleDragEntered(DragEvent dragEvent) {
        if (this.acceptDragEventForDrop(dragEvent)) {
            dragEvent.consume();
        }
    }

    private void handleDragExited(DragEvent event) {
        if (this.acceptDragEventForDrop(event)) {
            event.consume();
        }
    }

    private void handleDragOver(DragEvent event) {
        if (this.acceptDragEventForDrop(event)) {
            event.acceptTransferModes(TransferMode.ANY);
        }
        event.consume();
    }

    protected abstract List<YoComposite> retrieveYoCompositesFromDragboard(Dragboard var1);

    private void handleDragDropped(DragEvent event) {
        Dragboard dragboard = event.getDragboard();
        boolean success = false;
        List<YoComposite> yoComposites = this.retrieveYoCompositesFromDragboard(dragboard);
        if (yoComposites != null) {
            success = true;
            this.textField.setText(yoComposites.get(0).getUniqueName());
        }
        event.setDropCompleted(success);
        event.consume();
    }

    private boolean acceptDragEventForDrop(DragEvent event) {
        if (event.getGestureSource() == this.textField) {
            return false;
        }
        return this.retrieveYoCompositesFromDragboard(event.getDragboard()) != null;
    }
}

