/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.tools;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;

public class DouglasPeuckerReduction {
    public static <T extends Point2DReadOnly> List<T> reduce(List<T> rawPoints, double epsilon) {
        if (rawPoints.size() <= 2) {
            return rawPoints;
        }
        double dmax = 0.0;
        int index = 0;
        int end = rawPoints.size();
        Point2DReadOnly firstPoint = (Point2DReadOnly)rawPoints.get(0);
        Point2DReadOnly lastPoint = (Point2DReadOnly)rawPoints.get(end - 1);
        for (int i = 1; i < end; ++i) {
            double d = EuclidGeometryTools.distanceFromPoint2DToLine2D((Point2DReadOnly)((Point2DReadOnly)rawPoints.get(i)), (Point2DReadOnly)firstPoint, (Point2DReadOnly)lastPoint);
            if (!(d > dmax)) continue;
            index = i;
            dmax = d;
        }
        if (dmax > epsilon) {
            List<T> subListA = DouglasPeuckerReduction.reduce(rawPoints.subList(0, index), epsilon);
            List<T> subListB = DouglasPeuckerReduction.reduce(rawPoints.subList(index, end), epsilon);
            ArrayList<T> result = new ArrayList<T>(subListA.size() + subListB.size());
            result.addAll(subListA);
            result.addAll(subListB);
            return result;
        }
        ArrayList<Point2DReadOnly> result = new ArrayList<Point2DReadOnly>(2);
        result.add(firstPoint);
        result.add(lastPoint);
        return result;
    }
}

