/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.session.log;

import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Duration;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.session.log.VideoDataReader;

public class VideoViewer {
    private static final double THUMBNAIL_HIGHLIGHT_SCALE = 1.05;
    private final ImageView thumbnail = new ImageView();
    private final StackPane thumbnailContainer = new StackPane(new Node[]{this.thumbnail});
    private final ImageView videoView = new ImageView();
    private final BooleanProperty updateVideoView = new SimpleBooleanProperty((Object)this, "updateVideoView", false);
    private final ObjectProperty<Stage> videoWindowProperty = new SimpleObjectProperty((Object)this, "videoWindow", null);
    private final VideoDataReader reader;
    private final double defaultThumbnailSize;

    public VideoViewer(Window owner, VideoDataReader reader, double defaultThumbnailSize) {
        this.reader = reader;
        this.defaultThumbnailSize = defaultThumbnailSize;
        this.thumbnail.setPreserveRatio(true);
        this.videoView.setPreserveRatio(true);
        this.thumbnail.setFitWidth(defaultThumbnailSize);
        this.thumbnail.setOnMouseEntered(e -> {
            Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)0.1), new KeyValue[]{new KeyValue((WritableValue)this.thumbnail.fitWidthProperty(), (Object)(1.05 * defaultThumbnailSize), Interpolator.EASE_BOTH)})});
            timeline.playFromStart();
        });
        this.thumbnail.setOnMouseExited(e -> {
            Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)0.1), new KeyValue[]{new KeyValue((WritableValue)this.thumbnail.fitWidthProperty(), (Object)defaultThumbnailSize, Interpolator.EASE_BOTH)})});
            timeline.playFromStart();
        });
        this.thumbnail.addEventHandler(MouseEvent.MOUSE_CLICKED, e -> {
            Stage stage;
            if (e.getClickCount() != 2) {
                return;
            }
            this.videoView.setImage(this.thumbnail.getImage());
            if (this.videoWindowProperty.get() != null) {
                stage = (Stage)this.videoWindowProperty.get();
            } else {
                stage = new Stage();
                Pane root = VideoViewer.createImageViewPane(this.videoView);
                this.videoWindowProperty.set((Object)stage);
                stage.getIcons().add((Object)SessionVisualizerIOTools.LOG_SESSION_IMAGE);
                stage.setTitle(reader.getName());
                owner.setOnHiding(e2 -> stage.close());
                Scene scene = new Scene((Parent)root);
                stage.setScene(scene);
                this.updateVideoView.bind((ObservableValue)stage.showingProperty());
            }
            Screen screen = (Screen)Screen.getScreensForRectangle((double)e.getScreenX(), (double)e.getScreenY(), (double)1.0, (double)1.0).get(0);
            Rectangle2D visualBounds = screen.getVisualBounds();
            double width = 0.5 * visualBounds.getWidth();
            double height = 0.5 * visualBounds.getHeight();
            double x = visualBounds.getMinX() + 0.5 * (visualBounds.getWidth() - width);
            double y = visualBounds.getMinY() + 0.5 * (visualBounds.getHeight() - height);
            stage.setX(x);
            stage.setY(y);
            stage.setWidth(width);
            stage.setHeight(height);
            stage.toFront();
            stage.show();
        });
    }

    private static Pane createImageViewPane(final ImageView imageView) {
        return new Pane(new Node[]{imageView}){

            protected void layoutChildren() {
                Image image = imageView.getImage();
                if (image == null) {
                    return;
                }
                double imageRatio = image.getWidth() / image.getHeight();
                double width = Math.min(this.getWidth(), this.getHeight() * imageRatio);
                double height = width / imageRatio;
                double x = 0.5 * (this.getWidth() - width);
                double y = 0.5 * (this.getHeight() - height);
                imageView.setFitWidth(width);
                imageView.setX(x);
                imageView.setY(y);
            }
        };
    }

    public void update() {
        WritableImage currentFrame = this.reader.pollCurrentFrame();
        if (currentFrame == null) {
            return;
        }
        this.thumbnailContainer.setPrefWidth(1.05 * this.defaultThumbnailSize);
        this.thumbnailContainer.setPrefHeight(1.05 * this.defaultThumbnailSize * currentFrame.getHeight() / currentFrame.getWidth());
        this.thumbnail.setImage((Image)currentFrame);
        if (this.updateVideoView.get()) {
            this.videoView.setImage((Image)currentFrame);
        }
    }

    public void stop() {
        if (this.videoWindowProperty.get() != null) {
            ((Stage)this.videoWindowProperty.get()).close();
            this.videoWindowProperty.set(null);
        }
    }

    public Node getThumbnail() {
        return this.thumbnailContainer;
    }
}

