/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.DoubleConsumer;
import java.util.stream.Stream;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableDoubleValue;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.Mesh;
import javafx.scene.shape.MeshView;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.scs2.definition.visual.SegmentedLine3DTriangleMeshFactory;
import us.ihmc.scs2.sessionVisualizer.jfx.definition.JavaFXTriangleMesh3DDefinitionInterpreter;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFX;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFX3D;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicTools;

public class YoPolynomialFX3D
extends YoGraphicFX3D {
    private List<DoubleProperty> coefficientsX;
    private List<DoubleProperty> coefficientsY;
    private List<DoubleProperty> coefficientsZ;
    private IntegerProperty numberOfCoefficientsX;
    private IntegerProperty numberOfCoefficientsY;
    private IntegerProperty numberOfCoefficientsZ;
    private DoubleProperty startTime = new SimpleDoubleProperty(0.0);
    private DoubleProperty endTime;
    private DoubleProperty size = new SimpleDoubleProperty(0.01);
    private IntegerProperty timeResolution = new SimpleIntegerProperty(50);
    private IntegerProperty numberOfDivisions = new SimpleIntegerProperty(20);
    private final PhongMaterial material = new PhongMaterial();
    private final Group polynomialNode = new Group();
    private Polynomial3DData newPolynomial = null;
    private Polynomial3DData oldPolynomial = null;
    private MeshView[] newMeshViews = null;

    public YoPolynomialFX3D() {
    }

    public YoPolynomialFX3D(ReferenceFrame worldFrame) {
        this();
    }

    @Override
    public void render() {
        this.newPolynomial = this.newPolynomial3D();
        if (this.color != null) {
            this.material.setDiffuseColor((Color)this.color.get());
        }
        if (this.newMeshViews != null) {
            this.polynomialNode.getChildren().clear();
            this.polynomialNode.getChildren().addAll((Object[])this.newMeshViews);
            this.newMeshViews = null;
        }
    }

    private Polynomial3DData newPolynomial3D() {
        Polynomial3DData polynomial3D = new Polynomial3DData();
        if (YoGraphicTools.isAnyNull(this.coefficientsX, this.coefficientsY, this.coefficientsZ, this.startTime, this.endTime, this.size)) {
            return polynomial3D;
        }
        if (EuclidCoreTools.epsilonEquals((double)this.startTime.get(), (double)this.endTime.get(), (double)1.0E-5)) {
            return polynomial3D;
        }
        polynomial3D.coefficientsX = YoPolynomialFX3D.toDoubleArray(this.coefficientsX, this.numberOfCoefficientsX);
        polynomial3D.coefficientsY = YoPolynomialFX3D.toDoubleArray(this.coefficientsY, this.numberOfCoefficientsY);
        polynomial3D.coefficientsZ = YoPolynomialFX3D.toDoubleArray(this.coefficientsZ, this.numberOfCoefficientsZ);
        polynomial3D.startTime = this.startTime.get();
        polynomial3D.endTime = this.endTime.get();
        polynomial3D.size = this.size.get();
        return polynomial3D;
    }

    @Override
    public void computeBackground() {
        Polynomial3DData newPolynomialLocal = this.newPolynomial;
        this.newPolynomial = null;
        if (newPolynomialLocal == null) {
            return;
        }
        if (Double.isNaN(newPolynomialLocal.startTime) || Double.isNaN(newPolynomialLocal.endTime) || newPolynomialLocal.coefficientsX == null || newPolynomialLocal.coefficientsX.length == 0 || newPolynomialLocal.coefficientsY.length == 0 || newPolynomialLocal.coefficientsZ.length == 0) {
            this.newMeshViews = new MeshView[0];
            return;
        }
        if (newPolynomialLocal.equals(this.oldPolynomial) && !this.polynomialNode.getChildren().isEmpty()) {
            return;
        }
        int timeResolution = this.timeResolution.get();
        int numberOfDivisions = this.numberOfDivisions.get();
        Point3D[] positions = new Point3D[timeResolution];
        Vector3D[] velocities = new Vector3D[timeResolution];
        for (int i = 0; i < timeResolution; ++i) {
            double alpha = (double)i / ((double)timeResolution - 1.0);
            double time = EuclidCoreTools.interpolate((double)newPolynomialLocal.startTime, (double)newPolynomialLocal.endTime, (double)alpha);
            positions[i] = new Point3D();
            velocities[i] = new Vector3D();
            YoPolynomialFX3D.computeAt(time, arg_0 -> ((Point3D)positions[i]).setX(arg_0), arg_0 -> ((Vector3D)velocities[i]).setX(arg_0), newPolynomialLocal.coefficientsX);
            YoPolynomialFX3D.computeAt(time, arg_0 -> ((Point3D)positions[i]).setY(arg_0), arg_0 -> ((Vector3D)velocities[i]).setY(arg_0), newPolynomialLocal.coefficientsY);
            YoPolynomialFX3D.computeAt(time, arg_0 -> ((Point3D)positions[i]).setZ(arg_0), arg_0 -> ((Vector3D)velocities[i]).setZ(arg_0), newPolynomialLocal.coefficientsZ);
        }
        SegmentedLine3DTriangleMeshFactory meshGenerator = new SegmentedLine3DTriangleMeshFactory(timeResolution, numberOfDivisions, newPolynomialLocal.size);
        meshGenerator.compute((Point3DReadOnly[])positions, (Vector3DReadOnly[])velocities);
        Mesh[] meshes = (Mesh[])Stream.of(meshGenerator.getTriangleMesh3DDefinitions()).map(JavaFXTriangleMesh3DDefinitionInterpreter::interpretDefinition).toArray(Mesh[]::new);
        MeshView[] meshViews = new MeshView[meshes.length];
        for (int i = 0; i < meshes.length; ++i) {
            meshViews[i] = new MeshView(meshes[i]);
            meshViews[i].setMaterial((Material)this.material);
            meshViews[i].idProperty().bind((ObservableValue)this.nameProperty().concat((Object)" (").concat((Object)Integer.toString(i)).concat((Object)")"));
        }
        this.oldPolynomial = newPolynomialLocal;
        this.newMeshViews = meshViews;
    }

    private static double[] toDoubleArray(List<DoubleProperty> list, IntegerProperty size) {
        if (size != null && size.get() < list.size()) {
            list = list.subList(0, size.get());
        }
        return list.stream().mapToDouble(WritableDoubleValue::get).toArray();
    }

    private static void computeAt(double time, DoubleConsumer positionConsumer, DoubleConsumer velocityConsumer, double[] coefficients) {
        int i;
        double[] timePowers = YoPolynomialFX3D.computeTimePowers(time, coefficients.length);
        double position = 0.0;
        double velocity = 0.0;
        for (i = 0; i < coefficients.length; ++i) {
            position += timePowers[i] * coefficients[i];
        }
        for (i = 1; i < coefficients.length; ++i) {
            velocity += (double)i * timePowers[i - 1] * coefficients[i];
        }
        positionConsumer.accept(position);
        velocityConsumer.accept(velocity);
    }

    private static double[] computeTimePowers(double t, int n) {
        if (n == 0) {
            return new double[0];
        }
        double[] timePowers = new double[n];
        timePowers[0] = 1.0;
        for (int i = 1; i < n; ++i) {
            timePowers[i] = timePowers[i - 1] * t;
        }
        return timePowers;
    }

    public void setCoefficientsX(List<DoubleProperty> coefficientsX) {
        this.coefficientsX = coefficientsX;
    }

    public void setCoefficientsY(List<DoubleProperty> coefficientsY) {
        this.coefficientsY = coefficientsY;
    }

    public void setCoefficientsZ(List<DoubleProperty> coefficientsZ) {
        this.coefficientsZ = coefficientsZ;
    }

    public void setNumberOfCoefficientsX(IntegerProperty numberOfCoefficientsX) {
        this.numberOfCoefficientsX = numberOfCoefficientsX;
    }

    public void setNumberOfCoefficientsX(int numberOfCoefficientsX) {
        this.setNumberOfCoefficientsX((IntegerProperty)new SimpleIntegerProperty(numberOfCoefficientsX));
    }

    public void setNumberOfCoefficientsY(IntegerProperty numberOfCoefficientsY) {
        this.numberOfCoefficientsY = numberOfCoefficientsY;
    }

    public void setNumberOfCoefficientsY(int numberOfCoefficientsY) {
        this.setNumberOfCoefficientsY((IntegerProperty)new SimpleIntegerProperty(numberOfCoefficientsY));
    }

    public void setNumberOfCoefficientsZ(IntegerProperty numberOfCoefficientsZ) {
        this.numberOfCoefficientsZ = numberOfCoefficientsZ;
    }

    public void setNumberOfCoefficientsZ(int numberOfCoefficientsZ) {
        this.setNumberOfCoefficientsZ((IntegerProperty)new SimpleIntegerProperty(numberOfCoefficientsZ));
    }

    public void setStartTime(DoubleProperty startTime) {
        this.startTime = startTime;
    }

    public void setStartTime(double startTime) {
        this.setStartTime((DoubleProperty)new SimpleDoubleProperty(startTime));
    }

    public void setEndTime(DoubleProperty endTime) {
        this.endTime = endTime;
    }

    public void setEndTime(double endTime) {
        this.setEndTime((DoubleProperty)new SimpleDoubleProperty(endTime));
    }

    public void setSize(DoubleProperty size) {
        this.size = size;
    }

    public void setSize(double size) {
        this.setSize((DoubleProperty)new SimpleDoubleProperty(size));
    }

    public void setTimeResolution(int timeResolution) {
        this.setTimeResolution((IntegerProperty)new SimpleIntegerProperty(timeResolution));
    }

    public void setTimeResolution(IntegerProperty timeResolution) {
        this.timeResolution = timeResolution;
    }

    public void setNumberOfDivisions(int numberOfDivisions) {
        this.setNumberOfDivisions((IntegerProperty)new SimpleIntegerProperty(numberOfDivisions));
    }

    public void setNumberOfDivisions(IntegerProperty numberOfDivisions) {
        this.numberOfDivisions = numberOfDivisions;
    }

    @Override
    public void clear() {
        this.coefficientsX = null;
        this.coefficientsY = null;
        this.coefficientsZ = null;
        this.numberOfCoefficientsX = null;
        this.numberOfCoefficientsY = null;
        this.numberOfCoefficientsZ = null;
        this.startTime = null;
        this.endTime = null;
        this.size = null;
        this.color = null;
    }

    @Override
    public YoGraphicFX clone() {
        YoPolynomialFX3D clone = new YoPolynomialFX3D();
        clone.setName(this.getName());
        clone.setCoefficientsX(new ArrayList<DoubleProperty>(this.coefficientsX));
        clone.setCoefficientsY(new ArrayList<DoubleProperty>(this.coefficientsY));
        clone.setCoefficientsZ(new ArrayList<DoubleProperty>(this.coefficientsZ));
        clone.setNumberOfCoefficientsX(this.numberOfCoefficientsX);
        clone.setNumberOfCoefficientsY(this.numberOfCoefficientsY);
        clone.setNumberOfCoefficientsZ(this.numberOfCoefficientsZ);
        clone.setStartTime(this.startTime);
        clone.setEndTime(this.endTime);
        clone.setSize(this.size);
        clone.setTimeResolution(this.timeResolution);
        clone.setNumberOfDivisions(this.numberOfDivisions);
        clone.setColor(this.color);
        return clone;
    }

    public List<DoubleProperty> getCoefficientsX() {
        return this.coefficientsX;
    }

    public List<DoubleProperty> getCoefficientsY() {
        return this.coefficientsY;
    }

    public List<DoubleProperty> getCoefficientsZ() {
        return this.coefficientsZ;
    }

    public IntegerProperty getNumberOfCoefficientsX() {
        return this.numberOfCoefficientsX;
    }

    public IntegerProperty getNumberOfCoefficientsY() {
        return this.numberOfCoefficientsY;
    }

    public IntegerProperty getNumberOfCoefficientsZ() {
        return this.numberOfCoefficientsZ;
    }

    public DoubleProperty getStartTime() {
        return this.startTime;
    }

    public DoubleProperty getEndTime() {
        return this.endTime;
    }

    public DoubleProperty getSize() {
        return this.size;
    }

    public IntegerProperty getTimeResolution() {
        return this.timeResolution;
    }

    public IntegerProperty getNumberOfDivisions() {
        return this.numberOfDivisions;
    }

    @Override
    public Node getNode() {
        return this.polynomialNode;
    }

    private static class Polynomial3DData {
        private double[] coefficientsX;
        private double[] coefficientsY;
        private double[] coefficientsZ;
        private double startTime = Double.NaN;
        private double endTime = Double.NaN;
        private double size = Double.NaN;

        private Polynomial3DData() {
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof Polynomial3DData) {
                Polynomial3DData other = (Polynomial3DData)object;
                if (!Arrays.equals(this.coefficientsX, other.coefficientsX)) {
                    return false;
                }
                if (!Arrays.equals(this.coefficientsY, other.coefficientsY)) {
                    return false;
                }
                if (!Arrays.equals(this.coefficientsZ, other.coefficientsZ)) {
                    return false;
                }
                if (this.startTime != other.startTime) {
                    return false;
                }
                if (this.endTime != other.endTime) {
                    return false;
                }
                return this.size == other.size;
            }
            return false;
        }
    }
}

