/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.managers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.scene.Camera;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.shape.Mesh;
import javafx.scene.shape.MeshView;
import javafx.scene.shape.TriangleMesh;
import us.ihmc.javaFXToolkit.shapes.JavaFXCoordinateSystem;
import us.ihmc.scs2.definition.terrain.TerrainObjectDefinition;
import us.ihmc.scs2.definition.visual.VisualDefinition;
import us.ihmc.scs2.session.Session;
import us.ihmc.scs2.sessionVisualizer.jfx.Skybox;
import us.ihmc.scs2.sessionVisualizer.jfx.definition.JavaFXVisualTools;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.BackgroundExecutorManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.Manager;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;

public class EnvironmentManager
implements Manager {
    private static final int LARGE_TRIANGLE_MESH_THRESHOLD = 1000000;
    private final Group rootNode = new Group();
    private final Group terrainObjectGraphics = new Group();
    private Group staticVisualsRoot;
    private Map<VisualDefinition, Node> staticVisualDefinitionToNodeMap;
    private Skybox skybox;
    private final BackgroundExecutorManager backgroundExecutorManager;

    public EnvironmentManager(BackgroundExecutorManager backgroundExecutorManager) {
        this.backgroundExecutorManager = backgroundExecutorManager;
        this.rootNode.getChildren().add((Object)this.terrainObjectGraphics);
    }

    public void addWorldCoordinateSystem(double size) {
        this.backgroundExecutorManager.executeInBackground(() -> {
            JavaFXCoordinateSystem node = new JavaFXCoordinateSystem(size);
            JavaFXMissingTools.runLater(this.getClass(), () -> this.lambda$addWorldCoordinateSystem$0((Node)node));
        });
    }

    public void addSkybox(Camera mainCamera) {
        if (this.skybox != null) {
            return;
        }
        this.skybox = new Skybox();
        if (Skybox.USE_CLOUDY_CROWN_SKY_BOX) {
            this.skybox.setupCloudyCrown();
        } else {
            this.skybox.setupSCS1Skybox();
        }
        this.skybox.setupCamera(mainCamera);
        this.backgroundExecutorManager.executeInBackground(() -> JavaFXMissingTools.runLater(this.getClass(), () -> this.rootNode.getChildren().add((Object)this.skybox)));
    }

    public void addStaticVisual(VisualDefinition visualDefinition) {
        Mesh mesh;
        Node nodeToAdd;
        if (this.staticVisualDefinitionToNodeMap == null) {
            this.staticVisualDefinitionToNodeMap = new HashMap<VisualDefinition, Node>();
            if (this.staticVisualDefinitionToNodeMap.containsKey(visualDefinition)) {
                return;
            }
        }
        if ((nodeToAdd = JavaFXVisualTools.toNode(visualDefinition, null)) instanceof MeshView && (mesh = ((MeshView)nodeToAdd).getMesh()) instanceof TriangleMesh && ((TriangleMesh)mesh).getPoints().size() > 1000000) {
            nodeToAdd.setMouseTransparent(true);
        }
        this.staticVisualDefinitionToNodeMap.put(visualDefinition, nodeToAdd);
        if (this.staticVisualsRoot == null) {
            this.staticVisualsRoot = new Group();
            JavaFXMissingTools.runLater(this.getClass(), () -> {
                this.staticVisualsRoot.getChildren().add((Object)nodeToAdd);
                this.rootNode.getChildren().add((Object)this.staticVisualsRoot);
            });
        } else {
            JavaFXMissingTools.runLater(this.getClass(), () -> this.staticVisualsRoot.getChildren().add((Object)nodeToAdd));
        }
    }

    public void removeStaticVisual(VisualDefinition visualDefinition) {
        if (this.staticVisualDefinitionToNodeMap == null) {
            return;
        }
        if (this.staticVisualsRoot == null) {
            return;
        }
        Node nodeToRemove = this.staticVisualDefinitionToNodeMap.remove(visualDefinition);
        if (nodeToRemove == null) {
            return;
        }
        JavaFXMissingTools.runLater(this.getClass(), () -> this.staticVisualsRoot.getChildren().remove((Object)nodeToRemove));
    }

    @Override
    public void startSession(Session session) {
        List terrainObjectDefinitions = session.getTerrainObjectDefinitions();
        JavaFXMissingTools.runLaterIfNeeded(this.getClass(), () -> {
            for (TerrainObjectDefinition definition : terrainObjectDefinitions) {
                Node nodes = JavaFXVisualTools.collectNodes(definition.getVisualDefinitions(), definition.getResourceClassLoader());
                if (nodes == null) continue;
                this.terrainObjectGraphics.getChildren().add((Object)nodes);
            }
        });
    }

    @Override
    public void stopSession() {
        JavaFXMissingTools.runLaterIfNeeded(this.getClass(), () -> this.terrainObjectGraphics.getChildren().clear());
    }

    @Override
    public boolean isSessionLoaded() {
        return true;
    }

    public Group getRootNode() {
        return this.rootNode;
    }

    public void dispose() {
        if (this.skybox != null) {
            this.skybox.dispose();
            this.skybox = null;
        }
        this.rootNode.getChildren().clear();
        this.terrainObjectGraphics.getChildren().clear();
        if (this.staticVisualsRoot != null) {
            this.staticVisualsRoot.getChildren().clear();
            this.staticVisualsRoot = null;
        }
    }

    private /* synthetic */ void lambda$addWorldCoordinateSystem$0(Node node) {
        this.rootNode.getChildren().add((Object)node);
    }
}

