/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.sliderboard.bcf2000;

import com.jfoenix.controls.JFXToggleNode;
import javafx.beans.property.Property;
import javafx.fxml.FXML;
import javafx.scene.control.Labeled;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.definition.yoSlider.YoButtonDefinition;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.sliderboard.YoBooleanSlider;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.sliderboard.YoVariableSlider;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.sliderboard.bcf2000.YoBCF2000InputController;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.YoManager;
import us.ihmc.scs2.sessionVisualizer.sliderboard.SliderboardVariable;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoBCF2000ButtonController
extends YoBCF2000InputController {
    @FXML
    private VBox rootPane;
    @FXML
    private JFXToggleNode button;
    private SliderboardVariable sliderVariable;
    private YoBooleanSlider yoBooleanSlider;
    private YoManager yoManager;

    public void initialize(SessionVisualizerToolkit toolkit, SliderboardVariable sliderVariable) {
        this.sliderVariable = sliderVariable;
        this.yoManager = toolkit.getYoManager();
        super.initialize(toolkit, (Region)this.rootPane, (Labeled)this.button, YoBoolean.class::isInstance);
        this.button.setDisable(true);
    }

    public void setInput(YoButtonDefinition definition) {
        YoVariable yoVariable;
        if (definition == null) {
            this.setYoVariableInput(null);
            return;
        }
        if (definition.getVariableName() != null) {
            yoVariable = this.yoManager.getRootRegistryDatabase().searchExact(definition.getVariableName());
            if (yoVariable == null) {
                LogTools.warn((String)("Could not find variable for slider: " + definition.getVariableName()));
            }
        } else {
            yoVariable = null;
        }
        this.setYoVariableInput(yoVariable);
    }

    @Override
    public void setYoVariableInput(YoVariable yoVariable) {
        if (this.yoBooleanSlider != null) {
            this.yoBooleanSlider.dispose();
            this.yoBooleanSlider.getYoBooleanProperty().unbind();
        }
        if (yoVariable != null && yoVariable instanceof YoBoolean) {
            this.button.setDisable(false);
            this.yoBooleanSlider = (YoBooleanSlider)YoVariableSlider.newYoVariableSlider(yoVariable, this.yoManager.getLinkedRootRegistry());
            if (this.sliderVariable != null) {
                this.yoBooleanSlider.bindSliderVariable(this.sliderVariable);
            }
            this.yoBooleanSlider.getYoBooleanProperty().bindBooleanProperty((Property<Boolean>)this.button.selectedProperty());
            this.setupYoVariableSlider(this.yoBooleanSlider);
        } else {
            this.clear();
            this.button.setDisable(true);
            this.yoBooleanSlider = null;
        }
    }

    public void close() {
        if (this.yoBooleanSlider != null) {
            this.setYoVariableInput(null);
        }
    }

    public YoButtonDefinition toYoButtonDefinition() {
        YoButtonDefinition definition = new YoButtonDefinition();
        if (this.yoBooleanSlider != null) {
            definition.setVariableName(this.yoBooleanSlider.getYoVariable().getFullNameString());
        }
        return definition;
    }
}

