/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx;

import java.io.IOException;
import java.io.InputStream;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Point3D;
import javafx.scene.Camera;
import javafx.scene.Group;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.transform.Affine;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;

public class Skybox
extends Group {
    private final Translate translate = new Translate();
    private final DoubleProperty size = new SimpleDoubleProperty((Object)this, "size", 100000.0);
    private final Affine backAffine = new Affine();
    private final Affine frontAffine = new Affine();
    private final Affine topAffine = new Affine();
    private final Affine bottomAffine = new Affine();
    private final Affine leftAffine = new Affine();
    private final Affine rightAffine = new Affine();
    private final ImageView topView = new ImageView();
    private final ImageView bottomView = new ImageView();
    private final ImageView leftView = new ImageView();
    private final ImageView rightView = new ImageView();
    private final ImageView backView = new ImageView();
    private final ImageView frontView = new ImageView();
    private final ImageView[] views = new ImageView[]{this.topView, this.leftView, this.backView, this.rightView, this.frontView, this.bottomView};
    private Camera camera;
    private ChangeListener<Transform> cameraMotionListener = (observable, oldValue, newValue) -> {
        this.translate.setX(newValue.getTx());
        this.translate.setY(newValue.getTy());
        this.translate.setZ(newValue.getTz());
    };

    public Skybox() {
        for (ImageView view : this.views) {
            view.setSmooth(true);
            view.setPreserveRatio(true);
            view.fitWidthProperty().bind((ObservableValue)this.size);
            view.fitHeightProperty().bind((ObservableValue)this.size);
        }
        this.updateTransforms(this.size.get());
        this.backView.getTransforms().addAll((Object[])new Transform[]{this.backAffine});
        this.frontView.getTransforms().addAll((Object[])new Transform[]{this.frontAffine});
        this.topView.getTransforms().addAll((Object[])new Transform[]{this.topAffine});
        this.bottomView.getTransforms().addAll((Object[])new Transform[]{this.bottomAffine});
        this.leftView.getTransforms().addAll((Object[])new Transform[]{this.leftAffine});
        this.rightView.getTransforms().addAll((Object[])new Transform[]{this.rightAffine});
        this.getTransforms().add((Object)this.translate);
        this.getChildren().addAll((Object[])this.views);
        this.setMouseTransparent(true);
    }

    private void updateTransforms(double size) {
        this.backAffine.setToIdentity();
        this.backAffine.appendTranslation(-0.5 * size, -0.5 * size, 0.5 * size);
        this.backAffine.appendRotation(90.0, Point3D.ZERO, Rotate.Z_AXIS);
        this.backAffine.appendRotation(-90.0, Point3D.ZERO, Rotate.X_AXIS);
        this.frontAffine.setToIdentity();
        this.frontAffine.appendTranslation(0.5 * size, 0.5 * size, 0.5 * size);
        this.frontAffine.appendRotation(-90.0, Point3D.ZERO, Rotate.Z_AXIS);
        this.frontAffine.appendRotation(-90.0, Point3D.ZERO, Rotate.X_AXIS);
        this.topAffine.setToIdentity();
        this.topAffine.appendTranslation(-0.5 * size, 0.5 * size, 0.5 * size);
        this.topAffine.appendRotation(-90.0, Point3D.ZERO, Rotate.Z_AXIS);
        this.bottomAffine.setToIdentity();
        this.bottomAffine.appendTranslation(0.5 * size, 0.5 * size, -0.5 * size);
        this.bottomAffine.appendRotation(180.0, Point3D.ZERO, Rotate.X_AXIS);
        this.bottomAffine.appendRotation(90.0, Point3D.ZERO, Rotate.Z_AXIS);
        this.leftAffine.setToIdentity();
        this.leftAffine.appendTranslation(-0.5 * size, 0.5 * size, 0.5 * size);
        this.leftAffine.appendRotation(-90.0, Point3D.ZERO, Rotate.X_AXIS);
        this.rightAffine.setToIdentity();
        this.rightAffine.appendTranslation(0.5 * size, -0.5 * size, 0.5 * size);
        this.rightAffine.appendRotation(180.0, Point3D.ZERO, Rotate.Z_AXIS);
        this.rightAffine.appendRotation(-90.0, Point3D.ZERO, Rotate.X_AXIS);
    }

    public void setupSkybox(Image topImage, Image bottomImage, Image leftImage, Image rightImage, Image frontImage, Image backImage) {
        this.backView.setImage(backImage);
        this.frontView.setImage(frontImage);
        this.topView.setImage(topImage);
        this.bottomView.setImage(bottomImage);
        this.leftView.setImage(leftImage);
        this.rightView.setImage(rightImage);
    }

    public void setupSkybox(String directoryPath, String fileExtension) {
        Image topImage = Skybox.loadImage(SessionVisualizerIOTools.getSkyboxResource(directoryPath + "/Up." + fileExtension));
        Image bottomImage = Skybox.loadImage(SessionVisualizerIOTools.getSkyboxResource(directoryPath + "/Down." + fileExtension));
        Image leftImage = Skybox.loadImage(SessionVisualizerIOTools.getSkyboxResource(directoryPath + "/Left." + fileExtension));
        Image rightImage = Skybox.loadImage(SessionVisualizerIOTools.getSkyboxResource(directoryPath + "/Right." + fileExtension));
        Image frontImage = Skybox.loadImage(SessionVisualizerIOTools.getSkyboxResource(directoryPath + "/Front." + fileExtension));
        Image backImage = Skybox.loadImage(SessionVisualizerIOTools.getSkyboxResource(directoryPath + "/Back." + fileExtension));
        this.setupSkybox(topImage, bottomImage, leftImage, rightImage, frontImage, backImage);
    }

    private static Image loadImage(InputStream is) {
        Image image = new Image(is);
        try {
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return image;
    }

    public void setupCloudyCrown() {
        Image topImage = SessionVisualizerIOTools.SKYBOX_TOP_IMAGE;
        Image bottomImage = SessionVisualizerIOTools.SKYBOX_BOTTOM_IMAGE;
        Image leftImage = SessionVisualizerIOTools.SKYBOX_LEFT_IMAGE;
        Image rightImage = SessionVisualizerIOTools.SKYBOX_RIGHT_IMAGE;
        Image frontImage = SessionVisualizerIOTools.SKYBOX_FRONT_IMAGE;
        Image backImage = SessionVisualizerIOTools.SKYBOX_BACK_IMAGE;
        this.setupSkybox(topImage, bottomImage, leftImage, rightImage, frontImage, backImage);
    }

    public void setupCamera(Camera camera) {
        if (this.camera != null) {
            this.camera.localToSceneTransformProperty().removeListener(this.cameraMotionListener);
        }
        this.camera = camera;
        if (camera != null) {
            camera.localToSceneTransformProperty().addListener(this.cameraMotionListener);
        }
    }

    public void setSize(double size) {
        this.size.set(size);
    }

    public double getSize() {
        return this.size.get();
    }

    public DoubleProperty sizeProperty() {
        return this.size;
    }

    public void dispose() {
        this.setupCamera(null);
        for (ImageView view : this.views) {
            view.setImage(null);
        }
    }
}

