/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.session.log;

import java.io.File;
import java.io.IOException;
import javafx.scene.image.Image;
import javafx.scene.image.PixelReader;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import org.bytedeco.javacv.Frame;
import org.bytedeco.javacv.JavaFXFrameConverter;
import us.ihmc.robotDataLogger.Camera;
import us.ihmc.scs2.session.log.MagewellScrubber;
import us.ihmc.scs2.session.log.ProgressConsumer;
import us.ihmc.scs2.sessionVisualizer.jfx.session.log.FrameData;
import us.ihmc.scs2.sessionVisualizer.jfx.session.log.VideoDataReader;

public class MagewellVideoDataReader
implements VideoDataReader {
    private final MagewellScrubber magewellScrubber;
    private final FrameData frameData = new FrameData();

    public MagewellVideoDataReader(Camera camera, File dataDirectory, boolean hasTimeBase) throws IOException {
        this.magewellScrubber = new MagewellScrubber(camera, dataDirectory, hasTimeBase);
    }

    @Override
    public int getImageHeight() {
        return this.magewellScrubber.getMagewellDemuxer().getImageHeight();
    }

    @Override
    public int getImageWidth() {
        return this.magewellScrubber.getMagewellDemuxer().getImageWidth();
    }

    @Override
    public void readVideoFrame(long queryRobotTimestamp) {
        Frame nextFrame = this.magewellScrubber.readVideoFrame(queryRobotTimestamp);
        FrameData copyForWriting = this.frameData;
        copyForWriting.queryRobotTimestamp = queryRobotTimestamp;
        copyForWriting.currentRobotTimestamp = this.magewellScrubber.getCurrentRobotTimestamp();
        copyForWriting.currentVideoTimestamp = this.magewellScrubber.getCurrentVideoTimestamp();
        copyForWriting.currentDemuxerTimestamp = this.magewellScrubber.getMagewellDemuxer().getCurrentPTS();
        this.frameData.frame = this.convertFrameToWritableImage(nextFrame);
    }

    public WritableImage convertFrameToWritableImage(Frame frameToConvert) {
        Image currentImage;
        if (frameToConvert == null) {
            return null;
        }
        try (JavaFXFrameConverter frameConverter = new JavaFXFrameConverter();){
            currentImage = frameConverter.convert(frameToConvert);
        }
        WritableImage writableImage = new WritableImage((int)currentImage.getWidth(), (int)currentImage.getHeight());
        PixelReader pixelReader = currentImage.getPixelReader();
        PixelWriter pixelWriter = writableImage.getPixelWriter();
        int y = 0;
        while ((double)y < currentImage.getHeight()) {
            int x = 0;
            while ((double)x < currentImage.getWidth()) {
                pixelWriter.setArgb(x, y, pixelReader.getArgb(x, y));
                ++x;
            }
            ++y;
        }
        return writableImage;
    }

    @Override
    public void cropVideo(File outputFile, File timestampFile, long startTimestamp, long endTimestamp, ProgressConsumer progressConsumer) throws IOException {
        this.magewellScrubber.cropVideo(outputFile, timestampFile, startTimestamp, endTimestamp, progressConsumer);
    }

    @Override
    public String getName() {
        return this.magewellScrubber.getName();
    }

    @Override
    public Camera getCamera() {
        return this.magewellScrubber.getCamera();
    }

    @Override
    public FrameData pollCurrentFrame() {
        return this.frameData;
    }

    @Override
    public int getCurrentIndex() {
        return this.magewellScrubber.getCurrentIndex();
    }

    @Override
    public boolean replacedRobotTimestampsContainsIndex(int index) {
        return this.magewellScrubber.replacedRobotTimestampsContainsIndex(index);
    }
}

