/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.managers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.WeakList;

public class ReferenceFrameWrapper {
    private static final RigidBodyTransformReadOnly IDENTITY = new RigidBodyTransform();
    private final String name;
    private String fullName;
    private List<String> namespace;
    private String uniqueName;
    private String uniqueShortName;
    private ReferenceFrame referenceFrame;
    private final WeakList<Runnable> changeListeners = new WeakList();

    public ReferenceFrameWrapper(String name, String fullName) {
        this(name, fullName, null);
    }

    public ReferenceFrameWrapper(ReferenceFrame referenceFrame) {
        this(referenceFrame.getName(), referenceFrame.getNameId(), referenceFrame);
    }

    private ReferenceFrameWrapper(String name, String fullName, ReferenceFrame referenceFrame) {
        this.name = name;
        this.fullName = fullName;
        this.referenceFrame = referenceFrame;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public String getUniqueShortName() {
        if (this.uniqueShortName == null) {
            int lastSeparatorIndex;
            int firstSeparatorIndex = this.uniqueName.indexOf(".");
            this.uniqueShortName = firstSeparatorIndex != (lastSeparatorIndex = this.uniqueName.lastIndexOf(".")) ? this.uniqueName.substring(0, firstSeparatorIndex) + "..." + this.uniqueName.substring(lastSeparatorIndex + 1) : this.uniqueName;
        }
        return this.uniqueShortName;
    }

    public List<String> getNamespace() {
        if (this.namespace == null) {
            this.namespace = Arrays.asList(this.fullName.split(":"));
            this.namespace = this.namespace.subList(0, this.namespace.size() - 1);
        }
        return this.namespace;
    }

    public ReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }

    public void setUniqueName(String uniqueName) {
        this.uniqueName = uniqueName;
        this.uniqueShortName = null;
    }

    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        if (referenceFrame == this.referenceFrame) {
            return;
        }
        if (!Objects.equals(this.name, referenceFrame.getName())) {
            throw new IllegalArgumentException("The name of the reference frame does not match the name of this wrapper: " + this.name + " vs " + referenceFrame.getName());
        }
        this.referenceFrame = referenceFrame;
        this.fullName = referenceFrame.getNameId();
        this.namespace = null;
        this.changeListeners.forEach(Runnable::run);
    }

    public boolean isDefined() {
        return this.referenceFrame != null;
    }

    public boolean isRootFrame() {
        return !this.isDefined() || this.referenceFrame.isRootFrame();
    }

    public RigidBodyTransformReadOnly getTransformToRoot() {
        if (this.referenceFrame == null) {
            return IDENTITY;
        }
        return this.referenceFrame.getTransformToRoot();
    }

    public <T extends Transformable> T transformFromThisToDesiredFrame(ReferenceFrameWrapper desiredFrame, T transformable) {
        if (this.referenceFrame != null && desiredFrame.referenceFrame != null) {
            this.referenceFrame.transformFromThisToDesiredFrame(desiredFrame.referenceFrame, transformable);
        }
        return transformable;
    }

    public <T extends Transformable> T transformToRootFrame(T transformable) {
        if (this.referenceFrame != null && !this.referenceFrame.isRootFrame()) {
            this.referenceFrame.transformFromThisToDesiredFrame(this.referenceFrame.getRootFrame(), transformable);
        }
        return transformable;
    }

    public List<ReferenceFrameWrapper> collectSubtree() {
        if (this.referenceFrame == null) {
            return List.of(this);
        }
        return ReferenceFrameWrapper.collectSubtree(this, new ArrayList());
    }

    private static <T extends Collection<ReferenceFrameWrapper>> T collectSubtree(ReferenceFrameWrapper start, T collectionToPack) {
        collectionToPack.add((ReferenceFrameWrapper)start);
        if (start.referenceFrame != null) {
            for (int i = 0; i < start.referenceFrame.getNumberOfChildren(); ++i) {
                ReferenceFrame child = start.referenceFrame.getChild(i);
                if (child == null) continue;
                ReferenceFrameWrapper.collectSubtree(new ReferenceFrameWrapper(child), collectionToPack);
            }
        }
        return collectionToPack;
    }

    public void clearChildren() {
        if (this.referenceFrame != null) {
            this.referenceFrame.clearChildren();
        }
    }

    public void addChangeListener(Runnable listener) {
        this.changeListeners.add(listener);
    }

    public void removeChangeListener(Runnable listener) {
        this.changeListeners.remove(listener);
    }

    public String toString() {
        return "%s{name='%s', fullName='%s'}".formatted(this.getClass().getSimpleName(), this.name, this.fullName);
    }
}

