/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.graphic2D;

import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import us.ihmc.scs2.definition.yoComposite.YoCompositeDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphic2DDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicLine2DDefinition;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.editor.YoCompositeEditorPaneController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.graphic2D.YoGraphicFX2DEditorController;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.Tuple2DProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicTools;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoLineFX2D;

public class YoLineFX2DEditorController
extends YoGraphicFX2DEditorController<YoLineFX2D> {
    @FXML
    private YoCompositeEditorPaneController originEditorController;
    @FXML
    private YoCompositeEditorPaneController directionEditorController;
    @FXML
    private YoCompositeEditorPaneController destinationEditorController;
    @FXML
    private RadioButton directionRadioButton;
    @FXML
    private RadioButton destinationRadioButton;
    private Tuple2DProperty directionProperty = new Tuple2DProperty(null, 0.0, 1.0);
    private Tuple2DProperty destinationProperty = new Tuple2DProperty(null, 0.0, 0.0);
    private YoGraphicLine2DDefinition definitionBeforeEdits;

    @Override
    public void initialize(SessionVisualizerToolkit toolkit, YoLineFX2D yoGraphicToEdit) {
        super.initialize(toolkit, yoGraphicToEdit);
        this.definitionBeforeEdits = YoGraphicTools.toYoGraphicLine2DDefinition(yoGraphicToEdit);
        yoGraphicToEdit.visibleProperty().addListener((observable, oldValue, newValue) -> this.definitionBeforeEdits.setVisible(newValue.booleanValue()));
        new ToggleGroup().getToggles().addAll((Object[])new Toggle[]{this.directionRadioButton, this.destinationRadioButton});
        this.directionEditorController.getMainPane().disableProperty().bind((ObservableValue)this.destinationRadioButton.selectedProperty());
        this.destinationEditorController.getMainPane().disableProperty().bind((ObservableValue)this.directionRadioButton.selectedProperty());
        this.directionProperty = yoGraphicToEdit.getDirection() != null ? new Tuple2DProperty(yoGraphicToEdit.getDirection()) : new Tuple2DProperty(toolkit.getReferenceFrameManager().getWorldFrame(), 0.0, 1.0);
        this.destinationProperty = yoGraphicToEdit.getDestination() != null ? new Tuple2DProperty(yoGraphicToEdit.getDestination()) : new Tuple2DProperty(toolkit.getReferenceFrameManager().getWorldFrame(), 0.0, 1.0);
        this.directionRadioButton.selectedProperty().addListener((o, oldValue, newValue) -> this.updateSelection((boolean)newValue, yoGraphicToEdit));
        this.setupTuple2DPropertyEditor(this.originEditorController, "Origin", true, yoGraphicToEdit.getOrigin());
        this.setupTuple2DPropertyEditor(this.directionEditorController, "Direction", true, this.directionProperty);
        this.setupTuple2DPropertyEditor(this.destinationEditorController, "Desintation", true, this.destinationProperty);
        this.updateSelection(this.directionRadioButton.isSelected(), yoGraphicToEdit);
        this.resetFields();
    }

    private void updateSelection(boolean isDirectionSelected, YoLineFX2D yoGraphicToEdit) {
        if (isDirectionSelected) {
            yoGraphicToEdit.setDirection(this.directionProperty);
            yoGraphicToEdit.setDestination(null);
        } else {
            yoGraphicToEdit.setDirection(null);
            yoGraphicToEdit.setDestination(this.destinationProperty);
        }
    }

    @Override
    protected <T> void updateHasChangesPendingProperty(ObservableValue<? extends T> observable, T oldValue, T newValue) {
        this.hasChangesPendingProperty.set(!this.definitionBeforeEdits.equals((Object)YoGraphicTools.toYoGraphicLine2DDefinition((YoLineFX2D)this.yoGraphicToEdit)));
    }

    @Override
    public void resetFields() {
        this.originEditorController.setInput((YoCompositeDefinition)this.definitionBeforeEdits.getOrigin());
        if (this.definitionBeforeEdits.getDirection() != null) {
            this.directionEditorController.setInput((YoCompositeDefinition)this.definitionBeforeEdits.getDirection());
            this.directionRadioButton.setSelected(true);
        } else {
            this.destinationEditorController.setInput((YoCompositeDefinition)this.definitionBeforeEdits.getDestination());
            this.destinationRadioButton.setSelected(true);
        }
        this.styleEditorController.setInput((YoGraphic2DDefinition)this.definitionBeforeEdits);
        this.nameEditorController.setInput(this.definitionBeforeEdits.getName(), ((YoLineFX2D)this.yoGraphicToEdit).getNamespace());
    }

    @Override
    public void saveChanges() {
        this.definitionBeforeEdits = YoGraphicTools.toYoGraphicLine2DDefinition((YoLineFX2D)this.yoGraphicToEdit);
        this.hasChangesPendingProperty.set(false);
    }
}

