/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.camera;

import java.util.function.Predicate;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableDoubleValue;
import javafx.event.EventHandler;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.transform.Affine;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import org.apache.commons.lang3.mutable.MutableBoolean;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.tools.EuclidCoreFactories;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.camera.CameraControlMode;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.Tuple3DProperty;

public class CameraOrbitHandler {
    private final Affine cameraPose = new Affine();
    private final Affine offset = new Affine();
    private final Property<CameraControlMode> controlMode = new SimpleObjectProperty((Object)this, "controlMode", (Object)CameraControlMode.Orbital);
    private final DoubleProperty latitude = new SimpleDoubleProperty((Object)this, "latitude", 0.0);
    private final DoubleProperty longitude = new SimpleDoubleProperty((Object)this, "longitude", 0.0);
    private final DoubleProperty roll = new SimpleDoubleProperty((Object)this, "roll", 0.0);
    private final BooleanProperty keepRotationLeveled = new SimpleBooleanProperty((Object)this, "keepRotationLeveled", true);
    private final ObjectProperty<Predicate<MouseEvent>> fastModifierPredicate = new SimpleObjectProperty((Object)this, "fastModifierPredicate", null);
    private final DoubleProperty slowModifier = new SimpleDoubleProperty((Object)this, "slowModifier", 0.005);
    private final DoubleProperty fastModifier = new SimpleDoubleProperty((Object)this, "fastModifier", 0.01);
    private final DoubleProperty rollModifier = new SimpleDoubleProperty((Object)this, "rollModifier", 0.005);
    private final ObjectProperty<MouseButton> rotationMouseButton = new SimpleObjectProperty((Object)this, "rotationMouseButton", (Object)MouseButton.PRIMARY);
    private final BooleanProperty restrictLatitude = new SimpleBooleanProperty((Object)this, "restrictLatitude", true);
    private final DoubleProperty minLatitude = new SimpleDoubleProperty((Object)this, "minLatitude", -1.5607963267948965);
    private final DoubleProperty maxLatitude = new SimpleDoubleProperty((Object)this, "maxLatitude", 1.5607963267948965);
    private final DoubleProperty distance = new SimpleDoubleProperty((Object)this, "distance", 10.0);
    private final DoubleProperty minDistance = new SimpleDoubleProperty((Object)this, "minDistance", 0.1);
    private final DoubleProperty maxDistance = new SimpleDoubleProperty((Object)this, "maxDistance", 100.0);
    private final DoubleProperty x = new SimpleDoubleProperty((Object)this, "xLocal", 0.0);
    private final DoubleProperty y = new SimpleDoubleProperty((Object)this, "yLocal", 0.0);
    private final DoubleProperty z = new SimpleDoubleProperty((Object)this, "zLocal", 0.0);
    private DoubleProperty xWorld;
    private DoubleProperty yWorld;
    private DoubleProperty zWorld;
    private final DoubleProperty distanceModifier = new SimpleDoubleProperty((Object)this, "distanceModifier", -0.1);
    private final Vector3DReadOnly down;
    private final Vector3DReadOnly forward;
    private boolean disableCameraPoseAutoUpdate = false;

    public CameraOrbitHandler(Vector3DReadOnly up, Vector3DReadOnly forward) {
        Vector3D left = new Vector3D();
        left.cross((Tuple3DReadOnly)up, (Tuple3DReadOnly)forward);
        if (!MathTools.epsilonEquals((double)left.norm(), (double)1.0, (double)1.0E-5)) {
            throw new RuntimeException("The vectors up and forward must be orthogonal. Received: up = " + String.valueOf(up) + ", forward = " + String.valueOf(forward));
        }
        this.forward = forward;
        this.down = EuclidCoreFactories.newNegativeLinkedVector3D((Vector3DReadOnly)up);
        this.computeOffset();
        this.longitude.addListener((o, oldValue, newValue) -> {
            if (this.disableCameraPoseAutoUpdate) {
                return;
            }
            if (this.controlMode.getValue() == CameraControlMode.Orbital) {
                this.setOrbit(Double.NaN, newValue.doubleValue(), Double.NaN, Double.NaN);
            } else if (this.controlMode.getValue() == CameraControlMode.LevelOrbital) {
                this.setLevelOrbit(Double.NaN, newValue.doubleValue(), Double.NaN, Double.NaN);
            } else if (!this.longitude.isBound()) {
                boolean disablePrevious = this.disableCameraPoseAutoUpdate;
                this.disableCameraPoseAutoUpdate = true;
                this.longitude.setValue(oldValue);
                this.disableCameraPoseAutoUpdate = disablePrevious;
            }
        });
        this.latitude.addListener((o, oldValue, newValue) -> {
            if (this.disableCameraPoseAutoUpdate) {
                return;
            }
            if (this.controlMode.getValue() == CameraControlMode.Orbital) {
                this.setOrbit(Double.NaN, Double.NaN, newValue.doubleValue(), Double.NaN);
            } else if (!this.latitude.isBound()) {
                boolean disablePrevious = this.disableCameraPoseAutoUpdate;
                this.disableCameraPoseAutoUpdate = true;
                this.latitude.setValue(oldValue);
                this.disableCameraPoseAutoUpdate = disablePrevious;
            }
        });
        this.roll.addListener((o, oldValue, newValue) -> {
            if (!this.disableCameraPoseAutoUpdate) {
                this.setOrbit(Double.NaN, Double.NaN, Double.NaN, newValue.doubleValue());
            }
        });
        this.x.addListener((o, oldValue, newValue) -> {
            if (this.disableCameraPoseAutoUpdate) {
                return;
            }
            if (this.controlMode.getValue() == CameraControlMode.Position) {
                this.setPosition(newValue.doubleValue(), Double.NaN, Double.NaN, Double.NaN);
            } else if (!this.isXBound()) {
                boolean disablePrevious = this.disableCameraPoseAutoUpdate;
                this.disableCameraPoseAutoUpdate = true;
                this.x.set(oldValue.doubleValue());
                this.disableCameraPoseAutoUpdate = disablePrevious;
            }
        });
        this.y.addListener((o, oldValue, newValue) -> {
            if (this.disableCameraPoseAutoUpdate) {
                return;
            }
            if (this.controlMode.getValue() == CameraControlMode.Position) {
                this.setPosition(Double.NaN, newValue.doubleValue(), Double.NaN, Double.NaN);
            } else if (!this.isYBound()) {
                boolean disablePrevious = this.disableCameraPoseAutoUpdate;
                this.disableCameraPoseAutoUpdate = true;
                this.y.setValue(oldValue);
                this.disableCameraPoseAutoUpdate = disablePrevious;
            }
        });
        this.z.addListener((o, oldValue, newValue) -> {
            if (this.disableCameraPoseAutoUpdate) {
                return;
            }
            if (this.controlMode.getValue() == CameraControlMode.Position) {
                this.setPosition(Double.NaN, Double.NaN, newValue.doubleValue(), Double.NaN);
            } else if (this.controlMode.getValue() == CameraControlMode.LevelOrbital) {
                this.setLevelOrbit(Double.NaN, Double.NaN, newValue.doubleValue(), Double.NaN);
            } else if (!this.isZBound()) {
                boolean disablePrevious = this.disableCameraPoseAutoUpdate;
                this.disableCameraPoseAutoUpdate = true;
                this.z.setValue(oldValue);
                this.disableCameraPoseAutoUpdate = disablePrevious;
            }
        });
        this.distance.addListener((o, oldValue, newValue) -> {
            if (this.disableCameraPoseAutoUpdate) {
                return;
            }
            if (this.controlMode.getValue() == CameraControlMode.Orbital) {
                this.setOrbit(newValue.doubleValue(), Double.NaN, Double.NaN, Double.NaN);
            } else if (this.controlMode.getValue() == CameraControlMode.LevelOrbital) {
                this.setLevelOrbit(newValue.doubleValue(), Double.NaN, Double.NaN, Double.NaN);
            } else if (!this.distance.isBound()) {
                boolean disablePrevious = this.disableCameraPoseAutoUpdate;
                this.disableCameraPoseAutoUpdate = true;
                this.distance.setValue(oldValue);
                this.disableCameraPoseAutoUpdate = disablePrevious;
            }
        });
    }

    private boolean isXBound() {
        return this.x.isBound() || this.xWorld != null && this.xWorld.isBound();
    }

    private boolean isYBound() {
        return this.y.isBound() || this.yWorld != null && this.yWorld.isBound();
    }

    private boolean isZBound() {
        return this.z.isBound() || this.zWorld != null && this.zWorld.isBound();
    }

    private void computeOffset() {
        Vector3D cameraXAxis = new Vector3D();
        cameraXAxis.cross((Tuple3DReadOnly)this.down, (Tuple3DReadOnly)this.forward);
        RotationMatrix rotationOffset = new RotationMatrix();
        rotationOffset.setColumns((Tuple3DReadOnly)cameraXAxis, (Tuple3DReadOnly)this.down, (Tuple3DReadOnly)this.forward);
        JavaFXMissingTools.convertRotationMatrixToAffine((RotationMatrixReadOnly)rotationOffset, this.offset);
    }

    public EventHandler<MouseEvent> createMouseEventHandler(final ReadOnlyDoubleProperty sceneWidthProperty, final ReadOnlyDoubleProperty sceneHeightProperty) {
        return new EventHandler<MouseEvent>(){
            private final Point2D oldMouseLocation = new Point2D();

            public void handle(MouseEvent event) {
                double rollShift;
                if (event.getButton() != CameraOrbitHandler.this.rotationMouseButton.get()) {
                    return;
                }
                if (event.isStillSincePress()) {
                    return;
                }
                if (event.getEventType() == MouseEvent.MOUSE_PRESSED) {
                    this.oldMouseLocation.set(event.getSceneX(), event.getSceneY());
                    return;
                }
                if (event.getEventType() != MouseEvent.MOUSE_DRAGGED) {
                    return;
                }
                Point2D centerLocation = new Point2D();
                Point2D newMouseLocation = new Point2D();
                centerLocation.set(sceneWidthProperty.get() / 2.0, sceneHeightProperty.get() / 2.0);
                newMouseLocation.set(event.getSceneX(), event.getSceneY());
                double modifier = CameraOrbitHandler.this.fastModifierPredicate.get() == null || !((Predicate)CameraOrbitHandler.this.fastModifierPredicate.get()).test(event) ? CameraOrbitHandler.this.slowModifier.get() : CameraOrbitHandler.this.fastModifier.get();
                Vector2D drag = new Vector2D();
                drag.sub((Tuple2DReadOnly)newMouseLocation, (Tuple2DReadOnly)this.oldMouseLocation);
                if (CameraOrbitHandler.this.keepRotationLeveled.get()) {
                    rollShift = Double.NaN;
                } else {
                    Vector2D centerToMouseLocation = new Vector2D();
                    centerToMouseLocation.sub((Tuple2DReadOnly)newMouseLocation, (Tuple2DReadOnly)centerLocation);
                    rollShift = modifier * CameraOrbitHandler.this.rollModifier.get() * drag.cross((Tuple2DReadOnly)centerToMouseLocation);
                }
                drag.scale(modifier);
                switch ((CameraControlMode)((Object)CameraOrbitHandler.this.controlMode.getValue())) {
                    case Position: {
                        double dxy = Math.cos(CameraOrbitHandler.this.latitude.get() + drag.getY()) * CameraOrbitHandler.this.distance.get();
                        CameraOrbitHandler.this.setPosition(-Math.cos(CameraOrbitHandler.this.longitude.get() - drag.getX()) * dxy, -Math.sin(CameraOrbitHandler.this.longitude.get() - drag.getX()) * dxy, Math.sin(CameraOrbitHandler.this.latitude.get() + drag.getY()) * CameraOrbitHandler.this.distance.get(), CameraOrbitHandler.this.roll.get() + rollShift);
                        break;
                    }
                    case Orbital: {
                        CameraOrbitHandler.this.setOrbit(Double.NaN, CameraOrbitHandler.this.longitude.get() - drag.getX(), CameraOrbitHandler.this.latitude.get() + drag.getY(), CameraOrbitHandler.this.roll.get() + rollShift);
                        break;
                    }
                    case LevelOrbital: {
                        CameraOrbitHandler.this.setLevelOrbit(Double.NaN, CameraOrbitHandler.this.longitude.get() - drag.getX(), CameraOrbitHandler.this.z.get() + Math.sin(drag.getY()) * CameraOrbitHandler.this.distance.get(), CameraOrbitHandler.this.roll.get() + rollShift);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unexpected value: " + String.valueOf(CameraOrbitHandler.this.controlMode.getValue()));
                    }
                }
                this.oldMouseLocation.set(newMouseLocation);
            }
        };
    }

    public EventHandler<ScrollEvent> createScrollEventHandler() {
        return new EventHandler<ScrollEvent>(){

            public void handle(ScrollEvent event) {
                if (CameraOrbitHandler.this.distance.isBound()) {
                    return;
                }
                double direction = Math.signum(event.getDeltaY());
                double newDistance = CameraOrbitHandler.this.distance.get() + direction * CameraOrbitHandler.this.distance.get() * CameraOrbitHandler.this.distanceModifier.get();
                switch ((CameraControlMode)((Object)CameraOrbitHandler.this.controlMode.getValue())) {
                    case Position: {
                        newDistance = MathTools.clamp((double)newDistance, (double)CameraOrbitHandler.this.minDistance.get(), (double)CameraOrbitHandler.this.maxDistance.get());
                        double scale = newDistance / CameraOrbitHandler.this.distance.get();
                        CameraOrbitHandler.this.setPosition(CameraOrbitHandler.this.x.get() * scale, CameraOrbitHandler.this.y.get() * scale, CameraOrbitHandler.this.z.get() * scale, Double.NaN);
                        break;
                    }
                    case Orbital: {
                        CameraOrbitHandler.this.setOrbit(newDistance, Double.NaN, Double.NaN, Double.NaN);
                        break;
                    }
                    case LevelOrbital: {
                        newDistance = MathTools.clamp((double)newDistance, (double)CameraOrbitHandler.this.minDistance.get(), (double)CameraOrbitHandler.this.maxDistance.get());
                        double newHeight = CameraOrbitHandler.this.z.get() + (newDistance - CameraOrbitHandler.this.distance.get()) * Math.sin(CameraOrbitHandler.this.latitude.get());
                        CameraOrbitHandler.this.setLevelOrbit(newDistance, Double.NaN, newHeight, Double.NaN);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unexpected value: " + String.valueOf(CameraOrbitHandler.this.controlMode.getValue()));
                    }
                }
            }
        };
    }

    public void rotate(double deltaLongitude, double deltaLatitude, double deltaRoll) {
        this.rotate(deltaLongitude, deltaLatitude, deltaRoll, false);
    }

    public Vector3DReadOnly rotate(double deltaLongitude, double deltaLatitude, double deltaRoll, boolean computeFocalPointShift) {
        return this.setRotation(this.longitude.get() + deltaLongitude, this.latitude.get() + deltaLatitude, this.roll.get() + deltaRoll, computeFocalPointShift);
    }

    public void setPosition(Point3DReadOnly position, double roll) {
        this.setPosition(position.getX(), position.getY(), position.getZ(), roll);
    }

    public void setPosition(double x, double y, double z, double roll) {
        if (this.distance.isBound()) {
            LogTools.error((String)"Cannot set position, distance coordinate is bound.");
            return;
        }
        if (this.longitude.isBound()) {
            LogTools.error((String)"Cannot set position, longitude coordinate is bound.");
            return;
        }
        if (this.latitude.isBound()) {
            LogTools.error((String)"Cannot set position, latitude coordinate is bound.");
            return;
        }
        this.disableCameraPoseAutoUpdate = true;
        if (!Double.isFinite(x) || this.isXBound()) {
            x = this.x.get();
        } else {
            this.x.set(x);
        }
        if (!Double.isFinite(y) || this.isYBound()) {
            y = this.y.get();
        } else {
            this.y.set(y);
        }
        if (!Double.isFinite(z) || this.isZBound()) {
            z = this.z.get();
        } else {
            this.z.set(z);
        }
        double distance = EuclidCoreTools.norm((double)x, (double)y, (double)z);
        double longitude = Math.atan2(-y, -x);
        double latitude = Math.atan(z / EuclidCoreTools.norm((double)x, (double)y));
        this.distance.set(distance);
        this.longitude.set(longitude);
        this.latitude.set(latitude);
        if (this.keepRotationLeveled.get() && !this.roll.isBound()) {
            roll = 0.0;
            this.roll.set(0.0);
        } else if (Double.isFinite(roll) && !this.roll.isBound()) {
            roll = EuclidCoreTools.trimAngleMinusPiToPi((double)roll);
            this.roll.set(roll);
        } else {
            roll = this.roll.get();
        }
        Affine newPose = new Affine();
        newPose.append((Transform)this.offset);
        newPose.append((Transform)new Rotate(Math.toDegrees(-longitude), Rotate.Y_AXIS));
        newPose.append((Transform)new Rotate(Math.toDegrees(-latitude), Rotate.X_AXIS));
        if (roll != 0.0) {
            newPose.append((Transform)new Rotate(Math.toDegrees(roll), Rotate.Z_AXIS));
        }
        newPose.setTx(x);
        newPose.setTy(y);
        newPose.setTz(z);
        this.cameraPose.setToTransform((Transform)newPose);
        this.disableCameraPoseAutoUpdate = false;
    }

    public void setRotation(double longitude, double latitude, double roll) {
        this.setRotation(longitude, latitude, roll, false);
    }

    public Vector3DReadOnly setRotation(double longitude, double latitude, double roll, boolean computeFocalPointShift) {
        return this.setOrbit(Double.NaN, longitude, latitude, roll, computeFocalPointShift);
    }

    public void setOrbit(double distance, double longitude, double latitude, double roll) {
        this.setOrbit(distance, longitude, latitude, roll, false);
    }

    public Vector3DReadOnly setOrbit(double distance, double longitude, double latitude, double roll, boolean computeFocalPointShift) {
        if (this.isXBound()) {
            LogTools.error((String)"Cannot set orbit, x coordinate is bound.");
            return EuclidCoreTools.zeroVector3D;
        }
        if (this.isYBound()) {
            LogTools.error((String)"Cannot set orbit, y coordinate is bound.");
            return EuclidCoreTools.zeroVector3D;
        }
        if (this.isZBound()) {
            LogTools.error((String)"Cannot set orbit, z coordinate is bound.");
            return EuclidCoreTools.zeroVector3D;
        }
        this.disableCameraPoseAutoUpdate = true;
        if (Double.isFinite(distance) && !this.distance.isBound()) {
            distance = MathTools.clamp((double)distance, (double)this.minDistance.get(), (double)this.maxDistance.get());
            this.distance.set(distance);
        } else {
            distance = this.distance.get();
        }
        if (Double.isFinite(latitude) && !this.latitude.isBound()) {
            latitude = this.restrictLatitude.get() ? MathTools.clamp((double)latitude, (double)this.minLatitude.get(), (double)this.maxLatitude.get()) : MathTools.clamp((double)latitude, (double)1.5707963267948966);
            this.latitude.set(latitude);
        } else {
            latitude = this.latitude.get();
        }
        if (Double.isFinite(longitude) && !this.longitude.isBound()) {
            longitude = EuclidCoreTools.trimAngleMinusPiToPi((double)longitude);
            this.longitude.set(longitude);
        } else {
            longitude = this.longitude.get();
        }
        if (this.keepRotationLeveled.get() && !this.roll.isBound()) {
            roll = 0.0;
            this.roll.set(0.0);
        } else if (Double.isFinite(roll) && !this.roll.isBound()) {
            roll = EuclidCoreTools.trimAngleMinusPiToPi((double)roll);
            this.roll.set(roll);
        } else {
            roll = this.roll.get();
        }
        Vector3D focalPointTranslation = null;
        if (computeFocalPointShift) {
            focalPointTranslation = new Vector3D(this.cameraPose.getTx(), this.cameraPose.getTy(), this.cameraPose.getTz());
        }
        Affine newPose = new Affine();
        newPose.append((Transform)this.offset);
        newPose.append((Transform)new Rotate(Math.toDegrees(-longitude), Rotate.Y_AXIS));
        newPose.append((Transform)new Rotate(Math.toDegrees(-latitude), Rotate.X_AXIS));
        if (roll != 0.0) {
            newPose.append((Transform)new Rotate(Math.toDegrees(roll), Rotate.Z_AXIS));
        }
        newPose.setTx(-distance * newPose.getMxz());
        newPose.setTy(-distance * newPose.getMyz());
        newPose.setTz(-distance * newPose.getMzz());
        this.cameraPose.setToTransform((Transform)newPose);
        if (computeFocalPointShift) {
            focalPointTranslation.sub(this.cameraPose.getTx(), this.cameraPose.getTy(), this.cameraPose.getTz());
        }
        this.x.set(this.cameraPose.getTx());
        this.y.set(this.cameraPose.getTy());
        this.z.set(this.cameraPose.getTz());
        this.disableCameraPoseAutoUpdate = false;
        return focalPointTranslation;
    }

    public void setLevelOrbit(double distance, double longitude, double height, double roll) {
        this.setLevelOrbit(distance, longitude, height, roll, false);
    }

    public Vector3DReadOnly setLevelOrbit(double distance, double longitude, double height, double roll, boolean computeFocalPointShift) {
        if (this.isXBound()) {
            LogTools.error((String)"Cannot set level-orbit, x coordinate is bound.");
            return EuclidCoreTools.zeroVector3D;
        }
        if (this.isYBound()) {
            LogTools.error((String)"Cannot set level-orbit, y coordinate is bound.");
            return EuclidCoreTools.zeroVector3D;
        }
        if (this.latitude.isBound()) {
            LogTools.error((String)"Cannot set level-orbit, latitude coordinate is bound.");
            return EuclidCoreTools.zeroVector3D;
        }
        this.disableCameraPoseAutoUpdate = true;
        if (Double.isFinite(distance) && !this.distance.isBound()) {
            distance = MathTools.clamp((double)distance, (double)this.minDistance.get(), (double)this.maxDistance.get());
            this.distance.set(distance);
        } else {
            distance = this.distance.get();
        }
        if (!Double.isFinite(height) || this.isZBound()) {
            height = this.z.get();
            if (!this.distance.isBound()) {
                distance = this.restrictLatitude.get() ? (height > 0.0 ? Math.max(distance, height / Math.sin(this.maxLatitude.get())) : Math.max(distance, height / Math.sin(this.minLatitude.get()))) : Math.max(distance, height);
                this.distance.set(distance);
            }
        } else {
            if (this.restrictLatitude.get()) {
                height = MathTools.clamp((double)height, (double)(Math.sin(this.minLatitude.get()) * distance), (double)(Math.sin(this.maxLatitude.get()) * distance));
            }
            this.z.set(height);
        }
        double latitude = Math.asin(MathTools.clamp((double)(height / distance), (double)1.0));
        this.latitude.set(latitude);
        if (Double.isFinite(longitude) && !this.longitude.isBound()) {
            longitude = EuclidCoreTools.trimAngleMinusPiToPi((double)longitude);
            this.longitude.set(longitude);
        } else {
            longitude = this.longitude.get();
        }
        if (this.keepRotationLeveled.get() && !this.roll.isBound()) {
            roll = 0.0;
            this.roll.set(0.0);
        } else if (Double.isFinite(roll) && !this.roll.isBound()) {
            roll = EuclidCoreTools.trimAngleMinusPiToPi((double)roll);
            this.roll.set(roll);
        } else {
            roll = this.roll.get();
        }
        Vector3D focalPointTranslation = null;
        if (computeFocalPointShift) {
            focalPointTranslation = new Vector3D(this.cameraPose.getTx(), this.cameraPose.getTy(), this.cameraPose.getTz());
        }
        Affine newPose = new Affine();
        newPose.append((Transform)this.offset);
        newPose.append((Transform)new Rotate(Math.toDegrees(-longitude), Rotate.Y_AXIS));
        newPose.append((Transform)new Rotate(Math.toDegrees(-latitude), Rotate.X_AXIS));
        if (roll != 0.0) {
            newPose.append((Transform)new Rotate(Math.toDegrees(roll), Rotate.Z_AXIS));
        }
        newPose.setTx(-distance * newPose.getMxz());
        newPose.setTy(-distance * newPose.getMyz());
        newPose.setTz(-distance * newPose.getMzz());
        this.cameraPose.setToTransform((Transform)newPose);
        if (computeFocalPointShift) {
            focalPointTranslation.sub(this.cameraPose.getTx(), this.cameraPose.getTy(), this.cameraPose.getTz());
        }
        this.x.set(this.cameraPose.getTx());
        this.y.set(this.cameraPose.getTy());
        this.disableCameraPoseAutoUpdate = false;
        return focalPointTranslation;
    }

    public Vector3DReadOnly computeFocalPointShift(double deltaDistance, double deltaLongitude, double deltaLatitude, double deltaRoll) {
        if (!Double.isFinite(deltaDistance)) {
            deltaDistance = 0.0;
        }
        if (!Double.isFinite(deltaLongitude)) {
            deltaLongitude = 0.0;
        }
        if (!Double.isFinite(deltaLatitude)) {
            deltaLatitude = 0.0;
        }
        if (!Double.isFinite(deltaRoll)) {
            deltaRoll = 0.0;
        }
        if (deltaDistance == 0.0 && deltaLongitude == 0.0 && deltaLatitude == 0.0) {
            return EuclidCoreTools.zeroVector3D;
        }
        double distance = deltaDistance + this.distance.get();
        double longitude = deltaLongitude + this.longitude.get();
        double latitude = deltaLatitude + this.latitude.get();
        double roll = deltaRoll + this.roll.get();
        Affine newPose = new Affine();
        newPose.append((Transform)this.offset);
        newPose.append((Transform)new Rotate(Math.toDegrees(-longitude), Rotate.Y_AXIS));
        newPose.append((Transform)new Rotate(Math.toDegrees(-latitude), Rotate.X_AXIS));
        if (roll != 0.0) {
            newPose.append((Transform)new Rotate(Math.toDegrees(roll), Rotate.Z_AXIS));
        }
        newPose.setTx(-distance * newPose.getMxz());
        newPose.setTy(-distance * newPose.getMyz());
        newPose.setTz(-distance * newPose.getMzz());
        Vector3D focalPointTranslation = new Vector3D(this.cameraPose.getTx(), this.cameraPose.getTy(), this.cameraPose.getTz());
        focalPointTranslation.sub(newPose.getTx(), newPose.getTy(), newPose.getTz());
        return focalPointTranslation;
    }

    public Tuple3DProperty createCameraWorldCoordinates(ObservableDoubleValue xOffset, ObservableDoubleValue yOffset, ObservableDoubleValue zOffset) {
        if (this.xWorld != null) {
            return new Tuple3DProperty(this.xWorld, this.yWorld, this.zWorld);
        }
        this.xWorld = new SimpleDoubleProperty((Object)this, "xWorld", 0.0);
        this.yWorld = new SimpleDoubleProperty((Object)this, "yWorld", 0.0);
        this.zWorld = new SimpleDoubleProperty((Object)this, "zWorld", 0.0);
        DoubleProperty[] cameraWorldCoordinates = new DoubleProperty[]{this.xWorld, this.yWorld, this.zWorld};
        DoubleProperty[] orbitHandlerCartesianCoordinates = new DoubleProperty[]{this.x, this.y, this.z};
        ObservableDoubleValue[] offsets = new ObservableDoubleValue[]{xOffset, yOffset, zOffset};
        for (int i = 0; i < 2; ++i) {
            MutableBoolean updating = new MutableBoolean(false);
            DoubleProperty orbitHandlerCartesianCoordinate = orbitHandlerCartesianCoordinates[i];
            ObservableDoubleValue offset = offsets[i];
            DoubleProperty cameraWorldCoordinate = cameraWorldCoordinates[i];
            cameraWorldCoordinate.addListener((o, oldValue, newValue) -> {
                if (updating.isTrue()) {
                    return;
                }
                updating.setTrue();
                orbitHandlerCartesianCoordinate.set(cameraWorldCoordinate.get() - offset.get());
                updating.setFalse();
            });
            offset.addListener((o, oldValue, newValue) -> {
                updating.setTrue();
                if (this.controlMode.getValue() == CameraControlMode.Position) {
                    orbitHandlerCartesianCoordinate.set(cameraWorldCoordinate.get() - offset.get());
                } else {
                    cameraWorldCoordinate.set(orbitHandlerCartesianCoordinate.get() + offset.get());
                }
                updating.setFalse();
            });
            orbitHandlerCartesianCoordinate.addListener((o, oldValue, newValue) -> {
                if (updating.isTrue()) {
                    return;
                }
                updating.setTrue();
                cameraWorldCoordinate.set(orbitHandlerCartesianCoordinate.get() + offset.get());
                updating.setFalse();
            });
        }
        MutableBoolean updating = new MutableBoolean(false);
        DoubleProperty orbitHandlerCartesianCoordinate = orbitHandlerCartesianCoordinates[2];
        ObservableDoubleValue offset = offsets[2];
        DoubleProperty cameraWorldCoordinate = cameraWorldCoordinates[2];
        cameraWorldCoordinate.addListener((o, oldValue, newValue) -> {
            if (updating.isTrue()) {
                return;
            }
            updating.setTrue();
            orbitHandlerCartesianCoordinate.set(cameraWorldCoordinate.get() - offset.get());
            updating.setFalse();
        });
        offset.addListener((o, oldValue, newValue) -> {
            updating.setTrue();
            if (this.controlMode.getValue() == CameraControlMode.Orbital) {
                cameraWorldCoordinate.set(orbitHandlerCartesianCoordinate.get() + offset.get());
            } else {
                orbitHandlerCartesianCoordinate.set(cameraWorldCoordinate.get() - offset.get());
            }
            updating.setFalse();
        });
        orbitHandlerCartesianCoordinate.addListener((o, oldValue, newValue) -> {
            if (updating.isTrue()) {
                return;
            }
            updating.setTrue();
            cameraWorldCoordinate.set(orbitHandlerCartesianCoordinate.get() + offset.get());
            updating.setFalse();
        });
        return new Tuple3DProperty(cameraWorldCoordinates);
    }

    public Affine getCameraPose() {
        return this.cameraPose;
    }

    public Property<CameraControlMode> controlMode() {
        return this.controlMode;
    }

    public final DoubleProperty latitudeProperty() {
        return this.latitude;
    }

    public final DoubleProperty longitudeProperty() {
        return this.longitude;
    }

    public final DoubleProperty rollProperty() {
        return this.roll;
    }

    public DoubleProperty xProperty() {
        return this.x;
    }

    public DoubleProperty yProperty() {
        return this.y;
    }

    public DoubleProperty zProperty() {
        return this.z;
    }

    public DoubleProperty xWorldProperty() {
        return this.xWorld;
    }

    public DoubleProperty yWorldProperty() {
        return this.yWorld;
    }

    public DoubleProperty zWorldProperty() {
        return this.zWorld;
    }

    public final BooleanProperty keepRotationLeveledProperty() {
        return this.keepRotationLeveled;
    }

    public final ObjectProperty<Predicate<MouseEvent>> fastModifierPredicateProperty() {
        return this.fastModifierPredicate;
    }

    public final DoubleProperty slowModifierProperty() {
        return this.slowModifier;
    }

    public final DoubleProperty fastModifierProperty() {
        return this.fastModifier;
    }

    public final DoubleProperty rollModifierProperty() {
        return this.rollModifier;
    }

    public final ObjectProperty<MouseButton> rotationMouseButtonProperty() {
        return this.rotationMouseButton;
    }

    public final BooleanProperty restrictLatitudeProperty() {
        return this.restrictLatitude;
    }

    public final DoubleProperty minLatitudeProperty() {
        return this.minLatitude;
    }

    public final DoubleProperty maxLatitudeProperty() {
        return this.maxLatitude;
    }

    public final DoubleProperty distanceProperty() {
        return this.distance;
    }

    public final DoubleProperty minDistanceProperty() {
        return this.minDistance;
    }

    public final DoubleProperty maxDistanceProperty() {
        return this.maxDistance;
    }

    public final DoubleProperty zoomSpeedFactorProperty() {
        return this.distanceModifier;
    }
}

