/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.tools;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import javafx.application.Application;
import javafx.stage.Stage;
import org.apache.commons.lang3.SystemUtils;

public class JavaFXApplicationCreator
extends Application {
    private static JavaFXApplicationCreator mainApplication;
    private static final CountDownLatch latch;
    private static JavaFXApplicationCreator startUpTest;
    private static List<Runnable> stopListeners;

    public JavaFXApplicationCreator() {
        this.setStartUpTest(this);
    }

    public static void verifyVSyncDisabledUbuntu() {
        if (SystemUtils.IS_OS_LINUX) {
            int glSyncToVBlankIntValue;
            String glSyncToVBlankProperty;
            String prism_vsync_name = "prism.vsync";
            String gl_vsync_name = "__GL_SYNC_TO_VBLANK";
            if (System.getProperty(prism_vsync_name) == null) {
                System.setProperty(prism_vsync_name, "false");
            }
            if ((glSyncToVBlankProperty = System.getenv(gl_vsync_name)) == null) {
                glSyncToVBlankIntValue = -1;
            } else {
                try {
                    glSyncToVBlankIntValue = Integer.parseInt(glSyncToVBlankProperty);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                    glSyncToVBlankIntValue = -1;
                }
            }
            if (glSyncToVBlankIntValue != 0) {
                System.err.println("%s: JavaFX performance warning: disable VSync for better multi-window performance, run with environment variable: %s=0".formatted(JavaFXApplicationCreator.class.getSimpleName(), gl_vsync_name));
            }
        }
    }

    private void setStartUpTest(JavaFXApplicationCreator startUpTest) {
        JavaFXApplicationCreator.startUpTest = startUpTest;
        latch.countDown();
    }

    private static JavaFXApplicationCreator waitForStartUpTest() {
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return startUpTest;
    }

    public static void attachStopListener(Runnable stopListener) {
        stopListeners.add(stopListener);
    }

    public void start(Stage primaryStage) throws Exception {
    }

    public void stop() throws Exception {
        for (Runnable stopListener : stopListeners) {
            stopListener.run();
        }
        mainApplication = null;
    }

    public static JavaFXApplicationCreator spawnJavaFXMainApplication() {
        if (mainApplication != null) {
            return mainApplication;
        }
        new Thread(() -> Application.launch(JavaFXApplicationCreator.class, (String[])new String[0]), "JavaFX-spawner").start();
        mainApplication = JavaFXApplicationCreator.waitForStartUpTest();
        return mainApplication;
    }

    static {
        JavaFXApplicationCreator.verifyVSyncDisabledUbuntu();
        latch = new CountDownLatch(1);
        startUpTest = null;
        stopListeners = new ArrayList<Runnable>();
    }
}

