/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.properties;

import java.lang.ref.WeakReference;
import javafx.beans.property.IntegerPropertyBase;
import javafx.beans.property.Property;
import org.apache.commons.lang3.mutable.MutableBoolean;
import us.ihmc.scs2.sessionVisualizer.jfx.properties.YoVariableProperty;
import us.ihmc.scs2.sharedMemory.LinkedYoInteger;
import us.ihmc.yoVariables.listener.YoVariableChangedListener;
import us.ihmc.yoVariables.variable.YoInteger;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoIntegerProperty
extends IntegerPropertyBase
implements YoVariableProperty<YoInteger, Number> {
    private final YoInteger yoInteger;
    private final Object bean;
    private final YoVariableChangedListener propertyUpdater = new YoIntegerPropertyUpdater(this);
    private LinkedYoInteger linkedBuffer;

    public YoIntegerProperty(YoInteger yoInteger) {
        this(yoInteger, null);
    }

    public YoIntegerProperty(YoInteger yoInteger, Object bean) {
        this.yoInteger = yoInteger;
        this.bean = bean;
        this.pullYoIntegerValue();
        yoInteger.addListener(this.propertyUpdater);
    }

    public void setLinkedBuffer(LinkedYoInteger linkedBuffer) {
        if (this.linkedBuffer != null) {
            this.linkedBuffer.removeUser((Object)this);
        }
        this.linkedBuffer = linkedBuffer;
        if (linkedBuffer != null) {
            linkedBuffer.addUser((Object)this);
            this.pullYoIntegerValue();
        }
    }

    public LinkedYoInteger getLinkedBuffer() {
        return this.linkedBuffer;
    }

    public void finalize() {
        this.dispose();
    }

    @Override
    public void dispose() {
        this.unbind();
        this.yoInteger.removeListener(this.propertyUpdater);
        if (this.linkedBuffer != null) {
            this.linkedBuffer.removeUser((Object)this);
            this.pullYoIntegerValue();
        }
    }

    public void set(int newValue) {
        super.set(newValue);
        this.yoInteger.set(newValue);
        if (this.linkedBuffer != null) {
            this.linkedBuffer.push();
        }
    }

    private void pullYoIntegerValue() {
        super.set(this.yoInteger.getValue());
    }

    public void bindIntegerProperty(Property<Integer> property) {
        property.setValue((Object)this.getValue());
        MutableBoolean updatingControl = new MutableBoolean(false);
        MutableBoolean updatingThis = new MutableBoolean(false);
        this.addListener((o, oldValue, newValue) -> {
            if (updatingThis.isTrue()) {
                return;
            }
            updatingControl.setTrue();
            property.setValue((Object)newValue.intValue());
            updatingControl.setFalse();
        });
        property.addListener((o, oldValue, newValue) -> {
            if (updatingControl.isTrue()) {
                return;
            }
            updatingThis.setTrue();
            this.set((int)newValue);
            updatingThis.setFalse();
        });
    }

    @Override
    public YoInteger getYoVariable() {
        return this.yoInteger;
    }

    public Object getBean() {
        return this.bean;
    }

    public String getName() {
        return this.yoInteger.getName();
    }

    private static class YoIntegerPropertyUpdater
    implements YoVariableChangedListener {
        private final WeakReference<YoIntegerProperty> propertyRef;

        public YoIntegerPropertyUpdater(YoIntegerProperty property) {
            this.propertyRef = new WeakReference<YoIntegerProperty>(property);
        }

        public void changed(YoVariable source) {
            YoIntegerProperty property = (YoIntegerProperty)this.propertyRef.get();
            if (property != null) {
                property.pullYoIntegerValue();
            }
        }
    }
}

