/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.camera;

import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.camera.CameraOrbitHandler;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.camera.LevelOrbitalCoordinateProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.camera.OrbitalCoordinateProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.properties.YoDoubleProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.Tuple3DProperty;

public class CameraBindingsHelper {
    static void removeCameraPositionBindings(Tuple3DProperty coordinates, CameraOrbitHandler orbitHandler) {
        orbitHandler.xWorldProperty().unbind();
        orbitHandler.yWorldProperty().unbind();
        orbitHandler.zWorldProperty().unbind();
        if (coordinates == null) {
            return;
        }
        if (coordinates.xProperty() != null) {
            orbitHandler.xWorldProperty().unbindBidirectional((Property)coordinates.xProperty());
        }
        if (coordinates.yProperty() != null) {
            orbitHandler.yWorldProperty().unbindBidirectional((Property)coordinates.yProperty());
        }
        if (coordinates.zProperty() != null) {
            orbitHandler.zWorldProperty().unbindBidirectional((Property)coordinates.zProperty());
        }
    }

    static void addCameraPositionBindings(Tuple3DProperty coordinates, CameraOrbitHandler orbitHandler) {
        if (coordinates == null) {
            return;
        }
        if (coordinates.xProperty() != null) {
            if (coordinates.xProperty() instanceof YoDoubleProperty) {
                orbitHandler.xWorldProperty().bind((ObservableValue)coordinates.xProperty());
            } else {
                orbitHandler.xWorldProperty().bindBidirectional((Property)coordinates.xProperty());
            }
        }
        if (coordinates.yProperty() != null) {
            if (coordinates.yProperty() instanceof YoDoubleProperty) {
                orbitHandler.yWorldProperty().bind((ObservableValue)coordinates.yProperty());
            } else {
                orbitHandler.yWorldProperty().bindBidirectional((Property)coordinates.yProperty());
            }
        }
        if (coordinates.zProperty() != null) {
            if (coordinates.zProperty() instanceof YoDoubleProperty) {
                orbitHandler.zWorldProperty().bind((ObservableValue)coordinates.zProperty());
            } else {
                orbitHandler.zWorldProperty().bindBidirectional((Property)coordinates.zProperty());
            }
        }
    }

    static void removeCameraOrbitalBindings(OrbitalCoordinateProperty coordinates, CameraOrbitHandler orbitHandler) {
        orbitHandler.distanceProperty().unbind();
        orbitHandler.longitudeProperty().unbind();
        orbitHandler.latitudeProperty().unbind();
        if (coordinates == null) {
            return;
        }
        if (coordinates.distanceProperty() != null) {
            orbitHandler.distanceProperty().unbindBidirectional((Property)coordinates.distanceProperty());
        }
        if (coordinates.longitudeProperty() != null) {
            orbitHandler.longitudeProperty().unbindBidirectional((Property)coordinates.longitudeProperty());
        }
        if (coordinates.latitudeProperty() != null) {
            orbitHandler.latitudeProperty().unbindBidirectional((Property)coordinates.latitudeProperty());
        }
    }

    static void addCameraOrbitalBindings(OrbitalCoordinateProperty coordinates, CameraOrbitHandler orbitHandler) {
        if (coordinates == null) {
            return;
        }
        if (coordinates.distanceProperty() != null) {
            if (coordinates.distanceProperty() instanceof YoDoubleProperty) {
                orbitHandler.distanceProperty().bind((ObservableValue)coordinates.distanceProperty());
            } else {
                orbitHandler.distanceProperty().bindBidirectional((Property)coordinates.distanceProperty());
            }
        }
        if (coordinates.longitudeProperty() != null) {
            if (coordinates.longitudeProperty() instanceof YoDoubleProperty) {
                orbitHandler.longitudeProperty().bind((ObservableValue)coordinates.longitudeProperty());
            } else {
                orbitHandler.longitudeProperty().bindBidirectional((Property)coordinates.longitudeProperty());
            }
        }
        if (coordinates.latitudeProperty() != null) {
            if (coordinates.latitudeProperty() instanceof YoDoubleProperty) {
                orbitHandler.latitudeProperty().bind((ObservableValue)coordinates.latitudeProperty());
            } else {
                orbitHandler.latitudeProperty().bindBidirectional((Property)coordinates.latitudeProperty());
            }
        }
    }

    static void removeCameraLevelOrbitalBindings(LevelOrbitalCoordinateProperty coordinates, CameraOrbitHandler orbitHandler) {
        orbitHandler.distanceProperty().unbind();
        orbitHandler.longitudeProperty().unbind();
        orbitHandler.zWorldProperty().unbind();
        if (coordinates == null) {
            return;
        }
        if (coordinates.distanceProperty() != null) {
            orbitHandler.distanceProperty().unbindBidirectional((Property)coordinates.distanceProperty());
        }
        if (coordinates.longitudeProperty() != null) {
            orbitHandler.longitudeProperty().unbindBidirectional((Property)coordinates.longitudeProperty());
        }
        if (coordinates.heightProperty() != null) {
            orbitHandler.zWorldProperty().unbindBidirectional((Property)coordinates.heightProperty());
        }
    }

    static void addCameraLevelOrbitalBindings(LevelOrbitalCoordinateProperty coordinates, CameraOrbitHandler orbitHandler) {
        if (coordinates == null) {
            return;
        }
        if (coordinates.distanceProperty() != null) {
            if (coordinates.distanceProperty() instanceof YoDoubleProperty) {
                orbitHandler.distanceProperty().bind((ObservableValue)coordinates.distanceProperty());
            } else {
                orbitHandler.distanceProperty().bindBidirectional((Property)coordinates.distanceProperty());
            }
        }
        if (coordinates.longitudeProperty() != null) {
            if (coordinates.longitudeProperty() instanceof YoDoubleProperty) {
                orbitHandler.longitudeProperty().bind((ObservableValue)coordinates.longitudeProperty());
            } else {
                orbitHandler.longitudeProperty().bindBidirectional((Property)coordinates.longitudeProperty());
            }
        }
        if (coordinates.heightProperty() != null) {
            if (coordinates.heightProperty() instanceof YoDoubleProperty) {
                orbitHandler.zWorldProperty().bind((ObservableValue)coordinates.heightProperty());
            } else {
                orbitHandler.zWorldProperty().bindBidirectional((Property)coordinates.heightProperty());
            }
        }
    }
}

