/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.yoComposite;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.YoCompositePattern;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.YoCompositeTools;
import us.ihmc.yoVariables.registry.YoNamespace;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoComposite
implements Comparable<YoComposite> {
    private final YoCompositePattern pattern;
    private final String name;
    private final YoNamespace namespace;
    private final List<YoVariable> yoComponents;
    private String uniqueName;
    private String uniqueShortName;

    public YoComposite(YoCompositePattern pattern, YoVariable yoVariable) {
        this(pattern, yoVariable.getName(), yoVariable.getNamespace(), Collections.singletonList(yoVariable));
    }

    public YoComposite(YoCompositePattern pattern, String compositeName, YoNamespace compositeNamespace, List<YoVariable> yoComponents) {
        this.pattern = pattern;
        this.name = compositeName;
        this.namespace = compositeNamespace;
        this.yoComponents = yoComponents;
    }

    public YoCompositePattern getPattern() {
        return this.pattern;
    }

    public String getName() {
        return this.name;
    }

    public YoNamespace getNamespace() {
        return this.namespace;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public String getUniqueShortName() {
        return this.uniqueShortName;
    }

    public String getFullname() {
        return this.namespace.toString() + "." + this.name;
    }

    public List<YoVariable> getYoComponents() {
        return this.yoComponents;
    }

    @Override
    public int compareTo(YoComposite oher) {
        return this.name.compareTo(oher.name);
    }

    public String toString() {
        return this.uniqueName != null ? this.uniqueName : this.name;
    }

    public static void computeUniqueNames(List<YoComposite> yoComposites) {
        Map<YoComposite, String> yoCompositeToUniqueNameMap = YoCompositeTools.computeUniqueNames(yoComposites, yoComposite -> yoComposite.getNamespace().getSubNames(), YoComposite::getName);
        yoCompositeToUniqueNameMap.forEach((yoComposite, uniqueName) -> {
            yoComposite.uniqueName = uniqueName;
        });
        Map<YoComposite, String> yoCompositeToUniqueShortNameMap = YoCompositeTools.computeUniqueShortNames(yoComposites, YoComposite::getName, YoComposite::getUniqueName);
        yoCompositeToUniqueShortNameMap.forEach((yoComposite, uniqueShortName) -> {
            yoComposite.uniqueShortName = uniqueShortName;
        });
    }
}

