/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.version;

import com.google.gson.Gson;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class SCS2VersionChecker {
    private static String CURRENT_BASE_VERSION;
    private static Release LATEST_RELEASE;
    private static String LATEST_BASE_VERSION;
    private static final URL REPOSITORY_API_URL;
    public static final URL REPOSITORY_URL;
    public static final URL DOWNLOAD_URL;

    public static String getCurrentBaseVersion() {
        if (CURRENT_BASE_VERSION == null) {
            String version = SCS2VersionChecker.class.getPackage().getImplementationVersion();
            CURRENT_BASE_VERSION = version == null ? "[source-code-version]" : SCS2VersionChecker.toBaseVersion(version);
        }
        return CURRENT_BASE_VERSION;
    }

    public static Release getLatestRelease() {
        if (LATEST_RELEASE == null) {
            OkHttpClient client = new OkHttpClient();
            Request request = new Request.Builder().url(REPOSITORY_API_URL).build();
            try (Response response = client.newCall(request).execute();){
                if (!response.isSuccessful()) {
                    throw new IOException("Unexpected code " + response);
                }
                Gson gson = new Gson();
                LATEST_RELEASE = (Release)gson.fromJson(response.body().string(), Release.class);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return LATEST_RELEASE;
    }

    public static String getLatestBaseVersion() {
        if (LATEST_BASE_VERSION == null) {
            LATEST_BASE_VERSION = SCS2VersionChecker.toBaseVersion(SCS2VersionChecker.getLatestRelease().tag_name);
        }
        return LATEST_BASE_VERSION;
    }

    public static String getLatestReleaseURL() {
        return SCS2VersionChecker.getLatestRelease().html_url;
    }

    public static boolean isLatestRelease() {
        return SCS2VersionChecker.getCurrentBaseVersion().equals(SCS2VersionChecker.getLatestBaseVersion());
    }

    private static String toBaseVersion(String version) {
        return version.replace("17-", "").replace("-java-17", "").trim();
    }

    static {
        try {
            REPOSITORY_API_URL = new URL("https://api.github.com/repos/ihmcrobotics/simulation-construction-set-2/releases/latest");
            REPOSITORY_URL = new URL("https://www.github.com/ihmcrobotics/simulation-construction-set-2");
            DOWNLOAD_URL = new URL("https://github.com/ihmcrobotics/simulation-construction-set-2/releases/latest");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static class Release {
        private String tag_name;
        private String html_url;
    }
}

