/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.managers;

import com.google.common.base.CaseFormat;
import jakarta.xml.bind.JAXBException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import us.ihmc.log.LogTools;
import us.ihmc.messager.SynchronizeHint;
import us.ihmc.messager.javafx.JavaFXMessager;
import us.ihmc.scs2.session.Session;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerTopics;
import us.ihmc.scs2.sessionVisualizer.jfx.charts.ChartGroupModel;
import us.ihmc.scs2.sessionVisualizer.jfx.charts.ChartIdentifier;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.BackgroundExecutorManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.Manager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.YoManager;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;
import us.ihmc.scs2.sessionVisualizer.jfx.xml.XMLTools;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.YoComposite;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.YoCompositeCollection;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.YoCompositePattern;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.YoCompositeTools;
import us.ihmc.yoVariables.listener.YoRegistryChangedListener;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;
import us.ihmc.yoVariables.variable.YoLong;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoCompositeSearchManager
implements Manager {
    public static final YoCompositePattern yoVariablePattern = YoCompositePattern.singleton(YoCompositeTools.YO_VARIABLE);
    public static final YoCompositePattern yoBooleanPattern = YoCompositePattern.singleton(YoCompositeTools.YO_BOOLEAN);
    public static final YoCompositePattern yoDoublePattern = YoCompositePattern.singleton(YoCompositeTools.YO_DOUBLE);
    public static final YoCompositePattern yoIntegerPattern = YoCompositePattern.singleton(YoCompositeTools.YO_INTEGER);
    public static final YoCompositePattern yoLongPattern = YoCompositePattern.singleton(YoCompositeTools.YO_LONG);
    private final Set<YoCompositePattern> primitivePatterns = new LinkedHashSet<YoCompositePattern>(Arrays.asList(yoVariablePattern, yoBooleanPattern, yoDoublePattern, yoIntegerPattern, yoLongPattern));
    private final Map<YoCompositePattern, Class<? extends YoVariable>> primitivePatternToClass = new HashMap<YoCompositePattern, Class<? extends YoVariable>>();
    private final Property<YoCompositeCollection> yoTuple2DCollection = new SimpleObjectProperty((Object)this, "yoTuple2DCollectionProperty", null);
    private final Property<YoCompositeCollection> yoTuple3DCollection = new SimpleObjectProperty((Object)this, "yoTuple3DCollectionProperty", null);
    private final Property<YoCompositeCollection> yoQuaternionCollection = new SimpleObjectProperty((Object)this, "yoQuaternionCollectionProperty", null);
    private final Property<YoCompositeCollection> yoYawPitchRollCollection = new SimpleObjectProperty((Object)this, "yoYawPitchRollCollectionProperty", null);
    private final List<YoCompositePattern> defaultCompositePatterns = new ArrayList<YoCompositePattern>();
    private final ObservableSet<YoCompositePattern> yoCompositePatterns = FXCollections.observableSet(new LinkedHashSet());
    private final ObservableSet<YoCompositePattern> customYoCompositePatterns = FXCollections.observableSet(new LinkedHashSet());
    private final ObservableMap<String, YoCompositePattern> typeToCompositePattern = FXCollections.observableMap(new LinkedHashMap());
    private final ObservableMap<String, Property<YoCompositeCollection>> typeToCompositeCollection = FXCollections.observableMap(new LinkedHashMap());
    private final Map<YoCompositePattern, Map<String, List<YoComposite>>> listOfYoCompositeMaps = new HashMap<YoCompositePattern, Map<String, List<YoComposite>>>();
    private final YoRegistryChangedListener rootRegistryChangeListener = change -> this.refreshYoCompositesInBackground();
    private final Property<Boolean> includeSCS2YoVariables;
    private final YoManager yoManager;
    private final BackgroundExecutorManager backgroundExecutorManager;
    private final ConcurrentHashMap<YoCompositePattern, Object> activeSearches = new ConcurrentHashMap();
    private volatile boolean isSessionActive = false;

    public YoCompositeSearchManager(JavaFXMessager messager, SessionVisualizerTopics topics, YoManager yoManager, BackgroundExecutorManager backgroundExecutorManager) {
        List<YoCompositePattern> compositePatterns;
        this.yoManager = yoManager;
        this.backgroundExecutorManager = backgroundExecutorManager;
        try {
            compositePatterns = XMLTools.loadYoCompositePatterns(SessionVisualizerIOTools.getConfigurationResource("DefaultYoCompositePatterns.scs2.yoComposite"));
        }
        catch (JAXBException | IOException e) {
            throw new RuntimeException("Failed to load the default " + YoCompositePattern.class.getSimpleName() + "s.", e);
        }
        this.typeToCompositePattern.addListener(change -> {
            if (change.wasAdded()) {
                this.yoCompositePatterns.add((Object)((YoCompositePattern)change.getValueAdded()));
            }
            if (change.wasRemoved()) {
                this.yoCompositePatterns.remove(change.getValueRemoved());
            }
        });
        this.primitivePatternToClass.put(yoVariablePattern, YoVariable.class);
        this.primitivePatternToClass.put(yoBooleanPattern, YoBoolean.class);
        this.primitivePatternToClass.put(yoDoublePattern, YoDouble.class);
        this.primitivePatternToClass.put(yoIntegerPattern, YoInteger.class);
        this.primitivePatternToClass.put(yoLongPattern, YoLong.class);
        for (YoCompositePattern primitivePattern : this.primitivePatterns) {
            String namePrefix = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, primitivePattern.getType());
            SimpleObjectProperty collection = new SimpleObjectProperty((Object)this, namePrefix + "CollectionProperty", null);
            this.typeToCompositeCollection.put((Object)primitivePattern.getType(), (Object)collection);
            this.typeToCompositePattern.put((Object)primitivePattern.getType(), (Object)primitivePattern);
            primitivePattern.getPreferredChartConfigurations().add(new ChartGroupModel("single", Collections.singletonList(new ChartIdentifier(0, 0))));
        }
        for (YoCompositePattern compositePattern : compositePatterns) {
            this.typeToCompositePattern.put((Object)compositePattern.getType(), (Object)compositePattern);
        }
        this.typeToCompositeCollection.put((Object)"YoTuple2D", this.yoTuple2DCollection);
        this.typeToCompositeCollection.put((Object)"YoTuple3D", this.yoTuple3DCollection);
        this.typeToCompositeCollection.put((Object)"YoQuaternion", this.yoQuaternionCollection);
        this.typeToCompositeCollection.put((Object)"YoYawPitchRoll", this.yoYawPitchRollCollection);
        this.defaultCompositePatterns.addAll(this.typeToCompositePattern.values());
        this.typeToCompositePattern.addListener(change -> {
            if (change.wasAdded()) {
                this.customYoCompositePatterns.add((Object)((YoCompositePattern)change.getValueAdded()));
            }
            if (change.wasRemoved()) {
                this.customYoCompositePatterns.remove(change.getValueRemoved());
            }
        });
        messager.addTopicListenerBase(topics.getYoCompositePatternLoadRequest(), m -> this.loadYoCompositePatternFromFile((File)m.getMessageContent(), m.getSynchronizeHint()));
        messager.addTopicListener(topics.getYoCompositePatternSaveRequest(), this::saveYoCompositePatternToFile);
        messager.addTopicListener(topics.getYoCompositeRefreshAll(), m -> this.refreshYoCompositesInBackground());
        this.includeSCS2YoVariables = messager.createPropertyInput(topics.getShowSCS2YoVariables(), (Object)false);
        this.includeSCS2YoVariables.addListener((o, oldValue, newValue) -> this.refreshYoCompositesInBackground());
    }

    @Override
    public void startSession(Session session) {
        LogTools.info((String)"Searching default YoComposite.");
        this.isSessionActive = true;
        this.typeToCompositePattern.values().forEach(this::searchYoCompositeNow);
        this.yoManager.getRootRegistry().addListener(this.rootRegistryChangeListener);
        LogTools.info((String)"Initialized default YoComposite.");
    }

    @Override
    public void stopSession() {
        this.isSessionActive = false;
        this.yoManager.getRootRegistry().removeListener(this.rootRegistryChangeListener);
        this.typeToCompositePattern.entrySet().removeIf(entry -> !this.defaultCompositePatterns.contains(entry.getValue()));
        this.typeToCompositeCollection.entrySet().removeIf(entry -> !this.typeToCompositePattern.containsKey(entry.getKey()));
        for (YoCompositePattern pattern : this.defaultCompositePatterns) {
            ((Property)this.typeToCompositeCollection.get((Object)pattern.getType())).setValue(null);
        }
        this.customYoCompositePatterns.clear();
        this.listOfYoCompositeMaps.clear();
    }

    @Override
    public boolean isSessionLoaded() {
        for (YoCompositePattern pattern : this.defaultCompositePatterns) {
            if (((Property)this.typeToCompositeCollection.get((Object)pattern.getType())).getValue() != null) continue;
            return false;
        }
        return true;
    }

    public void refreshYoCompositesInBackground() {
        this.typeToCompositePattern.values().forEach(this::searchYoCompositeInBackground);
    }

    public void searchYoCompositeInBackground(YoCompositePattern pattern) {
        this.searchYoCompositeInBackground(pattern, null);
    }

    public void searchYoCompositeInBackground(YoCompositePattern pattern, Consumer<YoCompositeCollection> callback) {
        this.backgroundExecutorManager.queueTaskToExecuteInBackground(this, () -> this.searchYoCompositeNow(pattern, callback));
    }

    public void searchYoCompositeNow(YoCompositePattern pattern) {
        this.searchYoCompositeNow(pattern, null);
    }

    /*
     * Exception decompiling
     */
    public void searchYoCompositeNow(YoCompositePattern pattern, Consumer<YoCompositeCollection> callback) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static List<YoComposite> collectPrimitiveYoComposites(YoCompositePattern pattern, Class<? extends YoVariable> primitiveClass, YoRegistry start, Predicate<YoRegistry> registryFilter) {
        return YoCompositeSearchManager.collectPrimitiveYoComposites(pattern, primitiveClass, start, registryFilter, new ArrayList<YoComposite>());
    }

    private static List<YoComposite> collectPrimitiveYoComposites(YoCompositePattern pattern, Class<? extends YoVariable> primitiveClass, YoRegistry start, Predicate<YoRegistry> registryFilter, List<YoComposite> compositesToPack) {
        if (registryFilter.test(start)) {
            for (YoVariable variable : start.getVariables()) {
                if (!primitiveClass.isInstance(variable)) continue;
                compositesToPack.add(new YoComposite(pattern, variable));
            }
            for (YoRegistry child : start.getChildren()) {
                YoCompositeSearchManager.collectPrimitiveYoComposites(pattern, primitiveClass, child, registryFilter, compositesToPack);
            }
        }
        return compositesToPack;
    }

    public void discardYoComposite(String typeToDiscard) {
        this.discardYoComposite(this.getPatternFromType(typeToDiscard));
    }

    public void discardYoComposite(YoCompositePattern patternToDiscard) {
        if (patternToDiscard == null || !this.customYoCompositePatterns.contains((Object)patternToDiscard)) {
            return;
        }
        this.typeToCompositePattern.remove((Object)patternToDiscard.getType());
        Property collectionProperty = (Property)this.typeToCompositeCollection.remove((Object)patternToDiscard.getType());
        if (collectionProperty != null) {
            collectionProperty.setValue(null);
        }
        this.listOfYoCompositeMaps.remove(patternToDiscard);
    }

    private void loadYoCompositePatternFromFile(File file, SynchronizeHint hint) {
        if (file == null) {
            return;
        }
        LogTools.info((String)("Loading file: " + file));
        try {
            List<YoCompositePattern> newPatterns = XMLTools.loadYoCompositePatterns(new FileInputStream(file));
            if (hint == SynchronizeHint.SYNCHRONOUS) {
                newPatterns.forEach(this::searchYoCompositeNow);
            } else {
                newPatterns.forEach(this::searchYoCompositeInBackground);
            }
        }
        catch (JAXBException | IOException e) {
            e.printStackTrace();
        }
    }

    public void saveYoCompositePatternToFile(File file) {
        if (!Platform.isFxApplicationThread()) {
            throw new IllegalStateException("Save must only be used from the FX Application Thread");
        }
        if (file == null) {
            return;
        }
        LogTools.info((String)("Saving file: " + file));
        ArrayList<YoCompositePattern> patternsToExport = new ArrayList<YoCompositePattern>(this.typeToCompositePattern.values());
        patternsToExport.removeAll(this.defaultCompositePatterns);
        try {
            XMLTools.saveYoCompositePatterns(new FileOutputStream(file), patternsToExport);
        }
        catch (JAXBException | IOException e) {
            e.printStackTrace();
        }
    }

    public void requestSearchListOfYoComposites(String compositeType, Consumer<Map<String, List<YoComposite>>> callback) {
        this.requestSearchListOfYoComposites(this.getPatternFromType(compositeType), callback);
    }

    public void requestSearchListOfYoComposites(YoCompositePattern compositeDefintion, Consumer<Map<String, List<YoComposite>>> callback) {
        if (this.listOfYoCompositeMaps.containsKey(compositeDefintion)) {
            callback.accept(this.listOfYoCompositeMaps.get(compositeDefintion));
            return;
        }
        this.backgroundExecutorManager.queueTaskToExecuteInBackground(this, () -> {
            Map<String, List<YoComposite>> result = YoCompositeTools.searchYoCompositeLists(this.getCollectionFromType(compositeDefintion.getType()));
            if (result != null) {
                JavaFXMissingTools.runLaterIfNeeded(this.getClass(), () -> {
                    this.listOfYoCompositeMaps.put(compositeDefintion, result);
                    callback.accept(result);
                });
            }
        });
    }

    public ObservableMap<String, Property<YoCompositeCollection>> typeToCompositeCollection() {
        return this.typeToCompositeCollection;
    }

    public YoComposite getYoComposite(String type, String fullname) {
        YoCompositeCollection collectionFromType = this.getCollectionFromType(type);
        if (collectionFromType != null) {
            return collectionFromType.getYoCompositeFromFullname(fullname);
        }
        return null;
    }

    public YoCompositeCollection getCollectionFromType(String type) {
        Property property = (Property)this.typeToCompositeCollection.get((Object)type);
        if (property != null) {
            return (YoCompositeCollection)property.getValue();
        }
        return null;
    }

    public ObservableSet<YoCompositePattern> yoCompositePatterns() {
        return this.yoCompositePatterns;
    }

    public ObservableSet<YoCompositePattern> customYoCompositePatterns() {
        return this.customYoCompositePatterns;
    }

    public YoCompositePattern getPatternFromType(String type) {
        return (YoCompositePattern)this.typeToCompositePattern.get((Object)type);
    }

    public YoCompositeCollection getYoVariableCollection() {
        return this.getCollectionFromType(yoVariablePattern.getType());
    }

    public YoCompositeCollection getYoBooleanCollection() {
        return this.getCollectionFromType(yoBooleanPattern.getType());
    }

    public YoCompositeCollection getYoDoubleCollection() {
        return this.getCollectionFromType(yoDoublePattern.getType());
    }

    public YoCompositeCollection getYoIntegerCollection() {
        return this.getCollectionFromType(yoIntegerPattern.getType());
    }

    public YoCompositeCollection getYoLongCollection() {
        return this.getCollectionFromType(yoLongPattern.getType());
    }

    public YoCompositeCollection getYoTuple2DCollection() {
        return (YoCompositeCollection)this.yoTuple2DCollection.getValue();
    }

    public YoCompositeCollection getYoTuple3DCollection() {
        return (YoCompositeCollection)this.yoTuple3DCollection.getValue();
    }

    public YoCompositeCollection getYoQuaternionCollection() {
        return (YoCompositeCollection)this.yoQuaternionCollection.getValue();
    }

    public YoCompositeCollection getYoYawPitchRollCollection() {
        return (YoCompositeCollection)this.yoYawPitchRollCollection.getValue();
    }

    private /* synthetic */ void lambda$searchYoCompositeNow$12(String type, YoCompositePattern pattern, YoCompositeCollection collection) {
        Property property = (Property)this.typeToCompositeCollection.get((Object)type);
        if (property == null) {
            String propertyName = type + "CollectionProperty";
            property = new SimpleObjectProperty((Object)this, propertyName, null);
            this.typeToCompositeCollection.put((Object)type, (Object)property);
            this.typeToCompositePattern.put((Object)type, (Object)pattern);
        }
        property.setValue((Object)collection);
    }

    private /* synthetic */ void lambda$searchYoCompositeNow$11(String type, YoCompositeCollection collection) {
        ((Property)this.typeToCompositeCollection.get((Object)type)).setValue((Object)collection);
    }

    private static /* synthetic */ boolean lambda$searchYoCompositeNow$10(YoRegistry reg) {
        return !reg.getNamespace().equals((Object)Session.SESSION_INTERNAL_NAMESPACE);
    }

    private static /* synthetic */ boolean lambda$searchYoCompositeNow$9(YoRegistry reg) {
        return true;
    }
}

