/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.sliderboard.bcf2000;

import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.Slider;
import javafx.scene.control.TextField;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.definition.yoSlider.YoSliderDefinition;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.sliderboard.YoVariableSlider;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.sliderboard.bcf2000.YoBCF2000InputController;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.YoManager;
import us.ihmc.scs2.sessionVisualizer.sliderboard.MidiChannelConfig;
import us.ihmc.scs2.sessionVisualizer.sliderboard.SliderboardVariable;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoBCF2000SliderController
extends YoBCF2000InputController {
    @FXML
    private VBox rootPane;
    @FXML
    private TextField sliderMaxTextField;
    @FXML
    private TextField sliderMinTextField;
    @FXML
    private Slider slider;
    @FXML
    private Label yoVariableDropLabel;
    private SliderboardVariable sliderVariable;
    private YoVariableSlider yoVariableSlider;
    private YoManager yoManager;
    private MidiChannelConfig sliderChannel;

    public void initialize(SessionVisualizerToolkit toolkit, MidiChannelConfig sliderChannel, SliderboardVariable sliderVariable) {
        this.sliderChannel = sliderChannel;
        this.sliderVariable = sliderVariable;
        this.yoManager = toolkit.getYoManager();
        super.initialize(toolkit, (Region)this.rootPane, (Labeled)this.yoVariableDropLabel);
        this.clear();
    }

    @Override
    public void clear() {
        if (this.yoVariableSlider != null) {
            this.yoVariableSlider.dispose();
        }
        this.yoVariableSlider = null;
        super.clear();
        this.slider.setDisable(true);
        this.sliderMaxTextField.setText("");
        this.sliderMinTextField.setText("");
        this.sliderMaxTextField.setDisable(true);
        this.sliderMinTextField.setDisable(true);
    }

    public void setInput(YoSliderDefinition definition) {
        YoVariable yoVariable;
        if (definition == null) {
            this.clear();
            return;
        }
        if (definition.getVariableName() != null) {
            yoVariable = this.yoManager.getRootRegistryDatabase().searchExact(definition.getVariableName());
            if (yoVariable == null) {
                LogTools.warn((String)("Could not find variable for slider: " + definition.getVariableName()));
            }
        } else {
            yoVariable = null;
        }
        this.setYoVariableInput(yoVariable, definition.getMinValue(), definition.getMaxValue());
    }

    @Override
    public void setYoVariableInput(YoVariable yoVariable) {
        this.setYoVariableInput(yoVariable, null, null);
    }

    private void setYoVariableInput(YoVariable yoVariable, String minValue, String maxValue) {
        if (this.yoVariableSlider != null) {
            this.yoVariableSlider.dispose();
        }
        if (yoVariable == null) {
            this.clear();
            return;
        }
        this.slider.setDisable(false);
        this.yoVariableSlider = YoVariableSlider.newYoVariableSlider(yoVariable, this.yoManager.getLinkedRootRegistry());
        this.yoVariableSlider.bindMinTextField(this.sliderMinTextField);
        this.yoVariableSlider.bindMaxTextField(this.sliderMaxTextField);
        if (this.sliderVariable != null) {
            this.yoVariableSlider.bindSliderVariable(this.sliderVariable);
        }
        this.yoVariableSlider.bindVirtualSlider(this.slider);
        if (minValue != null && !this.sliderMinTextField.isDisabled()) {
            if (this.isMinValid(yoVariable, minValue)) {
                this.sliderMinTextField.setText(minValue);
            } else {
                LogTools.warn((String)"Discarding invalid minValue (={}) for slider bound to the variable {}", (Object)minValue, (Object)yoVariable);
            }
        }
        if (maxValue != null && !this.sliderMaxTextField.isDisabled()) {
            if (this.isMaxValid(yoVariable, maxValue)) {
                this.sliderMaxTextField.setText(maxValue);
            } else {
                LogTools.warn((String)"Discarding invalid maxValue (={}) for slider bound to the variable {}", (Object)maxValue, (Object)yoVariable);
            }
        }
        this.setupYoVariableSlider(this.yoVariableSlider);
    }

    public YoSliderDefinition toYoSliderDefinition() {
        YoSliderDefinition definition = this.yoVariableSlider == null ? new YoSliderDefinition() : this.yoVariableSlider.toYoSliderDefinition();
        definition.setIndex(this.sliderChannel.ordinal());
        return definition;
    }
}

