/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.editor;

import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.fxml.FXML;
import javafx.scene.control.ComboBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.shape.DrawMode;
import us.ihmc.scs2.definition.visual.PaintDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphic3DDefinition;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.editor.color.ColorEditorController;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFX3D;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.color.BaseColorFX;

public class YoGraphic3DStyleEditorPaneController {
    @FXML
    private VBox mainPane;
    @FXML
    private ColorEditorController colorEditorController;
    @FXML
    private Pane drawModeContainer;
    @FXML
    private ComboBox<DrawMode> drawModeComboBox;

    public void initialize(SessionVisualizerToolkit toolkit) {
        this.colorEditorController.initialize(toolkit);
        this.drawModeComboBox.getItems().addAll((Object[])DrawMode.values());
        this.drawModeComboBox.getSelectionModel().select((Object)DrawMode.FILL);
    }

    public void setInput(YoGraphic3DDefinition definition) {
        this.setInput(definition.getColor());
    }

    public void setInput(PaintDefinition definition) {
        this.colorEditorController.setInput(definition);
    }

    public void setInput(String drawMode) {
        if (drawMode == null) {
            this.drawModeComboBox.setValue((Object)DrawMode.FILL);
            return;
        }
        drawMode = drawMode.trim();
        if (DrawMode.LINE.name().equalsIgnoreCase(drawMode) || "WIREFRAME".equalsIgnoreCase(drawMode)) {
            this.drawModeComboBox.setValue((Object)DrawMode.LINE);
        } else {
            this.drawModeComboBox.setValue((Object)DrawMode.FILL);
        }
    }

    public void bindYoGraphicFX3D(YoGraphicFX3D yoGraphicFX3DToBind) {
        this.colorEditorController.colorProperty().addListener((o, oldValue, newValue) -> yoGraphicFX3DToBind.setColor((BaseColorFX)newValue));
        this.drawModeComboBox.valueProperty().addListener((o, oldValue, newValue) -> yoGraphicFX3DToBind.setDrawMode((DrawMode)newValue));
    }

    public void addInputNotification(Runnable callback) {
        this.colorEditorController.colorProperty().addListener((o, oldValue, newValue) -> callback.run());
        this.drawModeComboBox.valueProperty().addListener((o, oldValue, newValue) -> callback.run());
    }

    public ObservableBooleanValue inputsValidityProperty() {
        return this.colorEditorController.inputsValidityProperty();
    }

    public ReadOnlyObjectProperty<BaseColorFX> colorProperty() {
        return this.colorEditorController.colorProperty();
    }

    public Property<DrawMode> drawModeProperty() {
        return this.drawModeComboBox.valueProperty();
    }

    public Pane getMainPane() {
        return this.mainPane;
    }
}

